/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.internal.LaunchBarManager;
import org.eclipse.launchbar.core.internal.target.LaunchTargetManager;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.launchbar.core";
    private static Activator plugin;
    private static LaunchTargetManager launchTargetManager;
    private static LaunchBarManager launchBarManager;
    private static final String DEBUG_ONE = "org.eclipse.launchbar.core/debug/launchbar";

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        launchTargetManager = new LaunchTargetManager();
        bundleContext.registerService(ILaunchTargetManager.class, (Object)launchTargetManager, null);
        launchBarManager = new LaunchBarManager();
        bundleContext.registerService(ILaunchBarManager.class, (Object)launchBarManager, null);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        plugin = null;
        launchTargetManager = null;
        launchBarManager = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static LaunchBarManager getLaunchBarManager() {
        return launchBarManager;
    }

    public static LaunchTargetManager getLaunchTargetManager() {
        return launchTargetManager;
    }

    public static <T> T getService(Class<T> service) {
        BundleContext context = plugin.getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        return (T)(ref != null ? context.getService(ref) : null);
    }

    public static void throwCoreException(Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, PLUGIN_ID, e.getLocalizedMessage(), (Throwable)e));
    }

    public static void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        } else {
            System.err.println(status.getMessage());
        }
    }

    public static void log(Throwable exception) {
        if (exception instanceof CoreException) {
            Activator.log(((CoreException)exception).getStatus());
        } else {
            Activator.log((IStatus)new Status(4, PLUGIN_ID, exception.getLocalizedMessage(), exception));
        }
    }

    public static void trace(String str) {
        if (plugin == null || plugin.isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_ONE))) {
            System.out.println("launchbar: " + str);
        }
    }
}

