/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messageflow;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros2.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.AbstractRos2StateSystemAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.IRos2ModelProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messagelinks.Ros2MessageCausalLinksAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.Ros2ModelUtils;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2FlowTargetInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowModel;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messagelinks.Ros2MessageCausalLinksModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class Ros2MessageFlowAnalysis
extends TmfAbstractAnalysisModule
implements IRos2ModelProvider<Ros2MessageFlowModel> {
    public static final @NonNull String TARGET_INFO_KEY = "target.info";
    private static final @NonNull String ID_SUFFIX = ".messageflow";
    private @Nullable IProgressMonitor fMonitor;
    private @Nullable Ros2MessageFlowModel fModel = null;

    public Ros2MessageFlowAnalysis() {
        this.setId(Ros2MessageFlowAnalysis.getFullAnalysisId());
        this.addParameter(TARGET_INFO_KEY);
    }

    public static @NonNull String getFullAnalysisId() {
        return AbstractRos2StateSystemAnalysis.getAnalysisIdFromSuffix(ID_SUFFIX);
    }

    @Override
    public @Nullable Ros2MessageFlowModel getModel() {
        return this.fModel;
    }

    public boolean canExecute(@NonNull ITmfTrace trace) {
        return trace.getParent() == null;
    }

    protected boolean executeAnalysis(@NonNull IProgressMonitor monitor) {
        Object info = this.getParameter(TARGET_INFO_KEY);
        if (!(info instanceof Ros2FlowTargetInfo)) {
            Activator.getInstance().logError("No target set; not executing!");
            return false;
        }
        Ros2FlowTargetInfo targetInfo = (Ros2FlowTargetInfo)info;
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return false;
        }
        ITmfStateSystem objectsSs = Ros2ModelUtils.getStateSystemFromAnalysis(trace, Ros2ObjectsAnalysis.class, Ros2ObjectsAnalysis.getFullAnalysisId());
        if (objectsSs == null) {
            return false;
        }
        ITmfStateSystem messagesSs = Ros2ModelUtils.getStateSystemFromAnalysis(trace, Ros2MessagesAnalysis.class, Ros2MessagesAnalysis.getFullAnalysisId());
        if (messagesSs == null) {
            return false;
        }
        Ros2MessageCausalLinksModel messageLinksModel = (Ros2MessageCausalLinksModel)Ros2ModelUtils.getModelFromAnalysis(trace, Ros2MessageCausalLinksAnalysis.class, Ros2MessageCausalLinksAnalysis.getFullAnalysisId());
        if (messageLinksModel == null) {
            return false;
        }
        Ros2MessageFlowModel model = new Ros2MessageFlowModel(targetInfo, objectsSs, messagesSs, messageLinksModel);
        if (!monitor.isCanceled()) {
            model.generateModel();
        }
        this.fModel = model;
        return this.fModel.isDone() && !monitor.isCanceled();
    }

    protected void parameterChanged(@NonNull String name) {
        if (name.equals(TARGET_INFO_KEY)) {
            this.cancel();
            this.resetAnalysis();
            this.schedule();
        }
    }

    protected @NonNull Iterable<@NonNull IAnalysisModule> getDependentAnalyses() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return Collections.emptySet();
        }
        Ros2ObjectsAnalysis objectsAnalysis = (Ros2ObjectsAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, Ros2ObjectsAnalysis.class, (String)Ros2ObjectsAnalysis.getFullAnalysisId());
        if (objectsAnalysis == null) {
            return Collections.emptySet();
        }
        Ros2MessagesAnalysis messagesAnalysis = (Ros2MessagesAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, Ros2MessagesAnalysis.class, (String)Ros2MessagesAnalysis.getFullAnalysisId());
        if (messagesAnalysis == null) {
            return Collections.emptySet();
        }
        Ros2MessageCausalLinksAnalysis messageLinksAnalysis = (Ros2MessageCausalLinksAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, Ros2MessageCausalLinksAnalysis.class, (String)Ros2MessageCausalLinksAnalysis.getFullAnalysisId());
        if (messageLinksAnalysis == null) {
            return Collections.emptySet();
        }
        return Arrays.asList(new IAnalysisModule[]{objectsAnalysis, messagesAnalysis, messageLinksAnalysis});
    }

    protected void canceling() {
        IProgressMonitor mon = this.fMonitor;
        if (mon != null && !mon.isCanceled()) {
            mon.setCanceled(true);
        }
    }
}

