/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowBuildInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;

public abstract class Ros2MessageFlowSegment {
    private final long fStartTime;
    private final long fEndTime;
    private final @Nullable Ros2ObjectHandle fNodeHandle;
    private final Collection<@NonNull Ros2MessageFlowSegment> fPrevious = new ArrayList<Ros2MessageFlowSegment>();
    private final Collection<@NonNull Ros2MessageFlowSegment> fNext = new ArrayList<Ros2MessageFlowSegment>();

    protected Ros2MessageFlowSegment(long startTime, long endTime, @Nullable Ros2ObjectHandle nodeHandle) {
        this.fStartTime = startTime;
        this.fEndTime = endTime;
        this.fNodeHandle = nodeHandle;
    }

    public void addNext(@NonNull Ros2MessageFlowSegment next) {
        this.fNext.add(next);
    }

    public Collection<@NonNull Ros2MessageFlowSegment> getNext() {
        return this.fNext;
    }

    public void addPrevious(@NonNull Ros2MessageFlowSegment previous) {
        this.fPrevious.add(previous);
    }

    public Collection<@NonNull Ros2MessageFlowSegment> getPrevious() {
        return this.fPrevious;
    }

    public boolean hasNext() {
        return !this.fNext.isEmpty();
    }

    public boolean hasPrevious() {
        return !this.fPrevious.isEmpty();
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public long getEndTime() {
        return this.fEndTime;
    }

    public boolean isLink() {
        return this.fNodeHandle == null;
    }

    public @Nullable Ros2ObjectHandle getNodeHandle() {
        return this.fNodeHandle;
    }

    public abstract @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectSuccessors(@NonNull Ros2MessageFlowBuildInfo var1);

    public abstract @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectPredecessors(@NonNull Ros2MessageFlowBuildInfo var1);

    public int hashCode() {
        return Objects.hash(this.fStartTime, this.fEndTime, this.fPrevious, this.fNext);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ros2MessageFlowSegment)) {
            return false;
        }
        Ros2MessageFlowSegment o = (Ros2MessageFlowSegment)obj;
        return this.fStartTime == o.fStartTime && this.fEndTime == o.fEndTime;
    }

    public String toString() {
        return String.format("startTime=%d, endTime=%d", this.fStartTime, this.fEndTime);
    }
}

