/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.OutputElementStyle;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Range;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.XYAxisDescription;

@Schema(description="This model includes the series output style values.")
public interface SeriesModel {
    @Schema(description="Series' ID", requiredMode=Schema.RequiredMode.REQUIRED)
    public long getSeriesId();

    @Schema(description="Series' name", requiredMode=Schema.RequiredMode.REQUIRED)
    public @NonNull String getSeriesName();

    @JsonProperty(value="xValues")
    @Schema(description="X values as list of int64 values (e.g. timestamps). Example: [100, 200, 350]. Mutually exclusive with xCategories/xRanges.")
    public List<Long> getXValues();

    @JsonProperty(value="xCategories")
    @Schema(description="X values as list of category strings. Example: [\"READ\", \"WRITE\"]. Mutually exclusive with xValues/xRanges.")
    public List<String> getXCategories();

    @JsonProperty(value="xRanges")
    @Schema(description="X values as list of start/end range objects. Example: [{\"start\": 10, \"end\": 20}, {\"start\": 50, \"end\": 75}]. Mutually exclusive with xValues/xCategories.")
    public List<Range> getXRanges();

    @JsonProperty(value="yValues")
    @ArraySchema(arraySchema=@Schema(description="Series' Y values"), schema=@Schema(requiredMode=Schema.RequiredMode.REQUIRED))
    public double[] getYValues();

    @JsonProperty(value="xValuesDescription")
    @Schema(description="Series' X axis description", requiredMode=Schema.RequiredMode.REQUIRED)
    public XYAxisDescription getXAxisDescription();

    @JsonProperty(value="yValuesDescription")
    @Schema(description="Series' Y axis description", requiredMode=Schema.RequiredMode.REQUIRED)
    public XYAxisDescription getYAxisDescription();

    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    public @NonNull OutputElementStyle getStyle();
}

