/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.internal.IDropAction;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;

public abstract class AbstractDropAction
implements IDropAction {
    protected boolean insert(String text, IEditorPart targetEditor) {
        if (text == null || text.length() == 0) {
            return true;
        }
        ITextSelection textSelection = null;
        IDocument doc = null;
        ITextSelection selection = null;
        ISourceEditingTextTools tools = (ISourceEditingTextTools)targetEditor.getAdapter(ISourceEditingTextTools.class);
        if (tools != null) {
            doc = tools.getDocument();
            selection = tools.getSelection();
        }
        ITextEditor textEditor = null;
        if (targetEditor instanceof ITextEditor) {
            textEditor = (ITextEditor)targetEditor;
        }
        if (textEditor == null) {
            textEditor = (ITextEditor)targetEditor.getAdapter(ITextEditor.class);
        }
        if (textEditor == null && tools != null && tools.getEditorPart() instanceof ITextEditor) {
            textEditor = (ITextEditor)tools.getEditorPart();
        }
        if (textEditor == null && tools != null && tools.getEditorPart() != null) {
            textEditor = (ITextEditor)tools.getEditorPart().getAdapter(ITextEditor.class);
        }
        if (selection == null && textEditor != null) {
            selection = textEditor.getSelectionProvider().getSelection();
        }
        if (doc == null && textEditor != null) {
            doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        }
        if (selection instanceof ITextSelection) {
            textSelection = selection;
            try {
                doc.replace(textSelection.getOffset(), textSelection.getLength(), text);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        if (textEditor != null && textSelection != null) {
            ISelectionProvider sp = textEditor.getSelectionProvider();
            TextSelection sel = new TextSelection(textSelection.getOffset(), text.length());
            sp.setSelection((ISelection)sel);
            textEditor.selectAndReveal(sel.getOffset(), sel.getLength());
        }
        return true;
    }

    @Override
    public boolean isSupportedData(Object data) {
        return true;
    }

    @Override
    public abstract boolean run(DropTargetEvent var1, IEditorPart var2);
}

