/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.hyperlink;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

class ExternalFileHyperlink
implements IHyperlink {
    private IRegion fHyperlinkRegion;
    private File fHyperlinkFile;

    public ExternalFileHyperlink(IRegion region, File file) {
        this.fHyperlinkFile = file;
        this.fHyperlinkRegion = region;
    }

    public IRegion getHyperlinkRegion() {
        return this.fHyperlinkRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        String editorLabel;
        String path = this.fHyperlinkFile.getPath();
        if (path.length() > 60) {
            path = String.valueOf(path.substring(0, 25)) + "..." + path.substring(path.length() - 25, path.length());
        }
        if ((editorLabel = this.getEditorLabel()) != null) {
            return NLS.bind((String)XMLUIMessages.Open_With, (Object)path, (Object)editorLabel);
        }
        return NLS.bind((String)XMLUIMessages.Open, (Object)path);
    }

    private String getEditorLabel() {
        IFileStore store = EFS.getLocalFileSystem().getStore(this.fHyperlinkFile.toURI());
        String name = store.fetchInfo().getName();
        if (name == null) {
            return null;
        }
        IContentType contentType = null;
        try (InputStream is = null;){
            is = store.openInputStream(0, null);
            contentType = Platform.getContentTypeManager().findContentTypeFor(is, name);
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(name, contentType);
        return descriptor != null ? descriptor.getLabel() : null;
    }

    public void open() {
        if (this.fHyperlinkFile != null) {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IFileStore store = EFS.getLocalFileSystem().getStore(this.fHyperlinkFile.toURI());
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)store);
            }
            catch (PartInitException e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
    }
}

