/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ToolbarLayout
extends Layout {
    private static final int SPACING = 5;
    private static final int EXTRA_BUSY_SPACING = 2;
    private static final int MARGIN = 2;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (hHint != -1) {
            return new Point(wHint, hHint);
        }
        Control[] children = composite.getChildren();
        int h = 0;
        int size = children.length;
        int i = 0;
        while (i < size) {
            h = Math.max(h, children[i].computeSize((int)-1, (int)-1).y);
            ++i;
        }
        return new Point(wHint, h + 4);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control[] children = composite.getChildren();
        Rectangle r = composite.getClientArea();
        int size = children.length;
        Point[] sizes = new Point[size];
        int i = 0;
        while (i < size) {
            sizes[i] = children[i].computeSize(-1, -1);
            ++i;
        }
        int h = r.height - 4;
        int busy = size - 1;
        children[busy].setBounds(r.x + r.width - 2 - sizes[busy].x, r.y + 2 + (h - sizes[busy].y) / 2, sizes[busy].x, sizes[busy].y);
        int combo = -1;
        int tw = r.width - 4 - (size - 1) * 5 - sizes[size - 1].x - 2;
        int i2 = 0;
        while (i2 < size - 1) {
            if (children[i2] instanceof Combo) {
                combo = i2;
            } else {
                tw -= sizes[i2].x;
            }
            ++i2;
        }
        if (combo >= 0) {
            sizes[combo].x = tw;
        }
        int x = 2;
        int i3 = 0;
        while (i3 < size - 1) {
            children[i3].setBounds(r.x + x, r.y + 2 + (h - sizes[i3].y) / 2, sizes[i3].x, sizes[i3].y);
            x += 5 + sizes[i3].x;
            ++i3;
        }
    }
}

