/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.data;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.tests.ActivatorTest;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.IntervalInfo;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.StateIntervalStub;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.Assert;

@NonNullByDefault
public abstract class CallStackTestData {
    private @Nullable TmfXmlTraceStub fTrace;
    private @Nullable List<ExpectedCallStackElement> fCallStackRawData = null;

    public ITmfTrace getTrace() {
        TmfXmlTraceStub trace = this.fTrace;
        if (trace == null) {
            trace = new TmfXmlTraceStubNs();
            IPath filePath = ActivatorTest.getAbsoluteFilePath(this.getTraceFile());
            IStatus status = trace.validate(null, filePath.toOSString());
            if (!status.isOK()) {
                Assert.fail((String)status.getException().getMessage());
            }
            try {
                trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
            }
            catch (TmfTraceException e) {
                Assert.fail((String)e.getMessage());
            }
            trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
            this.fTrace = trace;
        }
        return trace;
    }

    protected abstract String getTraceFile();

    protected abstract long getStartTime();

    protected abstract long getEndTime();

    protected void setCallStackData(List<ExpectedCallStackElement> elements) {
        this.fCallStackRawData = elements;
    }

    public void dispose() {
        TmfXmlTraceStub trace = this.fTrace;
        if (trace != null) {
            trace.dispose();
            this.fTrace = null;
        }
    }

    public int getNumberOfProcesses() {
        List<ExpectedCallStackElement> data = this.fCallStackRawData;
        if (data == null) {
            throw new NullPointerException("The callstack data has not been set");
        }
        TreeSet<Integer> pids = new TreeSet<Integer>();
        for (ExpectedCallStackElement element : data) {
            pids.add(element.fPid);
        }
        return pids.size();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Set<IntervalInfo> toStateSystemInterval(String processPattern) {
        List<ExpectedCallStackElement> callStackData = this.fCallStackRawData;
        if (callStackData == null) {
            throw new NullPointerException("The callstack data has not been set");
        }
        HashSet<IntervalInfo> intervals = new HashSet<IntervalInfo>();
        for (ExpectedCallStackElement expected : callStackData) {
            @NonNull @NonNull Multimap intervalsByDepth = (Multimap)Objects.requireNonNull(LinkedHashMultimap.create());
            HashMap<Integer, ITmfStateInterval> lastIntervals = new HashMap<Integer, ITmfStateInterval>();
            for (ExpectedFunction expectedFunction : expected.fCalls) {
                this.createIntervalsRecursive(expectedFunction, (Multimap<Integer, ITmfStateInterval>)intervalsByDepth, lastIntervals, 1);
            }
            for (Map.Entry entry : lastIntervals.entrySet()) {
                if (((ITmfStateInterval)entry.getValue()).getEndTime() < this.getEndTime()) {
                    intervalsByDepth.put((Object)((Integer)entry.getKey()), (Object)new StateIntervalStub((int)((ITmfStateInterval)entry.getValue()).getEndTime() + 1, (int)this.getEndTime(), null));
                }
                intervals.add(new IntervalInfo(new ArrayList(intervalsByDepth.get((Object)((Integer)entry.getKey()))), new String[]{processPattern, String.valueOf(expected.fPid), String.valueOf(expected.fTid), "CallStack", String.valueOf(entry.getKey())}));
            }
        }
        return intervals;
    }

    private void createIntervalsRecursive(ExpectedFunction expFunction, Multimap<Integer, ITmfStateInterval> intervals, Map<Integer, ITmfStateInterval> lastIntervals, int depth) {
        long start;
        ITmfStateInterval lastAtDepth = lastIntervals.get(depth);
        long l = start = lastAtDepth == null ? this.getStartTime() : lastAtDepth.getEndTime() + 1L;
        if (start < (long)expFunction.fStart) {
            intervals.put((Object)depth, (Object)new StateIntervalStub((int)start, expFunction.fStart - 1, null));
        }
        StateIntervalStub newInterval = new StateIntervalStub(expFunction.fStart, expFunction.fEnd - 1, (Object)expFunction.fFunction);
        intervals.put((Object)depth, (Object)newInterval);
        lastIntervals.put(depth, (ITmfStateInterval)newInterval);
        for (ExpectedFunction expChild : expFunction.fChildren) {
            this.createIntervalsRecursive(expChild, intervals, lastIntervals, depth + 1);
        }
    }

    public Map<Integer, Map<String, AggregateData>> getExpectedCallGraph() {
        List<ExpectedCallStackElement> callStackData = this.fCallStackRawData;
        if (callStackData == null) {
            throw new NullPointerException("The callstack data has not been set");
        }
        HashMap<Integer, Map<String, AggregateData>> callgraph = new HashMap<Integer, Map<String, AggregateData>>();
        for (ExpectedCallStackElement expected : callStackData) {
            HashMap<String, AggregateData> aggregate = new HashMap<String, AggregateData>();
            for (ExpectedFunction expFunction : expected.fCalls) {
                this.createCallGraphRecursive(expFunction, aggregate);
            }
            callgraph.put(expected.fTid, aggregate);
        }
        return callgraph;
    }

    private void createCallGraphRecursive(ExpectedFunction expFunction, Map<String, AggregateData> aggregate) {
        AggregateData aggregateData = aggregate.get(expFunction.fFunction);
        if (aggregateData == null) {
            aggregateData = new AggregateData();
            aggregate.put(expFunction.fFunction, aggregateData);
        }
        aggregateData.addCall(expFunction);
        HashMap<String, AggregateData> childAggregate = new HashMap<String, AggregateData>();
        for (ExpectedFunction expChild : expFunction.fChildren) {
            this.createCallGraphRecursive(expChild, childAggregate);
        }
        aggregateData.addChildren(childAggregate);
    }

    public static class AggregateData {
        private long fDuration = 0L;
        private long fSelfTime = 0L;
        private int fNbCalls = 0;
        private Map<String, AggregateData> fChildren = new HashMap<String, AggregateData>();

        private void addCall(ExpectedFunction expFunction) {
            this.fDuration += expFunction.getDuration();
            this.fSelfTime += expFunction.getSelfTime();
            ++this.fNbCalls;
        }

        private void addChildren(Map<String, AggregateData> children) {
            for (Map.Entry<String, AggregateData> child : children.entrySet()) {
                AggregateData aggregateData = this.fChildren.get(child.getKey());
                AggregateData childData = child.getValue();
                if (aggregateData == null) {
                    this.fChildren.put(child.getKey(), childData);
                    continue;
                }
                aggregateData.fDuration += childData.fDuration;
                aggregateData.fSelfTime += childData.fSelfTime;
                aggregateData.fNbCalls += childData.fNbCalls;
                aggregateData.addChildren(childData.fChildren);
            }
        }

        public long getDuration() {
            return this.fDuration;
        }

        public long getSelfTime() {
            return this.fSelfTime;
        }

        public int getNbCalls() {
            return this.fNbCalls;
        }

        public Map<String, AggregateData> getChildren() {
            return this.fChildren;
        }
    }

    protected static class ExpectedCallStackElement {
        private final int fPid;
        private final int fTid;
        private final Collection<ExpectedFunction> fCalls;

        ExpectedCallStackElement(int pid, int tid, Collection<ExpectedFunction> calls) {
            this.fPid = pid;
            this.fTid = tid;
            this.fCalls = calls;
        }
    }

    protected static class ExpectedFunction {
        private int fStart;
        private int fEnd;
        private String fFunction;
        private List<ExpectedFunction> fChildren;

        ExpectedFunction(int start, int end, String function, List<ExpectedFunction> children) {
            this.fStart = start;
            this.fEnd = end;
            this.fFunction = function;
            this.fChildren = children;
        }

        long getDuration() {
            return this.fEnd - this.fStart;
        }

        long getSelfTime() {
            long self = this.fEnd - this.fStart;
            for (ExpectedFunction child : this.fChildren) {
                self -= child.getDuration();
            }
            return self;
        }
    }
}

