/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IImage;

public class ImageImpl
implements IImage {
    private final Image fImage;

    public ImageImpl(String file) {
        this.fImage = ImageImpl.createResourceImage(file);
    }

    public ImageImpl(Image image) {
        this.fImage = image;
    }

    public Image getResourceImage(String name) {
        return ImageImpl.createResourceImage(name);
    }

    @Override
    public Object getImage() {
        return this.fImage;
    }

    @Override
    public void dispose() {
        if (this.fImage != null) {
            this.fImage.dispose();
        }
    }

    private static Image createResourceImage(String name) {
        try {
            URL BASIC_URL = new URL("platform", "localhost", "plugin");
            URL url = new URL(BASIC_URL, "plugin/org.eclipse.tracecompass.tmf.ui/icons/" + name);
            ImageDescriptor img = ImageDescriptor.createFromURL((URL)url);
            return img.createImage();
        }
        catch (MalformedURLException e) {
            Activator.getDefault().logError("Error opening image file", e);
            return null;
        }
    }
}

