/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.xychart;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.XmlDataProviderManager;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.XmlViewInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.xychart.Messages;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer2;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;
import org.w3c.dom.Element;

public class XmlTreeViewer
extends AbstractSelectTreeViewer2 {
    private final XmlViewInfo fViewInfo;

    public XmlTreeViewer(Composite parent, XmlViewInfo viewInfo) {
        super(parent, 1, "org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlXYDataProvider");
        this.fViewInfo = viewInfo;
        this.setLabelProvider((IBaseLabelProvider)new XmlLabelProvider());
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return () -> ImmutableList.of((Object)XmlTreeViewer.createColumn((String)Messages.XmlTree_Name, Comparator.comparing(TmfTreeViewerEntry::getName)), (Object)new TmfTreeColumnData(Messages.XmlTree_Legend));
    }

    protected @Nullable ITmfTreeDataProvider<ITmfTreeDataModel> getProvider(ITmfTrace trace) {
        Element viewElement = this.fViewInfo.getViewElement("xyView");
        if (viewElement == null) {
            return null;
        }
        return XmlDataProviderManager.getInstance().getXyProvider(trace, viewElement);
    }

    private class XmlLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        private XmlLabelProvider() {
        }

        public @Nullable Image getColumnImage(@Nullable Object element, int columnIndex) {
            if (columnIndex == 1 && element instanceof TmfGenericTreeEntry && XmlTreeViewer.this.isChecked(element)) {
                TmfTreeDataModel model = (TmfTreeDataModel)((TmfGenericTreeEntry)element).getModel();
                if (model.getParentId() < 0L) {
                    return null;
                }
                return XmlTreeViewer.this.getLegendImage(model.getId());
            }
            return null;
        }
    }
}

