/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core.services.local;

import org.eclipse.remote.core.IRemoteConnectionProviderService;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.core.RemoteCorePlugin;
import org.eclipse.remote.internal.core.services.local.Messages;

public class LocalConnectionProviderService
implements IRemoteConnectionProviderService {
    private static final String localConnectionName = Messages.LocalConnectionProviderService_LocalConnectionName;
    private IRemoteConnectionType connectionType;

    public LocalConnectionProviderService(IRemoteConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    @Override
    public void init() {
        if (this.connectionType.getConnections().isEmpty()) {
            try {
                this.connectionType.newConnection(localConnectionName).save();
            }
            catch (RemoteConnectionException e) {
                RemoteCorePlugin.log(e.getStatus());
            }
        }
    }

    @Override
    public IRemoteConnectionType getConnectionType() {
        return this.connectionType;
    }

    public static class Factory
    implements IRemoteConnectionType.Service.Factory {
        @Override
        public <T extends IRemoteConnectionType.Service> T getService(IRemoteConnectionType connectionType, Class<T> service) {
            if (service.equals(IRemoteConnectionProviderService.class)) {
                return (T)new LocalConnectionProviderService(connectionType);
            }
            return null;
        }
    }
}

