/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

public class ValidatedObservableList<E>
extends ObservableList<E> {
    private IObservableList<E> target;
    private IObservableValue<IStatus> validationStatus;
    private boolean stale;
    private boolean computeNextDiff = false;
    private boolean updatingTarget = false;
    private final IListChangeListener<E> targetChangeListener = event -> {
        if (this.updatingTarget) {
            return;
        }
        IStatus status = (IStatus)this.validationStatus.getValue();
        if (ValidatedObservableList.isValid(status)) {
            if (this.stale) {
                this.stale = false;
                this.updateWrappedList(new ArrayList<E>(this.target));
            } else {
                ListDiff diff = event.diff;
                if (this.computeNextDiff) {
                    diff = Diffs.computeListDiff((List)this.wrappedList, this.target);
                    this.computeNextDiff = false;
                }
                this.applyDiff(diff, this.wrappedList);
                this.fireListChange(Diffs.unmodifiableDiff((ListDiff)diff));
            }
        } else {
            this.makeStale();
        }
    };
    private final IStaleListener targetStaleListener = staleEvent -> this.fireStale();
    private final IValueChangeListener<IStatus> validationStatusChangeListener = event -> {
        IStatus oldStatus = (IStatus)event.diff.getOldValue();
        IStatus newStatus = (IStatus)event.diff.getNewValue();
        if (this.stale && !ValidatedObservableList.isValid(oldStatus) && ValidatedObservableList.isValid(newStatus)) {
            this.stale = false;
            this.updateWrappedList(new ArrayList<E>(this.target));
            this.computeNextDiff = true;
        }
    };

    private static boolean isValid(IStatus status) {
        return status.isOK() || status.matches(3);
    }

    public ValidatedObservableList(IObservableList<E> target, IObservableValue<IStatus> validationStatus) {
        super(target.getRealm(), new ArrayList<E>(target), target.getElementType());
        Assert.isNotNull(validationStatus, (String)"Validation status observable cannot be null");
        Assert.isTrue((boolean)target.getRealm().equals(validationStatus.getRealm()), (String)"Target and validation status observables must be on the same realm");
        this.target = target;
        this.validationStatus = validationStatus;
        target.addListChangeListener(this.targetChangeListener);
        target.addStaleListener(this.targetStaleListener);
        validationStatus.addValueChangeListener(this.validationStatusChangeListener);
    }

    private void makeStale() {
        if (!this.stale) {
            this.stale = true;
            this.fireStale();
        }
    }

    private void updateTargetList(ListDiff<E> diff) {
        this.updatingTarget = true;
        try {
            if (this.stale) {
                this.stale = false;
                this.applyDiff((ListDiff<? extends E>)Diffs.computeListDiff(this.target, (List)this.wrappedList), (List<E>)this.target);
            } else {
                this.applyDiff((ListDiff<? extends E>)diff, (List<E>)this.target);
            }
        }
        finally {
            this.updatingTarget = false;
        }
    }

    private void applyDiff(ListDiff<? extends E> diff, final List<E> list) {
        diff.accept(new ListDiffVisitor<E>(){

            public void handleAdd(int index, E element) {
                list.add(index, element);
            }

            public void handleRemove(int index, E element) {
                list.remove(index);
            }

            public void handleReplace(int index, E oldElement, E newElement) {
                list.set(index, newElement);
            }
        });
    }

    public boolean isStale() {
        ObservableTracker.getterCalled((IObservable)this);
        return this.stale || this.target.isStale();
    }

    public void add(int index, E element) {
        this.checkRealm();
        this.wrappedList.add(index, element);
        ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, element));
        this.updateTargetList(diff);
        this.fireListChange(diff);
    }

    public boolean add(E o) {
        this.checkRealm();
        this.add(this.wrappedList.size(), o);
        return true;
    }

    public boolean addAll(Collection<? extends E> c) {
        this.checkRealm();
        return this.addAll(this.wrappedList.size(), c);
    }

    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkRealm();
        ArrayList<ListDiffEntry> entries = new ArrayList<ListDiffEntry>(c.size());
        int i = index;
        for (E element : c) {
            this.wrappedList.add(i, element);
            entries.add(Diffs.createListDiffEntry((int)i, (boolean)true, element));
            ++i;
        }
        ListDiff diff = Diffs.createListDiff(entries);
        this.updateTargetList(diff);
        this.fireListChange(diff);
        return true;
    }

    public void clear() {
        this.checkRealm();
        if (this.isEmpty()) {
            return;
        }
        ListDiff diff = Diffs.computeListDiff((List)this.wrappedList, Collections.emptyList());
        this.wrappedList.clear();
        this.updateTargetList(diff);
        this.fireListChange(diff);
    }

    public Iterator<E> iterator() {
        this.getterCalled();
        final ListIterator wrappedIterator = this.wrappedList.listIterator();
        return new Iterator<E>(){
            E last = null;

            @Override
            public boolean hasNext() {
                return wrappedIterator.hasNext();
            }

            @Override
            public E next() {
                this.last = wrappedIterator.next();
                return this.last;
            }

            @Override
            public void remove() {
                int index = wrappedIterator.previousIndex();
                wrappedIterator.remove();
                ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, this.last));
                ValidatedObservableList.this.updateTargetList(diff);
                ValidatedObservableList.this.fireListChange(diff);
            }
        };
    }

    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    public ListIterator<E> listIterator(int index) {
        this.getterCalled();
        final ListIterator wrappedIterator = this.wrappedList.listIterator(index);
        return new ListIterator<E>(){
            int lastIndex = -1;
            E last = null;

            @Override
            public void add(E o) {
                wrappedIterator.add(o);
                this.lastIndex = this.previousIndex();
                ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)this.lastIndex, (boolean)true, o));
                ValidatedObservableList.this.updateTargetList(diff);
                ValidatedObservableList.this.fireListChange(diff);
            }

            @Override
            public boolean hasNext() {
                return wrappedIterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return wrappedIterator.hasPrevious();
            }

            @Override
            public E next() {
                this.last = wrappedIterator.next();
                this.lastIndex = this.previousIndex();
                return this.last;
            }

            @Override
            public int nextIndex() {
                return wrappedIterator.nextIndex();
            }

            @Override
            public E previous() {
                this.last = wrappedIterator.previous();
                this.lastIndex = this.nextIndex();
                return this.last;
            }

            @Override
            public int previousIndex() {
                return wrappedIterator.previousIndex();
            }

            @Override
            public void remove() {
                wrappedIterator.remove();
                ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)this.lastIndex, (boolean)false, this.last));
                this.lastIndex = -1;
                ValidatedObservableList.this.updateTargetList(diff);
                ValidatedObservableList.this.fireListChange(diff);
            }

            @Override
            public void set(E o) {
                wrappedIterator.set(o);
                ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)this.lastIndex, (boolean)false, this.last), (ListDiffEntry)Diffs.createListDiffEntry((int)this.lastIndex, (boolean)true, o));
                this.last = o;
                ValidatedObservableList.this.updateTargetList(diff);
                ValidatedObservableList.this.fireListChange(diff);
            }
        };
    }

    public E move(int oldIndex, int newIndex) {
        this.checkRealm();
        int size = this.wrappedList.size();
        if (oldIndex >= size) {
            throw new IndexOutOfBoundsException("oldIndex: " + oldIndex + ", size:" + size);
        }
        if (newIndex >= size) {
            throw new IndexOutOfBoundsException("newIndex: " + newIndex + ", size:" + size);
        }
        if (oldIndex == newIndex) {
            return this.wrappedList.get(oldIndex);
        }
        Object element = this.wrappedList.remove(oldIndex);
        this.wrappedList.add(newIndex, element);
        ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)oldIndex, (boolean)false, element), (ListDiffEntry)Diffs.createListDiffEntry((int)newIndex, (boolean)true, element));
        this.updateTargetList(diff);
        this.fireListChange(diff);
        return element;
    }

    public E remove(int index) {
        this.checkRealm();
        Object element = this.wrappedList.remove(index);
        ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, element));
        this.updateTargetList(diff);
        this.fireListChange(diff);
        return element;
    }

    public boolean remove(Object o) {
        this.checkRealm();
        int index = this.wrappedList.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public boolean removeAll(Collection<?> c) {
        this.checkRealm();
        ArrayList list = new ArrayList(this.wrappedList);
        boolean changed = list.removeAll(c);
        if (changed) {
            ListDiff diff = Diffs.computeListDiff((List)this.wrappedList, list);
            this.wrappedList = list;
            this.updateTargetList(diff);
            this.fireListChange(diff);
        }
        return changed;
    }

    public boolean retainAll(Collection<?> c) {
        this.checkRealm();
        ArrayList list = new ArrayList(this.wrappedList);
        boolean changed = list.retainAll(c);
        if (changed) {
            ListDiff diff = Diffs.computeListDiff((List)this.wrappedList, list);
            this.wrappedList = list;
            this.updateTargetList(diff);
            this.fireListChange(diff);
        }
        return changed;
    }

    public E set(int index, E element) {
        this.checkRealm();
        E oldElement = this.wrappedList.set(index, element);
        ListDiff diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, oldElement), (ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, element));
        this.updateTargetList(diff);
        this.fireListChange(diff);
        return oldElement;
    }

    public synchronized void dispose() {
        this.target.removeListChangeListener(this.targetChangeListener);
        this.target.removeStaleListener(this.targetStaleListener);
        this.validationStatus.removeValueChangeListener(this.validationStatusChangeListener);
        super.dispose();
    }
}

