/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.Activator;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.IntervalInfo;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.junit.Assert;

public class LinuxTestCase {
    private final String fTraceFile;

    public LinuxTestCase(String filename) {
        this.fTraceFile = filename;
    }

    public String getTraceFileName() {
        return (String)NonNullUtils.checkNotNull((Object)FilenameUtils.getName((String)this.fTraceFile));
    }

    public TmfXmlKernelTraceStub getKernelTrace() {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        IPath filePath = Activator.getAbsoluteFilePath(this.fTraceFile);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        return trace;
    }

    public Set<IntervalInfo> getTestIntervals() {
        return Collections.EMPTY_SET;
    }

    public Set<PunctualInfo> getPunctualTestData() {
        return Collections.EMPTY_SET;
    }

    public String toString() {
        return this.getTraceFileName();
    }

    public static class PunctualInfo {
        private final long fTs;
        private final Map<String[], @Nullable Object> fValueMap;

        public PunctualInfo(long ts) {
            this.fTs = ts;
            this.fValueMap = new HashMap<String[], Object>();
        }

        public long getTimestamp() {
            return this.fTs;
        }

        public Map<String[], @Nullable Object> getValues() {
            return this.fValueMap;
        }

        public void addValue(String[] key, @Nullable Object value) {
            this.fValueMap.put(key, value);
        }
    }
}

