/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.trace;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.BaseTree;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.RewriteCardinalityException;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.trace.CTFIOException;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFLexer;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.CtfCoreLoggerUtil;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFAntlrMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFJsonMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CtfAntlrException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.FieldClass;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.IOStructGen;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonClockMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonDataStreamMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonEventRecordMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonFieldClassAliasMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonPreambleMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonTraceMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.trace.TraceDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.utils.Utils;

public class Metadata {
    private static final Charset ASCII_CHARSET = Charset.forName("ASCII");
    private static final String TEXT_ONLY_METADATA_HEADER_PREFIX = "/* CTF";
    private static final List<String> TEXT_ONLY_METADATA_HEADER_PREFIXES = List.of("typealias", "trace", "env");
    private static final int PREVALIDATION_SIZE = 8;
    private static final int BITS_PER_BYTE = 8;
    private static final String METADATA_FILENAME = "metadata";
    private static final int METADATA_PACKET_HEADER_SIZE = 37;
    private ByteOrder fDetectedByteOrder = null;
    private final CTFTrace fTrace;
    private IOStructGen fTreeParser;

    public Metadata(CTFTrace trace) {
        this.fTrace = trace;
    }

    public Metadata() {
        this.fTrace = new CTFTrace();
    }

    public ByteOrder getDetectedByteOrder() {
        return this.fDetectedByteOrder;
    }

    public CTFTrace getTrace() {
        return this.fTrace;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseFile() throws CTFException {
        ByteOrder byteOrder;
        File metadataFile = new File(this.getMetadataPath());
        this.fDetectedByteOrder = byteOrder = CTFTrace.startsWithMagicNumber(metadataFile, 1976638807);
        try {
            Throwable throwable = null;
            Object var4_9 = null;
            try {
                FileInputStream fis = new FileInputStream(metadataFile);
                try {
                    block23: {
                        FileChannel metadataFileChannel = fis.getChannel();
                        try {
                            try (Reader metadataTextInput = byteOrder != null ? this.readBinaryMetaData(metadataFileChannel) : new FileReader(metadataFile);){
                                this.readMetaDataText(metadataTextInput);
                            }
                            if (metadataFileChannel == null) break block23;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (metadataFileChannel == null) throw throwable;
                            metadataFileChannel.close();
                            throw throwable;
                        }
                        metadataFileChannel.close();
                    }
                    if (fis == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new CTFException("Cannot find metadata file!", e);
        }
        catch (IOException | ParseException e) {
            throw new CTFException(e);
        }
        catch (RecognitionException e) {
            throw new CtfAntlrException(e);
        }
        catch (RewriteCardinalityException e) {
            throw new CtfAntlrException((Exception)((Object)e));
        }
    }

    public void parseJsonFile() throws CTFException {
        File metadataFile = new File(this.getMetadataPath());
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileInputStream is = new FileInputStream(metadataFile);){
                String json = IOUtils.toString((InputStream)is, (String)"UTF-8");
                ICTFMetadataNode tree = Metadata.parseJsonToTree(json);
                this.fTreeParser = new IOStructGen(tree, Objects.requireNonNull(this.fTrace));
                this.fTreeParser.generate();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new CTFException("Cannot find metadata file!", e);
        }
        catch (IOException | ParseException e) {
            throw new CTFException(e);
        }
    }

    private static ICTFMetadataNode parseJsonToTree(String json) throws CTFException {
        CTFJsonMetadataNode root = new CTFJsonMetadataNode(null, CTFParser.tokenNames[103], null);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(FieldClass.class, (Object)new FieldClass.FieldClassDeserializer(root));
        Gson gson = builder.create();
        String[] jsonBlocks = json.split("\u001e");
        int i = 1;
        while (i < jsonBlocks.length) {
            ICTFMetadataNode fragment;
            try {
                fragment = Objects.requireNonNull((CTFJsonMetadataNode)gson.fromJson(jsonBlocks[i], CTFJsonMetadataNode.class));
            }
            catch (JsonSyntaxException e) {
                throw new CTFException("Trace cannot be parsed as CTF2");
            }
            String type = fragment.getType();
            if (type.equals("preamble")) {
                fragment = Objects.requireNonNull((JsonPreambleMetadataNode)gson.fromJson(jsonBlocks[i], JsonPreambleMetadataNode.class));
            } else if (type.equals("trace-class")) {
                fragment = Objects.requireNonNull((JsonTraceMetadataNode)gson.fromJson(jsonBlocks[i], JsonTraceMetadataNode.class));
            } else if (type.equals("clock-class")) {
                fragment = Objects.requireNonNull((JsonClockMetadataNode)gson.fromJson(jsonBlocks[i], JsonClockMetadataNode.class));
            } else if (type.equals("event-record-class")) {
                fragment = Objects.requireNonNull((JsonEventRecordMetadataNode)gson.fromJson(jsonBlocks[i], JsonEventRecordMetadataNode.class));
            } else if (type.equals("data-stream-class")) {
                fragment = Objects.requireNonNull((JsonDataStreamMetadataNode)gson.fromJson(jsonBlocks[i], JsonDataStreamMetadataNode.class));
                if (!jsonBlocks[i].contains("id:")) {
                    ((JsonDataStreamMetadataNode)fragment).setId(-1);
                }
            } else if (type.equals("field-class-alias")) {
                fragment = Objects.requireNonNull((JsonFieldClassAliasMetadataNode)gson.fromJson(jsonBlocks[i], JsonFieldClassAliasMetadataNode.class));
            }
            ((CTFJsonMetadataNode)fragment).initialize();
            root.addChild(fragment);
            fragment.setParent(root);
            ++i;
        }
        return root;
    }

    public void checkCTFVersion() throws CTFException {
        File metadataFile = new File(this.getMetadataPath());
        if (CTFTrace.startsWithRecordSeparator(metadataFile, 30)) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream is = new FileInputStream(metadataFile);){
                    String json = IOUtils.toString((InputStream)is, (String)"UTF-8").split("\u001e")[1];
                    GsonBuilder builder = new GsonBuilder();
                    Gson gson = builder.create();
                    @Nullable ICTFMetadataNode metadata = (ICTFMetadataNode)gson.fromJson(json, JsonPreambleMetadataNode.class);
                    TraceDeclarationParser.INSTANCE.parse(metadata, new TraceDeclarationParser.Param(this.fTrace, Objects.requireNonNull(this.fTrace.getScope())));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ParseException e) {
                throw new CTFIOException(e);
            }
        }
    }

    private Reader readBinaryMetaData(FileChannel metadataFileChannel) throws CTFException {
        StringBuffer metadataText = new StringBuffer();
        MetadataPacketHeader packetHeader = this.readMetadataPacket(metadataFileChannel, metadataText);
        while (packetHeader != null) {
            packetHeader = this.readMetadataPacket(metadataFileChannel, metadataText);
        }
        return new StringReader(metadataText.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean preValidate(String path) throws CTFException {
        String metadataPath = path + Utils.SEPARATOR + METADATA_FILENAME;
        File metadataFile = new File(metadataPath);
        if (!metadataFile.exists()) return false;
        if (metadataFile.length() <= 8L) return false;
        if (CTFTrace.startsWithMagicNumber(metadataFile, 1976638807) != null) return true;
        if (CTFTrace.startsWithRecordSeparator(metadataFile, 30)) {
            return true;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(metadataFile));){
                String text = br.readLine();
                if (text.startsWith(TEXT_ONLY_METADATA_HEADER_PREFIX)) {
                    return true;
                }
                if (!TEXT_ONLY_METADATA_HEADER_PREFIXES.stream().anyMatch(text::startsWith)) return false;
                CtfCoreLoggerUtil.logWarning("Text-only metadata of trace " + path + " does not start with the required prefix: /* CTF. Trace will be parsed as CTF because metadata starts with one of the supported keywords: " + String.valueOf(TEXT_ONLY_METADATA_HEADER_PREFIXES) + ".");
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CTFException(e.getMessage(), e);
        }
    }

    public void parseText(String data) throws CTFException {
        StringReader metadataTextInput = new StringReader(data);
        try {
            this.readMetaDataText(metadataTextInput);
        }
        catch (IOException | ParseException e) {
            throw new CTFException(e);
        }
        catch (RecognitionException | RewriteCardinalityException e) {
            throw new CtfAntlrException((Exception)e);
        }
    }

    private void readMetaDataText(Reader metadataTextInput) throws IOException, RecognitionException, ParseException {
        ICTFMetadataNode tree = Metadata.createAST(metadataTextInput);
        this.fTreeParser = new IOStructGen(tree, Objects.requireNonNull(this.fTrace));
        this.fTreeParser.generate();
        ByteOrder detectedByteOrder = this.getDetectedByteOrder();
        if (detectedByteOrder != null && this.fTrace.getByteOrder() != detectedByteOrder) {
            throw new ParseException("Metadata byte order and trace byte order inconsistent.");
        }
    }

    public void parseTextFragment(String dataFragment) throws CTFException {
        StringReader metadataTextInput = new StringReader(dataFragment);
        try {
            this.readMetaDataTextFragment(metadataTextInput);
        }
        catch (IOException | ParseException e) {
            throw new CTFException(e);
        }
        catch (RecognitionException | RewriteCardinalityException e) {
            throw new CtfAntlrException((Exception)e);
        }
    }

    private void readMetaDataTextFragment(Reader metadataTextInput) throws IOException, RecognitionException, ParseException {
        ICTFMetadataNode tree = Metadata.createAST(metadataTextInput);
        this.fTreeParser.setTree(tree);
        this.fTreeParser.generateFragment();
    }

    private static ICTFMetadataNode createAST(Reader metadataTextInput) throws IOException, RecognitionException {
        ANTLRReaderStream antlrStream = new ANTLRReaderStream(metadataTextInput);
        CTFLexer ctfLexer = new CTFLexer((CharStream)antlrStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)ctfLexer);
        CTFParser ctfParser = new CTFParser((TokenStream)tokens, false);
        CTFParser.parse_return pr = ctfParser.parse();
        CTFAntlrMetadataNode root = new CTFAntlrMetadataNode(null, CTFParser.tokenNames[103], null);
        CommonTree tree = pr.getTree();
        Metadata.populate((BaseTree)tree, root);
        ICTFMetadataNode newRoot = root.getChild(0);
        newRoot.setParent(null);
        return newRoot;
    }

    private static void populate(BaseTree tree, ICTFMetadataNode dest) {
        CTFAntlrMetadataNode current = new CTFAntlrMetadataNode(dest, CTFParser.tokenNames[tree.getType()], tree.getText());
        List children = tree.getChildren();
        if (children != null) {
            for (Object childObj : children) {
                if (!(childObj instanceof BaseTree)) continue;
                Metadata.populate((BaseTree)childObj, current);
            }
        }
    }

    private String getMetadataPath() {
        if (this.fTrace.getTraceDirectory() == null) {
            return "";
        }
        return this.fTrace.getTraceDirectory().getPath() + Utils.SEPARATOR + METADATA_FILENAME;
    }

    private MetadataPacketHeader readMetadataPacket(FileChannel metadataFileChannel, StringBuffer metadataText) throws CTFException {
        int nbBytesRead;
        ByteBuffer headerByteBuffer;
        block11: {
            headerByteBuffer = ByteBuffer.allocate(37);
            try {
                nbBytesRead = metadataFileChannel.read(headerByteBuffer);
                if (nbBytesRead >= 0) break block11;
                return null;
            }
            catch (IOException e) {
                throw new CTFException("Error reading the metadata header.", e);
            }
        }
        if (nbBytesRead != 37) {
            throw new CTFException("Error reading the metadata header.");
        }
        headerByteBuffer.position(0);
        headerByteBuffer.order(this.fDetectedByteOrder);
        MetadataPacketHeader header = new MetadataPacketHeader(headerByteBuffer);
        if (!header.isMagicValid()) {
            throw new CTFException("TSDL magic number does not match");
        }
        if (!this.fTrace.uuidIsSet()) {
            this.fTrace.setUUID(header.getUuid());
        } else if (!this.fTrace.getUUID().equals(header.getUuid())) {
            throw new CTFException("UUID mismatch");
        }
        int payloadSize = header.getContentSize() / 8 - 37;
        if (payloadSize < 0) {
            throw new CTFException("Invalid metadata packet payload size.");
        }
        int skipSize = (header.getPacketSize() - header.getContentSize()) / 8;
        ByteBuffer payloadByteBuffer = ByteBuffer.allocateDirect(payloadSize + skipSize);
        try {
            metadataFileChannel.read(payloadByteBuffer);
        }
        catch (IOException e) {
            throw new CTFException("Error reading metadata packet payload.", e);
        }
        payloadByteBuffer.rewind();
        byte[] payloadByteArray = new byte[payloadByteBuffer.remaining()];
        payloadByteBuffer.get(payloadByteArray, 0, payloadSize);
        String str = new String(payloadByteArray, 0, payloadSize, ASCII_CHARSET);
        metadataText.append(str);
        return header;
    }

    public Path copyTo(File path) throws IOException {
        Path source = FileSystems.getDefault().getPath(this.fTrace.getTraceDirectory().getAbsolutePath(), METADATA_FILENAME);
        Path destPath = FileSystems.getDefault().getPath(path.getAbsolutePath(), new String[0]);
        return Files.copy(source, destPath.resolve(source.getFileName()), new CopyOption[0]);
    }

    private static class MetadataPacketHeader {
        private static final int UUID_SIZE = 16;
        private final int fMagic;
        private final UUID fUuid;
        private final int fChecksum;
        private final int fContentSize;
        private final int fPacketSize;
        private final byte fCompressionScheme;
        private final byte fEncryptionScheme;
        private final byte fChecksumScheme;
        private final byte fCtfMajorVersion;
        private final byte fCtfMinorVersion;

        public MetadataPacketHeader(ByteBuffer headerByteBuffer) throws CTFException {
            this.fMagic = headerByteBuffer.getInt();
            byte[] uuidBytes = new byte[16];
            headerByteBuffer.get(uuidBytes);
            this.fUuid = Utils.makeUUID(uuidBytes);
            this.fChecksum = headerByteBuffer.getInt();
            this.fContentSize = headerByteBuffer.getInt();
            this.fPacketSize = headerByteBuffer.getInt();
            this.fCompressionScheme = headerByteBuffer.get();
            this.fEncryptionScheme = headerByteBuffer.get();
            this.fChecksumScheme = headerByteBuffer.get();
            this.fCtfMajorVersion = headerByteBuffer.get();
            this.fCtfMinorVersion = headerByteBuffer.get();
        }

        public boolean isMagicValid() {
            return this.fMagic == 1976638807;
        }

        public UUID getUuid() {
            return this.fUuid;
        }

        public int getContentSize() {
            return this.fContentSize;
        }

        public int getPacketSize() {
            return this.fPacketSize;
        }

        public String toString() {
            return "MetadataPacketHeader [magic=0x" + Integer.toHexString(this.fMagic) + ", uuid=" + this.fUuid.toString() + ", checksum=" + this.fChecksum + ", contentSize=" + this.fContentSize + ", packetSize=" + this.fPacketSize + ", compressionScheme=" + this.fCompressionScheme + ", encryptionScheme=" + this.fEncryptionScheme + ", checksumScheme=" + this.fChecksumScheme + ", ctfMajorVersion=" + this.fCtfMajorVersion + ", ctfMinorVersion=" + this.fCtfMinorVersion + "]";
        }
    }
}

