/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.resource;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class CopyProjectChange
extends ResourceChange {
    private final IProject fSourceProject;
    private ChangeDescriptor fDescriptor;
    private final String fNewName;
    private IPath fNewLocation;

    public CopyProjectChange(IProject resourcePath, IPath newLocation, String newName) {
        Assert.isNotNull((Object)resourcePath);
        this.fNewName = newName;
        this.fNewLocation = newLocation;
        this.fSourceProject = resourcePath;
        this.setValidationMethod(4);
    }

    @Override
    protected IResource getModifiedResource() {
        return this.fSourceProject;
    }

    @Override
    public String getName() {
        return RefactoringCoreMessages.CopyProjectChange_Name + this.fSourceProject.getName();
    }

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (String)RefactoringCoreMessages.CopyProjectChange_copying, (int)10);
        if (this.fSourceProject == null || !this.fSourceProject.exists()) {
            String message = Messages.format(RefactoringCoreMessages.CopyProjectChange_error_resource_not_exists, BasicElementLabels.getPathLabel(this.fSourceProject.getFullPath().makeRelative(), false));
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), message));
        }
        if (this.fSourceProject.isAccessible()) {
            this.fSourceProject.accept(curr -> {
                try {
                    if (curr instanceof IFile) {
                        CopyProjectChange.saveFileIfNeeded((IFile)curr, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return true;
            }, 2, false);
        }
        IProjectDescription description = this.fSourceProject.getDescription();
        if (this.fNewLocation != null && (this.fNewLocation.equals((Object)Platform.getLocation()) || this.fNewLocation.isRoot())) {
            this.fNewLocation = null;
        }
        description.setName(this.fNewName);
        description.setLocation(this.fNewLocation);
        this.fSourceProject.copy(description, 33, (IProgressMonitor)subMonitor.newChild(10));
        IProject targetProject = this.fSourceProject.getWorkspace().getRoot().getProject(this.fNewName);
        return new DeleteResourceChange(targetProject.getFullPath(), true, true);
    }

    private static void saveFileIfNeeded(IFile file, IProgressMonitor pm) throws CoreException {
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        if (buffer != null && buffer.isDirty() && buffer.isStateValidated() && buffer.isSynchronized()) {
            buffer.commit((IProgressMonitor)subMonitor.newChild(1), false);
            file.refreshLocal(1, (IProgressMonitor)subMonitor.newChild(1));
            buffer.commit((IProgressMonitor)subMonitor.newChild(1), false);
            file.refreshLocal(1, (IProgressMonitor)subMonitor.newChild(1));
        } else {
            subMonitor.worked(2);
        }
    }

    @Override
    public ChangeDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }
}

