/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class DebugElementHelper {
    private static DelegatingModelPresentation fgPresenetation;
    private static Map<Image, ImageDescriptor> fgImages;

    static {
        fgImages = new ConcurrentHashMap<Image, ImageDescriptor>();
    }

    public static void dispose() {
        fgImages.clear();
        if (fgPresenetation != null) {
            fgPresenetation.dispose();
            fgPresenetation = null;
        }
    }

    public static ImageDescriptor getImageDescriptor(Object object) {
        Image image = DebugElementHelper.getPresentation().getImage(object);
        return DebugElementHelper.getImageDescriptor(image);
    }

    public static ImageDescriptor getImageDescriptor(Object object, IDebugModelPresentation presentation) {
        Image image = presentation.getImage(object);
        return DebugElementHelper.getImageDescriptor(image);
    }

    public static ImageDescriptor getImageDescriptor(Image image) {
        if (image != null) {
            return fgImages.computeIfAbsent(image, ImageDescriptor::createFromImage);
        }
        return null;
    }

    public static String getLabel(Object o) {
        return DebugElementHelper.getPresentation().getText(o);
    }

    public static DelegatingModelPresentation getPresentation() {
        if (fgPresenetation == null) {
            fgPresenetation = new DelegatingModelPresentation();
        }
        return fgPresenetation;
    }

    public static RGB getForeground(Object element) {
        Color color = DebugElementHelper.getPresentation().getForeground(element);
        if (color != null) {
            return color.getRGB();
        }
        return null;
    }

    public static RGB getForeground(Object element, IDebugModelPresentation presentation) {
        Color color = null;
        if (presentation instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)presentation;
            color = colorProvider.getForeground(element);
        } else {
            color = DebugElementHelper.getPresentation().getForeground(element);
        }
        if (color != null) {
            return color.getRGB();
        }
        if (element instanceof Breakpoint) {
            Breakpoint breakpoint = (Breakpoint)element;
            if (breakpoint.getBreakpointLabel() != null) {
                return new RGB(255, 0, 0);
            }
            return null;
        }
        return null;
    }

    public static RGB getBackground(Object element) {
        Color color = DebugElementHelper.getPresentation().getBackground(element);
        if (color != null) {
            return color.getRGB();
        }
        return null;
    }

    public static RGB getBackground(Object element, IDebugModelPresentation presentation) {
        Color color = null;
        if (presentation instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)presentation;
            color = colorProvider.getBackground(element);
        } else {
            color = DebugElementHelper.getPresentation().getBackground(element);
        }
        if (color != null) {
            return color.getRGB();
        }
        return null;
    }

    public static FontData getFont(Object element) {
        Font font = DebugElementHelper.getPresentation().getFont(element);
        if (font != null) {
            return font.getFontData()[0];
        }
        return null;
    }

    public static FontData getFont(Object element, IDebugModelPresentation presentation) {
        Breakpoint breakpoint;
        Font font = null;
        if (presentation instanceof IFontProvider) {
            IFontProvider provider = (IFontProvider)presentation;
            font = provider.getFont(element);
        } else {
            font = DebugElementHelper.getPresentation().getFont(element);
        }
        if (font != null) {
            return font.getFontData()[0];
        }
        if (element instanceof Breakpoint && (breakpoint = (Breakpoint)element).getBreakpointLabel() != null) {
            FontData fontNew = JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0];
            return new FontData(fontNew.getName(), fontNew.getHeight(), fontNew.getStyle() ^ 1);
        }
        return null;
    }

    public static boolean requiresUIThread(Object object) {
        DelegatingModelPresentation presentation = DebugElementHelper.getPresentation();
        return presentation.requiresUIThread(object);
    }
}

