/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;

public final class SyscallLookup {
    private static final String SYSCALL_TSV_PATH = "res/syscalls.tsv";
    private static @Nullable SyscallLookup sInstance = null;
    private final Map<String, String> fComponents = new HashMap<String, String>();
    private final Map<String, String> fFiles = new HashMap<String, String>();

    public static SyscallLookup getInstance() {
        SyscallLookup instance = sInstance;
        if (instance == null) {
            sInstance = instance = SyscallLookup.create();
        }
        return instance;
    }

    private static SyscallLookup create() {
        try {
            IPath path = Activator.getDefault().getAbsolutePath(new Path(SYSCALL_TSV_PATH));
            if (path != null) {
                File file = path.toFile();
                if (!file.exists()) {
                    Activator.getDefault().logWarning("Syscall names not available!");
                    return new SyscallLookup(Collections.emptyList());
                }
                return new SyscallLookup(FileUtils.readLines((File)file, (String)StandardCharsets.UTF_8.name()));
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError("Failed to read file", e);
        }
        return new SyscallLookup(Collections.emptyList());
    }

    private SyscallLookup(@Nullable List<@Nullable String> lines) {
        if (lines != null) {
            for (String line : lines) {
                String[] components;
                if (line == null || line.startsWith("#") || (components = line.split("\t")).length <= 2) continue;
                String name = String.valueOf(components[0]);
                this.fComponents.put(name, String.valueOf(components[1]));
                this.fFiles.put(name, String.valueOf(components[2]));
            }
        }
    }

    public String getComponent(String name) {
        return this.fComponents.getOrDefault(name, "");
    }

    public String getFile(String name) {
        return this.fFiles.getOrDefault(name, "");
    }
}

