/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.serialization;

import java.nio.ByteBuffer;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.internal.datastore.core.serialization.SafeByteBufferWrapper;

public final class SafeByteBufferFactory {
    private SafeByteBufferFactory() {
    }

    public static ISafeByteBufferReader wrapReader(ByteBuffer buffer, int size) {
        int pos = buffer.position();
        ByteBuffer readOnlyBuffer = buffer.slice().asReadOnlyBuffer();
        readOnlyBuffer.order(buffer.order());
        readOnlyBuffer.limit(size);
        buffer.position(pos + size);
        return new SafeByteBufferWrapper(readOnlyBuffer);
    }

    public static ISafeByteBufferWriter wrapWriter(ByteBuffer buffer, int size) {
        int pos = buffer.position();
        ByteBuffer readWriteBuffer = buffer.slice();
        readWriteBuffer.order(buffer.order());
        readWriteBuffer.limit(size);
        buffer.position(pos + size);
        return new SafeByteBufferWrapper(readWriteBuffer);
    }

    public static int getStringSizeInBuffer(String string) {
        return SafeByteBufferWrapper.getStringSizeInBuffer(string);
    }
}

