/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.segmentstore.core.segmentHistoryTree;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.IHTNode;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.overlapping.AbstractOverlappingHistoryTree;
import org.eclipse.tracecompass.internal.segmentstore.core.Activator;
import org.eclipse.tracecompass.internal.segmentstore.core.segmentHistoryTree.SegmentTreeNode;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;

public class SegmentHistoryTree<E extends ISegment>
extends AbstractOverlappingHistoryTree<E, SegmentTreeNode<E>> {
    private static final int HISTORY_MAGIC_NUMBER = 100648448;
    private static final int FILE_VERSION = 1;
    private static final int ITERATOR_QUEUE_SIZE = 2000;

    public SegmentHistoryTree(File stateHistoryFile, int blockSize, int maxChildren, int providerVersion, long treeStart, IHTIntervalReader<E> intervalReader) throws IOException {
        super(stateHistoryFile, blockSize, maxChildren, providerVersion, treeStart, intervalReader);
    }

    public SegmentHistoryTree(File existingStateFile, int expProviderVersion, IHTIntervalReader<E> intervalReader) throws IOException {
        super(existingStateFile, expProviderVersion, intervalReader);
    }

    protected int getMagicNumber() {
        return 100648448;
    }

    protected int getFileVersion() {
        return 1;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AbstractHistoryTree.IHTNodeFactory<E, SegmentTreeNode<E>> getNodeFactory() {
        return (t, b, m, seq, p, start) -> new SegmentTreeNode(t, b, m, seq, p, start);
    }

    public int size() {
        long total = 0L;
        try {
            int seq = 0;
            while (seq < this.getNodeCount()) {
                SegmentTreeNode node = (SegmentTreeNode)this.readNode(seq);
                total += (long)node.getNumIntervals();
                ++seq;
            }
        }
        catch (ClosedChannelException e) {
            Activator.instance().logError(e.getMessage(), e);
            return 0;
        }
        return (int)total;
    }

    public boolean isEmpty() {
        Iterator<E> it = this.iterator();
        if (it == null) {
            return true;
        }
        return !it.hasNext();
    }

    public @Nullable Iterator<E> iterator() {
        return this.getIntersectingElements(this.getTreeStart(), this.getTreeEnd()).iterator();
    }

    public Iterable<@NonNull E> getIntersectingElements(long start, long end) {
        final TimeRangeCondition rc = TimeRangeCondition.forContinuousRange((long)start, (long)end);
        return () -> new Iterator<E>(){
            private boolean started = false;
            private Deque<Integer> queue = new LinkedList<Integer>();
            private Deque<E> intersecting = new LinkedList();

            @Override
            public @NonNull E next() {
                if (this.hasNext()) {
                    return (ISegment)NonNullUtils.checkNotNull((Object)((ISegment)this.intersecting.removeFirst()));
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (!this.started) {
                    this.queue.add(((SegmentTreeNode)SegmentHistoryTree.this.getRootNode()).getSequenceNumber());
                    this.started = true;
                }
                while (this.intersecting.isEmpty() && !this.queue.isEmpty()) {
                    SegmentTreeNode currentNode;
                    try {
                        currentNode = (SegmentTreeNode)SegmentHistoryTree.this.readNode(this.queue.pop());
                    }
                    catch (ClosedChannelException e) {
                        Activator.instance().logError(e.getMessage(), e);
                        return false;
                    }
                    if (currentNode.getNodeType() == IHTNode.NodeType.CORE) {
                        this.queue.addAll(currentNode.selectNextChildren(rc));
                    }
                    this.intersecting.addAll(currentNode.getMatchingIntervals(rc, interval -> true));
                }
                return !this.intersecting.isEmpty();
            }
        };
    }

    public Iterable<@NonNull E> getIntersectingElements(long start, long end, final Comparator<@NonNull E> order) {
        final TimeRangeCondition rc = TimeRangeCondition.forContinuousRange((long)start, (long)end);
        return () -> new Iterator<E>(){
            private boolean started = false;
            private PriorityQueue<SegmentTreeNode.Tuple<E>> queue;
            private PriorityQueue<E> intersecting;
            {
                this.queue = new PriorityQueue<SegmentTreeNode.Tuple>(SegmentHistoryTree.this.getNodeCount(), Comparator.comparing(SegmentTreeNode.Tuple::getSegment, comparator));
                this.intersecting = new PriorityQueue(2000, comparator);
            }

            @Override
            public @NonNull E next() {
                if (this.hasNext()) {
                    return (ISegment)NonNullUtils.checkNotNull((Object)((ISegment)this.intersecting.remove()));
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (!this.started) {
                    SegmentTreeNode rootNode = (SegmentTreeNode)SegmentHistoryTree.this.getRootNode();
                    this.queue.add(new SegmentTreeNode.Tuple<BasicSegment>(new BasicSegment(0L, 0L), rootNode.getSequenceNumber()));
                    this.started = true;
                }
                while (!this.queue.isEmpty() && (this.intersecting.isEmpty() || order.compare((ISegment)this.intersecting.element(), (ISegment)this.queue.peek().getSegment()) > 0)) {
                    SegmentTreeNode currentNode;
                    try {
                        currentNode = (SegmentTreeNode)SegmentHistoryTree.this.readNode(this.queue.poll().getSequenceNumber());
                    }
                    catch (ClosedChannelException e) {
                        Activator.instance().logError(e.getMessage(), e);
                        return false;
                    }
                    if (currentNode.getNodeType() == IHTNode.NodeType.CORE) {
                        this.queue.addAll(currentNode.selectNextChildren(rc, order));
                    }
                    this.intersecting.addAll(currentNode.getMatchingIntervals(rc, interval -> true));
                }
                return !this.intersecting.isEmpty();
            }
        };
    }

    @VisibleForTesting
    public boolean verifyChildrenSpecific(SegmentTreeNode<E> parent, int index, SegmentTreeNode<E> child) {
        return parent.getMaxStart(index) >= child.getMaxStart() && parent.getMinEnd(index) <= child.getMinEnd() && parent.getLongest(index) >= child.getLongest() && parent.getShortest(index) <= child.getShortest();
    }

    @VisibleForTesting
    public boolean verifyIntersectingChildren(SegmentTreeNode<E> parent, SegmentTreeNode<E> child) {
        int childSequence = child.getSequenceNumber();
        long t = parent.getNodeStart();
        while (t < parent.getNodeEnd()) {
            Collection nextChildren;
            TimeRangeCondition rc = TimeRangeCondition.singleton((long)t);
            boolean shouldBeInCollection = rc.intersects(child.getNodeStart(), child.getNodeEnd());
            if (shouldBeInCollection != (nextChildren = parent.selectNextChildren(rc)).contains(childSequence)) {
                return false;
            }
            ++t;
        }
        return true;
    }
}

