/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.model.elements.ElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public class DebugTargetContentProvider
extends ElementContentProvider {
    @Override
    protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        String id = context.getId();
        if (id.equals("org.eclipse.debug.ui.DebugView")) {
            return ((IDebugTarget)element).getThreads().length;
        }
        if (id.equals("org.eclipse.debug.ui.MemoryView")) {
            return this.getAllChildren(element, context).length;
        }
        return 0;
    }

    @Override
    protected boolean supportsContextId(String id) {
        return "org.eclipse.debug.ui.DebugView".equals(id) || "org.eclipse.debug.ui.MemoryView".equals(id);
    }

    @Override
    protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        return this.getElements(this.getAllChildren(parent, context), index, length);
    }

    @Override
    protected boolean hasChildren(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        String id = context.getId();
        if (id.equals("org.eclipse.debug.ui.DebugView")) {
            return ((IDebugTarget)element).hasThreads();
        }
        if (id.equals("org.eclipse.debug.ui.MemoryView")) {
            return this.getAllChildren(element, context).length > 0;
        }
        return false;
    }

    private Object[] getAllChildren(Object parent, IPresentationContext context) throws CoreException {
        String id = context.getId();
        if (id.equals("org.eclipse.debug.ui.DebugView")) {
            return ((IDebugTarget)parent).getThreads();
        }
        if (id.equals("org.eclipse.debug.ui.MemoryView") && parent instanceof IMemoryBlockRetrieval && ((IMemoryBlockRetrieval)parent).supportsStorageRetrieval()) {
            return DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IMemoryBlockRetrieval)parent);
        }
        return EMPTY;
    }
}

