/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.weighted;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs.weighted.SimpleTree;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs.weighted.SimpleWeightedTreeProvider;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs.weighted.WeightedTreeTestData;
import org.eclipse.tracecompass.analysis.profiling.core.tree.ITree;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTreeGroupBy;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTreeSet;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.AllGroupDescriptor;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.DepthGroupDescriptor;
import org.junit.Assert;
import org.junit.Test;

@NonNullByDefault
public class WeightedTreeGroupByTest {
    private Map<String, WeightedTreeExpected> getExpectedAll() {
        return ImmutableMap.of((Object)"op1", (Object)new WeightedTreeExpected(28L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op2", (Object)new WeightedTreeExpected(8L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op3", (Object)new WeightedTreeExpected(2L, Collections.emptyMap()))), (Object)"op3", (Object)new WeightedTreeExpected(5L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op1", (Object)new WeightedTreeExpected(2L, Collections.emptyMap()))), (Object)"op4", (Object)new WeightedTreeExpected(8L, Collections.emptyMap()))), (Object)"op4", (Object)new WeightedTreeExpected(8L, Collections.emptyMap()), (Object)"op2", (Object)new WeightedTreeExpected(17L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op3", (Object)new WeightedTreeExpected(1L, Collections.emptyMap()), (Object)"op2", (Object)new WeightedTreeExpected(6L, Collections.emptyMap()))), (Object)"op5", (Object)new WeightedTreeExpected(15L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op2", (Object)new WeightedTreeExpected(12L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op3", (Object)new WeightedTreeExpected(1L, Collections.emptyMap()))))));
    }

    private Map<String, WeightedTreeExpected> getExpectedL11() {
        return ImmutableMap.of((Object)"op1", (Object)new WeightedTreeExpected(9L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op2", (Object)new WeightedTreeExpected(5L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op3", (Object)new WeightedTreeExpected(1L, Collections.emptyMap()))))), (Object)"op4", (Object)new WeightedTreeExpected(8L, Collections.emptyMap()), (Object)"op2", (Object)new WeightedTreeExpected(17L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op3", (Object)new WeightedTreeExpected(1L, Collections.emptyMap()), (Object)"op2", (Object)new WeightedTreeExpected(6L, Collections.emptyMap()))));
    }

    private Map<String, WeightedTreeExpected> getExpectedL12() {
        return ImmutableMap.of((Object)"op1", (Object)new WeightedTreeExpected(19L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op3", (Object)new WeightedTreeExpected(5L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op1", (Object)new WeightedTreeExpected(2L, Collections.emptyMap()))), (Object)"op2", (Object)new WeightedTreeExpected(3L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op3", (Object)new WeightedTreeExpected(1L, Collections.emptyMap()))), (Object)"op4", (Object)new WeightedTreeExpected(8L, Collections.emptyMap()))), (Object)"op5", (Object)new WeightedTreeExpected(15L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op2", (Object)new WeightedTreeExpected(12L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op3", (Object)new WeightedTreeExpected(1L, Collections.emptyMap()))))));
    }

    private Map<String, WeightedTreeExpected> getExpectedL21() {
        return ImmutableMap.of((Object)"op1", (Object)new WeightedTreeExpected(9L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op2", (Object)new WeightedTreeExpected(5L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op3", (Object)new WeightedTreeExpected(1L, Collections.emptyMap()))))), (Object)"op4", (Object)new WeightedTreeExpected(8L, Collections.emptyMap()));
    }

    private Map<String, WeightedTreeExpected> getExpectedL22() {
        return ImmutableMap.of((Object)"op2", (Object)new WeightedTreeExpected(17L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op3", (Object)new WeightedTreeExpected(1L, Collections.emptyMap()), (Object)"op2", (Object)new WeightedTreeExpected(6L, Collections.emptyMap()))));
    }

    private Map<String, WeightedTreeExpected> getExpectedL23() {
        return ImmutableMap.of((Object)"op1", (Object)new WeightedTreeExpected(19L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op2", (Object)new WeightedTreeExpected(3L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op3", (Object)new WeightedTreeExpected(1L, Collections.emptyMap()))), (Object)"op3", (Object)new WeightedTreeExpected(5L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op1", (Object)new WeightedTreeExpected(2L, Collections.emptyMap()))), (Object)"op4", (Object)new WeightedTreeExpected(8L, Collections.emptyMap()))));
    }

    private Map<String, WeightedTreeExpected> getExpectedL24() {
        return ImmutableMap.of((Object)"op5", (Object)new WeightedTreeExpected(15L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op2", (Object)new WeightedTreeExpected(12L, (Map<String, WeightedTreeExpected>)ImmutableMap.of((Object)"op3", (Object)new WeightedTreeExpected(1L, Collections.emptyMap()))))));
    }

    private static SimpleWeightedTreeProvider getProvider(boolean withDescriptor) {
        SimpleWeightedTreeProvider provider = new SimpleWeightedTreeProvider();
        provider.setSpecificGroupDescriptor(withDescriptor);
        return provider;
    }

    @Test
    public void testGroupByAll() {
        SimpleWeightedTreeProvider wtProvider = WeightedTreeGroupByTest.getProvider(true);
        this.groupByAll(wtProvider);
    }

    @Test
    public void testGroupByLevel1() {
        SimpleWeightedTreeProvider wtProvider = WeightedTreeGroupByTest.getProvider(true);
        IWeightedTreeGroupDescriptor groupDescriptor = wtProvider.getGroupDescriptor();
        Assert.assertNotNull((Object)groupDescriptor);
        this.groupByLevel1(wtProvider, groupDescriptor);
    }

    @Test
    public void testGroupByLevel2() {
        SimpleWeightedTreeProvider wtProvider = WeightedTreeGroupByTest.getProvider(true);
        IWeightedTreeGroupDescriptor groupDescriptor = wtProvider.getGroupDescriptor();
        Assert.assertNotNull((Object)groupDescriptor);
        groupDescriptor = groupDescriptor.getNextGroup();
        Assert.assertNotNull((Object)groupDescriptor);
        this.groupByLevel2(wtProvider, groupDescriptor);
    }

    @Test
    public void testMultiGroupBys() {
        SimpleWeightedTreeProvider wtProvider = WeightedTreeGroupByTest.getProvider(true);
        IWeightedTreeGroupDescriptor groupDescriptor1 = wtProvider.getGroupDescriptor();
        Assert.assertNotNull((Object)groupDescriptor1);
        IWeightedTreeGroupDescriptor groupDescriptor2 = groupDescriptor1.getNextGroup();
        Assert.assertNotNull((Object)groupDescriptor2);
        this.groupByLevel1(wtProvider, groupDescriptor1);
        this.groupByLevel2(wtProvider, groupDescriptor2);
        this.groupByAll(wtProvider);
        this.groupByLevel1(wtProvider, groupDescriptor1);
        this.groupByAll(wtProvider);
        this.groupByLevel2(wtProvider, groupDescriptor2);
    }

    @Test
    public void testGroupByAllNoGrouping() {
        SimpleWeightedTreeProvider wtProvider = WeightedTreeGroupByTest.getProvider(false);
        this.groupByAll(wtProvider);
    }

    @Test
    public void testGroupByLevel1NoGrouping() {
        SimpleWeightedTreeProvider wtProvider = WeightedTreeGroupByTest.getProvider(false);
        IWeightedTreeGroupDescriptor groupDescriptor = wtProvider.getGroupDescriptor();
        Assert.assertTrue((boolean)(groupDescriptor instanceof DepthGroupDescriptor));
        this.groupByLevel1(wtProvider, groupDescriptor);
    }

    @Test
    public void testGroupByLevel2NoGrouping() {
        SimpleWeightedTreeProvider wtProvider = WeightedTreeGroupByTest.getProvider(false);
        IWeightedTreeGroupDescriptor groupDescriptor = wtProvider.getGroupDescriptor();
        Assert.assertTrue((boolean)(groupDescriptor instanceof DepthGroupDescriptor));
        groupDescriptor = groupDescriptor.getNextGroup();
        Assert.assertTrue((boolean)(groupDescriptor instanceof DepthGroupDescriptor));
        Assert.assertNull((Object)groupDescriptor.getNextGroup());
        this.groupByLevel2(wtProvider, groupDescriptor);
    }

    @Test
    public void testMultiGroupBysNoGrouping() {
        SimpleWeightedTreeProvider wtProvider = WeightedTreeGroupByTest.getProvider(false);
        IWeightedTreeGroupDescriptor groupDescriptor1 = wtProvider.getGroupDescriptor();
        Assert.assertTrue((boolean)(groupDescriptor1 instanceof DepthGroupDescriptor));
        IWeightedTreeGroupDescriptor groupDescriptor2 = groupDescriptor1.getNextGroup();
        Assert.assertTrue((boolean)(groupDescriptor2 instanceof DepthGroupDescriptor));
        this.groupByLevel1(wtProvider, groupDescriptor1);
        this.groupByLevel2(wtProvider, groupDescriptor2);
        this.groupByAll(wtProvider);
        this.groupByLevel1(wtProvider, groupDescriptor1);
        this.groupByAll(wtProvider);
        this.groupByLevel2(wtProvider, groupDescriptor2);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void groupByAll(SimpleWeightedTreeProvider wtProvider) {
        WeightedTreeSet wts = WeightedTreeGroupBy.groupWeightedTreeBy((IWeightedTreeGroupDescriptor)AllGroupDescriptor.getInstance(), wtProvider.getTreeSet(), (IWeightedTreeProvider)wtProvider);
        @NonNull Collection elements = wts.getElements();
        Assert.assertEquals((long)1L, (long)elements.size());
        for (Object element : elements) {
            Collection trees = wts.getTreesFor(element);
            this.compareCcts("Group By All", this.getExpectedAll(), trees);
        }
    }

    private void groupByLevel1(SimpleWeightedTreeProvider wtProvider, IWeightedTreeGroupDescriptor descriptor) {
        WeightedTreeSet wts = WeightedTreeGroupBy.groupWeightedTreeBy((IWeightedTreeGroupDescriptor)descriptor, wtProvider.getTreeSet(), (IWeightedTreeProvider)wtProvider);
        Collection elements = wts.getElements();
        Assert.assertEquals((long)2L, (long)elements.size());
        for (Object element : elements) {
            Collection trees;
            Assert.assertTrue((boolean)(element instanceof SimpleTree));
            SimpleTree treeEl = (SimpleTree)element;
            if (treeEl.getName().equals(WeightedTreeTestData.OBJ_L11.getName())) {
                Assert.assertTrue((boolean)((SimpleTree)element).getChildren().isEmpty());
                trees = wts.getTreesFor(element);
                this.compareCcts("obj11", this.getExpectedL11(), trees);
                continue;
            }
            if (treeEl.getName().equals(WeightedTreeTestData.OBJ_L12.getName())) {
                Assert.assertTrue((boolean)((SimpleTree)element).getChildren().isEmpty());
                trees = wts.getTreesFor(element);
                this.compareCcts("obj12", this.getExpectedL12(), trees);
                continue;
            }
            Assert.fail((String)("Unexpected element: " + String.valueOf(element)));
        }
    }

    private void groupByLevel2(SimpleWeightedTreeProvider wtProvider, IWeightedTreeGroupDescriptor descriptor) {
        WeightedTreeSet wts = WeightedTreeGroupBy.groupWeightedTreeBy((IWeightedTreeGroupDescriptor)descriptor, wtProvider.getTreeSet(), (IWeightedTreeProvider)wtProvider);
        Collection elements = wts.getElements();
        Assert.assertEquals((long)2L, (long)elements.size());
        for (Object element : elements) {
            SimpleTree childTreeEl;
            Collection children;
            Collection trees;
            Assert.assertTrue((boolean)(element instanceof SimpleTree));
            SimpleTree treeEl = (SimpleTree)element;
            if (treeEl.getName().equals(WeightedTreeTestData.OBJ_L11.getName())) {
                trees = wts.getTreesFor(element);
                Assert.assertTrue((boolean)trees.isEmpty());
                children = ((ITree)element).getChildren();
                Assert.assertEquals((long)2L, (long)children.size());
                for (Object child : children) {
                    Assert.assertTrue((boolean)(child instanceof SimpleTree));
                    childTreeEl = (SimpleTree)child;
                    if (childTreeEl.getName().equals(WeightedTreeTestData.OBJ_L21.getName())) {
                        trees = wts.getTreesFor(child);
                        this.compareCcts("obj21", this.getExpectedL21(), trees);
                        continue;
                    }
                    if (childTreeEl.getName().equals(WeightedTreeTestData.OBJ_L22.getName())) {
                        trees = wts.getTreesFor(child);
                        this.compareCcts("obj22", this.getExpectedL22(), trees);
                        continue;
                    }
                    Assert.fail((String)("Unexpected element: " + String.valueOf(child)));
                }
                continue;
            }
            if (treeEl.getName().equals(WeightedTreeTestData.OBJ_L12.getName())) {
                trees = wts.getTreesFor(element);
                Assert.assertTrue((boolean)trees.isEmpty());
                children = ((ITree)element).getChildren();
                Assert.assertEquals((long)2L, (long)children.size());
                for (Object child : children) {
                    Assert.assertTrue((boolean)(child instanceof SimpleTree));
                    childTreeEl = (SimpleTree)child;
                    if (childTreeEl.getName().equals(WeightedTreeTestData.OBJ_L23.getName())) {
                        trees = wts.getTreesFor(child);
                        this.compareCcts("obj23", this.getExpectedL23(), trees);
                        continue;
                    }
                    if (childTreeEl.getName().equals(WeightedTreeTestData.OBJ_L24.getName())) {
                        trees = wts.getTreesFor(child);
                        this.compareCcts("obj24", this.getExpectedL24(), trees);
                        continue;
                    }
                    Assert.fail((String)("Unexpected element: " + String.valueOf(child)));
                }
                continue;
            }
            Assert.fail((String)("Unexpected element: " + String.valueOf(element)));
        }
    }

    private void compareCcts(String prefix, Map<String, WeightedTreeExpected> expected, Collection<WeightedTree<String>> trees) {
        Assert.assertEquals((String)(prefix + " size"), (long)expected.size(), (long)trees.size());
        for (WeightedTree<String> tree : trees) {
            WeightedTreeExpected wtExpected = expected.get(tree.getObject());
            Assert.assertNotNull((Object)wtExpected);
            Assert.assertEquals((String)(prefix + " object " + (String)tree.getObject()), (long)wtExpected.duration, (long)tree.getWeight());
            this.compareCcts(prefix + (String)tree.getObject() + ", ", wtExpected.children, tree.getChildren());
        }
    }

    private class WeightedTreeExpected {
        public long duration;
        public Map<String, WeightedTreeExpected> children;

        public WeightedTreeExpected(long dur, Map<String, WeightedTreeExpected> childMap) {
            this.duration = dur;
            this.children = childMap;
        }
    }
}

