/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.icu.impl;

import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.eclipse.uomo.core.UOMoRuntimeException;
import org.eclipse.uomo.icu.impl.TimeTz;
import org.eclipse.uomo.icu.types.IBasicType;

public class TimeStamp
extends Date
implements IBasicType {
    static final long serialVersionUID = 362498820763181265L;

    public TimeStamp() {
        super(TimeStamp.BuildTimeStamp().getTime());
    }

    public TimeStamp(long m) {
        super(m);
    }

    public TimeStamp(String s) throws UOMoRuntimeException {
        super(TimeStamp.BuildTimeStamp(s).getTime());
    }

    public TimeStamp(Timestamp ts) throws UOMoRuntimeException {
        super(TimeStamp.BuildTimeStamp(ts).getTime());
    }

    static TimeStamp BuildTimeStamp() {
        GregorianCalendar aGregCal = new GregorianCalendar();
        Date date = aGregCal.getTime();
        return new TimeStamp(date.getTime());
    }

    static TimeStamp BuildTimeStamp(String s) throws UOMoRuntimeException {
        int sp = s.indexOf(59);
        String str = sp == -1 ? s : s.substring(0, sp);
        String adj = null;
        TimeZone tz = null;
        sp = str.indexOf(33);
        if (sp > -1) {
            String zoneString = str.substring(sp + 1);
            tz = TimeTz.GetTimeZone(zoneString);
            if (tz == null) {
                throw new UOMoRuntimeException("Time Zone not found: " + zoneString);
            }
            str = str.substring(0, sp);
        } else {
            sp = str.indexOf(43);
            if (sp == -1) {
                sp = str.indexOf(45);
            }
            if (sp > -1) {
                adj = str.substring(sp);
                str = str.substring(0, sp);
            }
        }
        if (str.length() < 14) {
            throw new UOMoRuntimeException("Timestamp too short: " + s);
        }
        if (str.charAt(8) != 'T' || str.charAt(11) != ':') {
            throw new UOMoRuntimeException("Invalid TimeStamp: " + s);
        }
        String secs = "00000";
        if (str.length() > 14) {
            if (str.charAt(14) != ':') {
                throw new UOMoRuntimeException("Invalid TimeStamp: " + s);
            }
            if (str.length() != 17 && str.length() != 20) {
                throw new UOMoRuntimeException("Invalid TimeStamp: " + s);
            }
            secs = String.valueOf(str.substring(15)) + secs;
            secs = secs.substring(0, 5);
        }
        TimeZone zone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHH:mmssSSS");
        formatter.setTimeZone(zone);
        String dateString = String.valueOf(str.substring(0, 8)) + str.substring(9, 14) + secs;
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(dateString, pos);
        TimeStamp ts = new TimeStamp(date.getTime());
        long millis = 0L;
        if (tz != null) {
            millis = ts.getTime();
            ts.setTime(millis -= (long)tz.getRawOffset());
            if (tz.inDaylightTime(ts)) {
                millis -= 3600000L;
            }
            ts.setTime(millis);
        }
        if (adj != null) {
            int hrs;
            int mins = 0;
            if (adj.length() == 3) {
                hrs = Integer.parseInt(adj.substring(1));
            } else {
                if (adj.charAt(3) != ':' || adj.length() != 6) {
                    throw new UOMoRuntimeException("Invalid TimeStamp adjustment: " + s);
                }
                hrs = Integer.parseInt(adj.substring(1, 3));
                mins = Integer.parseInt(adj.substring(4, 6));
            }
            if (adj.charAt(0) == '+') {
                hrs = -hrs;
                mins = -mins;
            } else if (adj.charAt(0) != '-') {
                throw new UOMoRuntimeException("Invalid TimeStamp adjustment sign: " + s);
            }
            millis = ts.getTime();
            ts.setTime(millis += (long)((3600 * hrs + 60 * mins) * 1000));
        }
        return ts;
    }

    static TimeStamp BuildTimeStamp(Timestamp ts) throws UOMoRuntimeException {
        long millis = ts.getTime();
        return new TimeStamp(millis += (long)(ts.getNanos() / 1000000));
    }

    public Timestamp convertToSQL() {
        long millis = this.getTime() % 1000L;
        Timestamp ts = new Timestamp(this.getTime() - millis);
        ts.setNanos(new Long(millis * 1000000L).intValue());
        return ts;
    }

    public String formatWithZone(String s) throws UOMoRuntimeException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHH:mm:ssSSS");
        TimeZone zone = TimeZone.getTimeZone("UTC");
        formatter.setTimeZone(zone);
        long millis = this.getTime();
        TimeStamp ts = new TimeStamp(millis);
        String z = s;
        if (s.charAt(0) == '+' || s.charAt(0) == '-') {
            int hrs;
            int mins = 0;
            if (s.length() == 3) {
                hrs = Integer.parseInt(s.substring(1));
            } else {
                if (s.charAt(3) != ':' || s.length() != 6) {
                    throw new UOMoRuntimeException("Invalid TimeStamp adjustment: " + s);
                }
                hrs = Integer.parseInt(s.substring(1, 3));
                mins = Integer.parseInt(s.substring(4, 6));
            }
            if (s.charAt(0) == '-') {
                hrs = -hrs;
                mins = -mins;
            }
            ts.setTime(millis += (long)((hrs * 3600 + mins * 60) * 1000));
        } else {
            TimeZone tz = TimeTz.GetTimeZone(s);
            if (tz == null) {
                throw new UOMoRuntimeException("Time Zone not found: " + s);
            }
            ts.setTime(millis += (long)tz.getRawOffset());
            if (tz.inDaylightTime(ts)) {
                ts.setTime(millis + 3600000L);
            }
            z = String.valueOf('!') + s;
        }
        String str = formatter.format(ts);
        str = String.valueOf(str.substring(0, 8)) + 'T' + str.substring(8) + z;
        return str;
    }

    @Override
    public String serialize() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHH:mm:ssSSS");
        TimeZone zone = TimeZone.getTimeZone("UTC");
        formatter.setTimeZone(zone);
        String str = formatter.format(this);
        str = String.valueOf(str.substring(0, 8)) + 'T' + str.substring(8) + "+00:00";
        return str;
    }

    @Override
    public String toString() {
        return this.serialize();
    }
}

