/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.icu.impl;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.uomo.core.UOMoRuntimeException;
import org.eclipse.uomo.icu.types.IMarket;

abstract class UHelper {
    public static MathContext MATH_CONTEXT = new MathContext(20);
    static HashMap<String, String> s_countryTable = null;
    public static final String DEFAULT_COUNTRY = "CA";
    static HashMap<String, IMarket> s_marketTable;

    static {
        s_countryTable = new HashMap();
        s_countryTable.put(DEFAULT_COUNTRY, null);
        s_countryTable.put("US", null);
        s_marketTable = new HashMap();
    }

    public static Map<String, String> getCountries() {
        return s_countryTable;
    }

    private UHelper() {
    }

    static int[] calcVulgarFrac(BigDecimal bd) throws UOMoRuntimeException {
        int[] parts = new int[3];
        parts[0] = bd.intValue();
        BigDecimal temp = new BigDecimal(parts[0]);
        BigDecimal temp2 = bd.subtract(temp, MATH_CONTEXT);
        String s = temp2.toString();
        int len = s.length() - s.indexOf(46) - 1;
        BigDecimal two = new BigDecimal(2);
        BigDecimal pow = two.pow(len);
        parts[2] = pow.intValue();
        pow = pow.multiply(temp2, MATH_CONTEXT);
        try {
            parts[1] = pow.intValueExact();
        }
        catch (ArithmeticException arithmeticException) {
            parts[2] = 0;
            throw new UOMoRuntimeException("Fractional value not divisible by power of 2: " + bd);
        }
        return parts;
    }

    static boolean comp(BigDecimal x, BigDecimal y, Operation op) throws UOMoRuntimeException {
        switch (op) {
            case EQ: {
                return x.compareTo(y) == 0;
            }
            case NE: {
                return x.compareTo(y) != 0;
            }
            case LT: {
                return -1 == x.compareTo(y);
            }
            case LE: {
                return 1 != x.compareTo(y);
            }
            case GT: {
                return 1 == x.compareTo(y);
            }
            case GE: {
                return -1 != x.compareTo(y);
            }
        }
        throw new UOMoRuntimeException("Unknown compare operator: " + (Object)((Object)op));
    }

    public static Map<String, IMarket> getMarkets() {
        return s_marketTable;
    }

    public static enum Operation {
        EQ,
        LT,
        LE,
        GT,
        GE,
        NE;

    }
}

