/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.ucum.parsers;

import org.eclipse.uomo.ucum.expression.Component;
import org.eclipse.uomo.ucum.expression.Factor;
import org.eclipse.uomo.ucum.expression.Operator;
import org.eclipse.uomo.ucum.expression.Symbol;
import org.eclipse.uomo.ucum.expression.Term;

public class ExpressionComposer {
    public String compose(Term term) {
        if (term == null) {
            return "1";
        }
        StringBuilder bldr = new StringBuilder();
        this.composeTerm(bldr, term);
        return bldr.toString();
    }

    private void composeTerm(StringBuilder bldr, Term term) {
        if (term.getComp() != null) {
            this.composeComp(bldr, term.getComp());
        }
        if (term.getOp() != null) {
            this.composeOp(bldr, term.getOp());
        }
        if (term.getTerm() != null) {
            this.composeTerm(bldr, term.getTerm());
        }
    }

    private void composeComp(StringBuilder bldr, Component comp) {
        if (comp instanceof Factor) {
            this.composeFactor(bldr, (Factor)comp);
        } else if (comp instanceof Symbol) {
            this.composeSymbol(bldr, (Symbol)comp);
        } else if (comp instanceof Term) {
            bldr.append('(');
            this.composeTerm(bldr, (Term)comp);
            bldr.append(')');
        } else {
            bldr.append('?');
        }
    }

    private void composeSymbol(StringBuilder bldr, Symbol symbol) {
        if (symbol.getPrefix() != null) {
            bldr.append(symbol.getPrefix().getCode());
        }
        bldr.append(symbol.getUnit().getCode());
        if (symbol.getExponent() != 1) {
            bldr.append(symbol.getExponent());
        }
    }

    private void composeFactor(StringBuilder bldr, Factor comp) {
        bldr.append(comp.getValue());
    }

    private void composeOp(StringBuilder bldr, Operator op) {
        if (op == Operator.DIVISION) {
            bldr.append("/");
        } else {
            bldr.append(".");
        }
    }
}

