/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.ucum.parsers;

import org.eclipse.uomo.core.UOMoRuntimeException;
import org.eclipse.uomo.ucum.parsers.TokenType;

public class Lexer {
    private static final char NO_CHAR = '\u0000';
    private String source;
    private int index;
    private String token;
    private TokenType type;
    private int start;

    public Lexer(String source) throws UOMoRuntimeException {
        this.source = source;
        if (source == null) {
            source = "";
        }
        this.index = 0;
        this.consume();
    }

    public void consume() throws UOMoRuntimeException {
        char ch;
        this.token = null;
        this.type = TokenType.NONE;
        this.start = this.index;
        if (!(this.index >= this.source.length() || this.checkSingle(ch = this.nextChar(), '/', TokenType.SOLIDUS) || this.checkSingle(ch, '.', TokenType.PERIOD) || this.checkSingle(ch, '(', TokenType.OPEN) || this.checkSingle(ch, ')', TokenType.CLOSE) || this.checkAnnotation(ch) || this.checkNumber(ch) || this.checkNumberOrSymbol(ch))) {
            throw new UOMoRuntimeException("Error processing unit '" + this.source + "': unexpected character '" + ch + "' at position " + Integer.toString(this.start));
        }
    }

    private boolean checkNumber(char ch) throws UOMoRuntimeException {
        if (ch == '+' || ch == '-') {
            this.token = String.valueOf(ch);
            ch = this.peekChar();
            while (ch >= '0' && ch <= '9') {
                this.token = String.valueOf(this.token) + ch;
                ++this.index;
                ch = this.peekChar();
            }
            if (this.token.length() == 1) {
                throw new UOMoRuntimeException("Error processing unit'" + this.source + "': unexpected character '" + ch + "' at position " + Integer.toString(this.start) + ": a + or - must be followed by at least one digit");
            }
            this.type = TokenType.NUMBER;
            return true;
        }
        return false;
    }

    private boolean checkNumberOrSymbol(char ch) throws UOMoRuntimeException {
        boolean isSymbol = false;
        boolean inBrackets = false;
        if (this.isValidSymbolChar(ch, true)) {
            this.token = String.valueOf(ch);
            isSymbol = isSymbol || ch < '0' || ch > '9';
            inBrackets = this.checkBrackets(ch, inBrackets);
            ch = this.peekChar();
            inBrackets = this.checkBrackets(ch, inBrackets);
            while (this.isValidSymbolChar(ch, !isSymbol || inBrackets)) {
                this.token = String.valueOf(this.token) + ch;
                isSymbol = isSymbol || ch != '\u0000' && (ch < '0' || ch > '9');
                ++this.index;
                ch = this.peekChar();
                inBrackets = this.checkBrackets(ch, inBrackets);
            }
            this.type = isSymbol ? TokenType.SYMBOL : TokenType.NUMBER;
            return true;
        }
        return false;
    }

    private boolean checkBrackets(char ch, boolean inBrackets) throws UOMoRuntimeException {
        if (ch == '[') {
            if (inBrackets) {
                this.error("Nested [");
            } else {
                return true;
            }
        }
        if (ch == ']') {
            if (!inBrackets) {
                this.error("] without [");
            } else {
                return false;
            }
        }
        return inBrackets;
    }

    private boolean isValidSymbolChar(char ch, boolean allowDigits) {
        return allowDigits && ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '[' || ch == ']' || ch == '%' || ch == '*' || ch == '^' || ch == '\'' || ch == '\"' || ch == '_';
    }

    private boolean checkAnnotation(char ch) throws UOMoRuntimeException {
        if (ch == '{') {
            while (ch != '}') {
                ch = this.nextChar();
                if (ch != '\u0000') continue;
                throw new UOMoRuntimeException("Error processing unit'" + this.source + "': unterminated annotation");
            }
            this.consume();
            return true;
        }
        return false;
    }

    private boolean checkSingle(char ch, char test, TokenType type) {
        if (ch == test) {
            this.token = String.valueOf(ch);
            this.type = type;
            return true;
        }
        return false;
    }

    private char nextChar() {
        char res = this.index < this.source.length() ? this.source.charAt(this.index) : (char)'\u0000';
        ++this.index;
        return res;
    }

    private char peekChar() {
        return this.index < this.source.length() ? this.source.charAt(this.index) : (char)'\u0000';
    }

    public String getToken() {
        return this.token;
    }

    public TokenType getType() {
        return this.type;
    }

    public void error(String errMsg) throws UOMoRuntimeException {
        throw new UOMoRuntimeException("Error processing unit '" + this.source + "': " + errMsg + "' at position " + Integer.toString(this.start));
    }

    public int getTokenAsInt() {
        return this.token.charAt(0) == '+' ? Integer.parseInt(this.token.substring(1)) : Integer.parseInt(this.token);
    }
}

