/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.html;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.dom.DOMStyleUtil;
import org.eclipse.jst.pagedesigner.dom.html.TableUtil;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;

public class TableResizeColumnCommand
extends DesignerCommand {
    private Element _table;
    private TableUtil _tableUtil;
    private int _columnIndex;
    private int _delta;

    public TableResizeColumnCommand(IHTMLGraphicalViewer viewer, Element table, int columnIndex, int delta) {
        super(CommandResources.getString("TableResizeColumnCommand.Label.ResizeColumn"), viewer);
        this._table = table;
        this._columnIndex = columnIndex;
        this._delta = delta;
        this._tableUtil = new TableUtil(this._table);
    }

    @Override
    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._table);
    }

    @Override
    protected void doExecute() {
        int index = this._columnIndex - 1;
        if (index < 0) {
            index = 0;
        }
        List list = this._tableUtil.getColumnCells(index);
        Iterator itr = list.iterator();
        Element cell = null;
        while (itr.hasNext()) {
            Element ele = (Element)itr.next();
            if (ele.getTagName().equalsIgnoreCase("fake") || DOMUtil.getIntAttributeIgnoreCase(ele, "colspan", 1) > 1) continue;
            cell = ele;
            break;
        }
        IFigure cellFigure = this.getFigureInfo(cell);
        int oldColumnWidth = cellFigure.getBounds().width;
        int cellPadding = cellFigure.getInsets().getWidth();
        int newWidth = oldColumnWidth + this._delta - cellPadding;
        if (this._columnIndex - 1 < 0) {
            newWidth = oldColumnWidth - this._delta - cellPadding;
        }
        HashMap<String, CallSite> map = new HashMap<String, CallSite>();
        if (newWidth > 0) {
            map.put("width", (CallSite)((Object)(newWidth + "px")));
            DOMStyleUtil.insertStyle(cell, map);
        }
    }
}

