/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import org.eclipse.draw2d.LayoutManager;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSBlockFlowLayout;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.CSSInlineFlowLayout;
import org.eclipse.jst.pagedesigner.css2.layout.CSSLayout;
import org.eclipse.jst.pagedesigner.css2.layout.CSSListItemLayout;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTRGroupLayout;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTRLayout;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTableCaptionLayout;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTableCellLayout;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTableLayout2;

public final class DisplayToLayout {
    public static CSSLayout displayToLayout(CSSFigure figure, String display, LayoutManager old) {
        if ("block".equalsIgnoreCase(display)) {
            return new CSSBlockFlowLayout(figure);
        }
        if ("inline".equalsIgnoreCase(display)) {
            return new CSSInlineFlowLayout(figure);
        }
        if ("table".equalsIgnoreCase(display) || "inline-table".equalsIgnoreCase(display)) {
            return new CSSTableLayout2(figure);
        }
        if ("table-row".equalsIgnoreCase(display)) {
            return new CSSTRLayout(figure);
        }
        if ("table-row-group".equalsIgnoreCase(display) || "table-header-group".equalsIgnoreCase(display) || "table-footer-group".equalsIgnoreCase(display)) {
            return new CSSTRGroupLayout(figure);
        }
        if ("table-cell".equalsIgnoreCase(display)) {
            return new CSSTableCellLayout(figure);
        }
        if (display.equalsIgnoreCase("table-caption")) {
            return new CSSTableCaptionLayout(figure);
        }
        if ("inline-block".equalsIgnoreCase(display)) {
            return new CSSBlockFlowLayout(figure){

                @Override
                public boolean isInlineBlock() {
                    return true;
                }
            };
        }
        if ("list-item".equalsIgnoreCase(display)) {
            return new CSSListItemLayout(figure);
        }
        return null;
    }

    public static boolean isInline(String display) {
        return "inline".equalsIgnoreCase(display) || "inline-block".equalsIgnoreCase(display);
    }

    public static boolean isPositioned(ICSSStyle style) {
        Object position = style.getStyleProperty("position");
        return !"static".equalsIgnoreCase((String)position);
    }

    private DisplayToLayout() {
    }
}

