/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.property.CSSPropertyMeta;
import org.eclipse.jst.pagedesigner.css2.property.TableUtil;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BorderStyleMeta
extends CSSPropertyMeta {
    static final String[] KEYWORDS = new String[]{"none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset"};

    public BorderStyleMeta() {
        super(false, "none");
    }

    @Override
    protected String[] getKeywordValues() {
        return KEYWORDS;
    }

    @Override
    public Object calculateHTMLAttributeOverride(Element element, String htmltag, String propertyName, ICSSStyle style) {
        String border;
        if ("table".equalsIgnoreCase(htmltag)) {
            return this.calculateTableOverride(element, propertyName);
        }
        if ("td".equalsIgnoreCase(htmltag) || "th".equalsIgnoreCase(htmltag)) {
            return this.calculateTDOverride(element, propertyName, style);
        }
        if ("img".equalsIgnoreCase(htmltag) && (border = DOMUtil.getAttributeIgnoreCase(element, "border")) != null) {
            return "solid";
        }
        return super.calculateHTMLAttributeOverride(element, htmltag, propertyName, style);
    }

    private Object calculateTDOverride(Element element, String propertyName, ICSSStyle style) {
        Object obj = style.getStyleProperty("empty-cells");
        if ("hide".equals(obj) && TableUtil.isEmptyCell(element)) {
            return "none";
        }
        Node parent = element;
        Element tableEle = null;
        while ((parent = parent.getParentNode()) != null && parent instanceof Element) {
            if (!parent.getTagName().equalsIgnoreCase("table")) continue;
            tableEle = (Element)parent;
            break;
        }
        if (tableEle != null) {
            String rules = DOMUtil.getAttributeIgnoreCase(tableEle, "rules");
            String borderstr = DOMUtil.getAttributeIgnoreCase(tableEle, "border");
            if (rules == null || rules.length() == 0) {
                if (borderstr == null || "0".equals(borderstr.trim())) {
                    return "none";
                }
                return "__td_border_style__";
            }
            if (TableUtil.matchRules(BorderStyleMeta.extractEdge(propertyName), rules)) {
                return "__td_border_style__";
            }
            return "none";
        }
        return null;
    }

    private Object calculateTableOverride(Element element, String propertyName) {
        String frame = DOMUtil.getAttributeIgnoreCase(element, "frame");
        String borderstr = DOMUtil.getAttributeIgnoreCase(element, "border");
        if ("0".equals(borderstr)) {
            return "none";
        }
        if (frame == null || frame.length() == 0) {
            if (borderstr == null) {
                return "none";
            }
            if (borderstr.trim().length() == 0) {
                frame = "border";
            } else {
                try {
                    Integer.parseInt(borderstr);
                    frame = "border";
                }
                catch (Exception exception) {
                    frame = borderstr;
                }
            }
        }
        if (TableUtil.matchFrame(BorderStyleMeta.extractEdge(propertyName), frame)) {
            return "outset";
        }
        return "none";
    }

    static String extractEdge(String propertyName) {
        if ("border-bottom-style".equalsIgnoreCase(propertyName)) {
            return "bottom";
        }
        if ("border-left-style".equalsIgnoreCase(propertyName)) {
            return "left";
        }
        if ("border-right-style".equalsIgnoreCase(propertyName)) {
            return "right";
        }
        return "top";
    }

    public static boolean isBorderStyle(String propertyName) {
        return "border-bottom-style".equalsIgnoreCase(propertyName) || "border-left-style".equalsIgnoreCase(propertyName) || "border-right-style".equalsIgnoreCase(propertyName) || "border-top-style".equalsIgnoreCase(propertyName);
    }
}

