/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.analyzer;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.wst.common.uriresolver.internal.util.URIEncoder;
import org.eclipse.wst.wsi.internal.WSIPreferences;
import org.eclipse.wst.wsi.internal.WSITestToolsEclipseProperties;
import org.eclipse.wst.wsi.internal.WSITestToolsProperties;
import org.eclipse.wst.wsi.internal.analyzer.WSIAnalyzerException;
import org.eclipse.wst.wsi.internal.analyzer.WSIBasicProfileAnalyzer;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AnalyzerConfig;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AssertionResultType;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.AssertionResultsOptionImpl;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.WSDLElementImpl;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.WSDLReferenceImpl;
import org.eclipse.wst.wsi.internal.core.common.impl.AddStyleSheetImpl;
import org.eclipse.wst.wsi.internal.core.document.DocumentFactory;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.report.Entry;
import org.eclipse.wst.wsi.internal.core.report.impl.FailureDetailImpl;
import org.eclipse.wst.wsi.internal.core.report.impl.ReportImpl;
import org.eclipse.wst.wsi.internal.core.xml.dom.ElementLocation;
import org.eclipse.wst.wsi.internal.report.AssertionError;

public class WSDLAnalyzer {
    public static final String PLUGIN_ID = "org.wsi.test.tools";
    public static final String PORT = "port";
    public static final String BINDING = "binding";
    public static final String PORTTYPE = "portType";
    public static final String OPERATION = "operation";
    public static final String MESSAGE = "message";
    protected final String NOTPASSED = "notPassed";
    protected final String WARNING = "warning";
    protected final String FAILED = "failed";
    protected List analyzerConfigs;
    protected String wsdlURI;
    protected List assertionerrors;
    protected List assertionwarnings;
    protected WSIPreferences wsiPreferences = null;

    public WSDLAnalyzer(String fileName, String parentName, String namespace, String elementName, String elementType, WSIPreferences wsiPreferences) throws WSIAnalyzerException {
        this(fileName, wsiPreferences);
        this.addConfigurationToTest(parentName, namespace, elementName, elementType);
    }

    public WSDLAnalyzer(String fileName, String parentName, String namespace, String elementName, String elementType) throws WSIAnalyzerException {
        this(fileName);
        this.addConfigurationToTest(parentName, namespace, elementName, elementType);
    }

    public WSDLAnalyzer(String fileName, WSIPreferences wsiPreferences) {
        this.reset(fileName);
        this.wsiPreferences = wsiPreferences;
    }

    public WSDLAnalyzer(String fileName) {
        this.reset(fileName);
        this.wsiPreferences = WSITestToolsProperties.getEclipseContext() ? WSITestToolsEclipseProperties.checkWSIPreferences(fileName) : WSITestToolsProperties.checkWSIPreferences(fileName);
    }

    public WSIPreferences getWSIPreferences() {
        return this.wsiPreferences;
    }

    public void validateConformance() throws WSIAnalyzerException {
        block11: {
            try {
                if (this.wsiPreferences.getComplianceLevel() == "2") break block11;
                WSIBasicProfileAnalyzer bpanalyzer = new WSIBasicProfileAnalyzer(this.analyzerConfigs, this.wsdlURI);
                bpanalyzer.validateAll();
                ReportImpl report = (ReportImpl)bpanalyzer.getReport();
                List entries = report.getEntries();
                if (entries == null) break block11;
                for (Entry entry : entries) {
                    TreeMap assertionResults = entry.getAssertionResultList();
                    if (assertionResults == null) continue;
                    for (AssertionResult ar : assertionResults.values()) {
                        ElementLocation el;
                        int columnNumber;
                        int lineNumber;
                        Vector errorMessageList;
                        TestAssertion ta = ar.getAssertion();
                        if (ar.getResult().equalsIgnoreCase("failed") && this.wsiPreferences.getComplianceLevel().equals("0")) {
                            if (!ta.isEnabled()) continue;
                            errorMessageList = ar.getFailureDetailList();
                            if (errorMessageList != null) {
                                for (FailureDetailImpl fdi : errorMessageList) {
                                    lineNumber = 0;
                                    columnNumber = 0;
                                    el = fdi.getElementLocation();
                                    if (el != null) {
                                        lineNumber = el.getLineNumber();
                                        columnNumber = el.getColumnNumber();
                                    }
                                    this.assertionerrors.add(new AssertionError(ta.getId(), ta.getFailureMessage(), lineNumber, columnNumber));
                                }
                                continue;
                            }
                            this.assertionerrors.add(new AssertionError(ta.getId(), ta.getFailureMessage(), 0, 0));
                            continue;
                        }
                        if (!ar.getResult().equalsIgnoreCase("failed") || !this.wsiPreferences.getComplianceLevel().equals("1") || !ta.isEnabled()) continue;
                        errorMessageList = ar.getFailureDetailList();
                        if (errorMessageList != null) {
                            for (FailureDetailImpl fdi : errorMessageList) {
                                lineNumber = 0;
                                columnNumber = 0;
                                el = fdi.getElementLocation();
                                if (el != null) {
                                    lineNumber = el.getLineNumber();
                                    columnNumber = el.getColumnNumber();
                                }
                                this.assertionwarnings.add(new AssertionError(ta.getId(), ta.getFailureMessage(), lineNumber, columnNumber));
                            }
                            continue;
                        }
                        this.assertionwarnings.add(new AssertionError(ta.getId(), ta.getFailureMessage(), 0, 0));
                    }
                }
            }
            catch (Exception e) {
                throw new WSIAnalyzerException(e + "The WSDLAnalyzer was unable to validate the given WSDL File.");
            }
        }
    }

    public void addConfigurationToTest(String parentName, String namespace, String elementName, String elementType) throws WSIAnalyzerException {
        try {
            WSDLReferenceImpl wsdlReference = new WSDLReferenceImpl();
            WSDLElementImpl wsdlElement = new WSDLElementImpl();
            wsdlElement.setType(elementType);
            if (parentName != null) {
                wsdlElement.setParentElementName(parentName);
            }
            wsdlElement.setNamespace(namespace);
            wsdlElement.setName(elementName);
            wsdlReference.setWSDLElement(wsdlElement);
            wsdlReference.setWSDLLocation(this.wsdlURI);
            DocumentFactory documentFactory = DocumentFactory.newInstance();
            AnalyzerConfig analyzerconfig = documentFactory.newAnalyzerConfig();
            AssertionResultsOptionImpl aro = new AssertionResultsOptionImpl();
            aro.setAssertionResultType(AssertionResultType.newInstance("notPassed"));
            aro.setShowAssertionDescription(false);
            aro.setShowFailureDetail(false);
            aro.setShowFailureMessage(false);
            aro.setShowMessageEntry(false);
            AddStyleSheetImpl addstylesheet = new AddStyleSheetImpl();
            analyzerconfig.setAssertionResultsOption(aro);
            analyzerconfig.setAddStyleSheet(addstylesheet);
            analyzerconfig.setReplaceReport(true);
            analyzerconfig.setTestAssertionsDocumentLocation(this.wsiPreferences.getTADFile());
            analyzerconfig.setVerboseOption(false);
            analyzerconfig.setWSDLReference(wsdlReference);
            this.analyzerConfigs.add(analyzerconfig);
        }
        catch (Exception e) {
            throw new WSIAnalyzerException("Unable to add AnalyzerConfig to list. " + e);
        }
    }

    public List getAssertionErrors() {
        return this.assertionerrors;
    }

    public List getAssertionWarnings() {
        return this.assertionwarnings;
    }

    public void reset(String filename) {
        if (filename != null) {
            String tmp = filename.replace('\\', '/');
            if (!tmp.startsWith("http:") && !tmp.startsWith("file:")) {
                tmp = "file:///" + tmp;
            }
            try {
                this.wsdlURI = URIEncoder.encode((String)tmp, (String)"UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        this.analyzerConfigs = new Vector();
        this.assertionerrors = new Vector();
        this.assertionwarnings = new Vector();
    }
}

