/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.util.List;
import java.util.Map;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPConstants;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;

public class BP4104
extends AssertionProcess {
    private final BaseMessageValidator validator;
    private List knownHeaderNames;

    public BP4104(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
        this.knownHeaderNames = null;
    }

    private List getAllKnownHeaderNames() {
        if (this.knownHeaderNames == null) {
            this.knownHeaderNames = HTTPConstants.getAllKnownHeaderNames();
        }
        return this.knownHeaderNames;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Map hmap = HTTPUtils.getHttpHeaderTokens(entryContext.getMessageEntry().getHTTPHeaders(), ":");
        for (String headerName : hmap.keySet()) {
            if (this.getAllKnownHeaderNames().contains(headerName.toUpperCase())) continue;
            this.failureDetail = this.validator.createFailureDetail(testAssertion.getDetailDescription(), entryContext);
            break;
        }
        if (this.failureDetail == null) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

