/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.listeners;

import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.utility.internal.RunnableAdapter;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Sequence;
import org.eclipse.jpt.jpa.db.Table;

public class SWTConnectionListenerWrapper
implements ConnectionListener {
    private final ConnectionListener listener;

    public SWTConnectionListenerWrapper(ConnectionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void opened(ConnectionProfile profile) {
        this.execute((Runnable)((Object)new OpenedRunnable(profile)));
    }

    void opened_(ConnectionProfile profile) {
        this.listener.opened(profile);
    }

    public void modified(ConnectionProfile profile) {
        this.execute((Runnable)((Object)new ModifiedRunnable(profile)));
    }

    void modified_(ConnectionProfile profile) {
        this.listener.modified(profile);
    }

    public boolean okToClose(ConnectionProfile profile) {
        OkToCloseRunnable r = new OkToCloseRunnable(profile);
        this.execute((Runnable)((Object)r));
        return r.result;
    }

    boolean okToClose_(ConnectionProfile profile) {
        return this.listener.okToClose(profile);
    }

    public void aboutToClose(ConnectionProfile profile) {
        this.execute((Runnable)((Object)new AboutToCloseRunnable(profile)));
    }

    void aboutToClose_(ConnectionProfile profile) {
        this.listener.aboutToClose(profile);
    }

    public void closed(ConnectionProfile profile) {
        this.execute((Runnable)((Object)new ClosedRunnable(profile)));
    }

    void closed_(ConnectionProfile profile) {
        this.listener.closed(profile);
    }

    public void databaseChanged(ConnectionProfile profile, Database database) {
        this.execute((Runnable)((Object)new DatabaseChangedRunnable(profile, database)));
    }

    void databaseChanged_(ConnectionProfile profile, Database database) {
        this.listener.databaseChanged(profile, database);
    }

    public void catalogChanged(ConnectionProfile profile, Catalog catalog) {
        this.execute((Runnable)((Object)new CatalogChangedRunnable(profile, catalog)));
    }

    void catalogChanged_(ConnectionProfile profile, Catalog catalog) {
        this.listener.catalogChanged(profile, catalog);
    }

    public void schemaChanged(ConnectionProfile profile, Schema schema) {
        this.execute((Runnable)((Object)new SchemaChangedRunnable(profile, schema)));
    }

    void schemaChanged_(ConnectionProfile profile, Schema schema) {
        this.listener.schemaChanged(profile, schema);
    }

    public void sequenceChanged(ConnectionProfile profile, Sequence sequence) {
        this.execute((Runnable)((Object)new SequenceChangedRunnable(profile, sequence)));
    }

    void sequenceChanged_(ConnectionProfile profile, Sequence sequence) {
        this.listener.sequenceChanged(profile, sequence);
    }

    public void tableChanged(ConnectionProfile profile, Table table) {
        this.execute((Runnable)((Object)new TableChangedRunnable(profile, table)));
    }

    void tableChanged_(ConnectionProfile profile, Table table) {
        this.listener.tableChanged(profile, table);
    }

    public void columnChanged(ConnectionProfile profile, Column column) {
        this.execute((Runnable)((Object)new ColumnChangedRunnable(profile, column)));
    }

    void columnChanged_(ConnectionProfile profile, Column column) {
        this.listener.columnChanged(profile, column);
    }

    public void foreignKeyChanged(ConnectionProfile profile, ForeignKey foreignKey) {
        this.execute((Runnable)((Object)new ForeignKeyChangedRunnable(profile, foreignKey)));
    }

    void foreignKeyChanged_(ConnectionProfile profile, ForeignKey foreignKey) {
        this.listener.foreignKeyChanged(profile, foreignKey);
    }

    private void execute(Runnable r) {
        DisplayTools.asyncExec((Runnable)r);
    }

    public String toString() {
        return "SWT[" + this.listener + ']';
    }

    class AboutToCloseRunnable
    extends RunnableAdapter {
        private final ConnectionProfile profile;

        AboutToCloseRunnable(ConnectionProfile profile) {
            this.profile = profile;
        }

        public void run() {
            SWTConnectionListenerWrapper.this.aboutToClose_(this.profile);
        }
    }

    class CatalogChangedRunnable
    extends RunnableAdapter {
        private final ConnectionProfile profile;
        private final Catalog catalog;

        CatalogChangedRunnable(ConnectionProfile profile, Catalog catalog) {
            this.profile = profile;
            this.catalog = catalog;
        }

        public void run() {
            SWTConnectionListenerWrapper.this.catalogChanged_(this.profile, this.catalog);
        }
    }

    class ClosedRunnable
    extends RunnableAdapter {
        private final ConnectionProfile profile;

        ClosedRunnable(ConnectionProfile profile) {
            this.profile = profile;
        }

        public void run() {
            SWTConnectionListenerWrapper.this.closed_(this.profile);
        }
    }

    class ColumnChangedRunnable
    extends RunnableAdapter {
        private final ConnectionProfile profile;
        private final Column column;

        ColumnChangedRunnable(ConnectionProfile profile, Column column) {
            this.profile = profile;
            this.column = column;
        }

        public void run() {
            SWTConnectionListenerWrapper.this.columnChanged_(this.profile, this.column);
        }
    }

    class DatabaseChangedRunnable
    extends RunnableAdapter {
        private final ConnectionProfile profile;
        private final Database database;

        DatabaseChangedRunnable(ConnectionProfile profile, Database database) {
            this.profile = profile;
            this.database = database;
        }

        public void run() {
            SWTConnectionListenerWrapper.this.databaseChanged_(this.profile, this.database);
        }
    }

    class ForeignKeyChangedRunnable
    extends RunnableAdapter {
        private final ConnectionProfile profile;
        private final ForeignKey foreignKey;

        ForeignKeyChangedRunnable(ConnectionProfile profile, ForeignKey foreignKey) {
            this.profile = profile;
            this.foreignKey = foreignKey;
        }

        public void run() {
            SWTConnectionListenerWrapper.this.foreignKeyChanged_(this.profile, this.foreignKey);
        }
    }

    class ModifiedRunnable
    extends RunnableAdapter {
        private final ConnectionProfile profile;

        ModifiedRunnable(ConnectionProfile profile) {
            this.profile = profile;
        }

        public void run() {
            SWTConnectionListenerWrapper.this.modified_(this.profile);
        }
    }

    class OkToCloseRunnable
    extends RunnableAdapter {
        private final ConnectionProfile profile;
        volatile boolean result = true;

        OkToCloseRunnable(ConnectionProfile profile) {
            this.profile = profile;
        }

        public void run() {
            SWTConnectionListenerWrapper.this.okToClose_(this.profile);
        }
    }

    class OpenedRunnable
    extends RunnableAdapter {
        private final ConnectionProfile profile;

        OpenedRunnable(ConnectionProfile profile) {
            this.profile = profile;
        }

        public void run() {
            SWTConnectionListenerWrapper.this.opened_(this.profile);
        }
    }

    class SchemaChangedRunnable
    extends RunnableAdapter {
        private final ConnectionProfile profile;
        private final Schema schema;

        SchemaChangedRunnable(ConnectionProfile profile, Schema schema) {
            this.profile = profile;
            this.schema = schema;
        }

        public void run() {
            SWTConnectionListenerWrapper.this.schemaChanged_(this.profile, this.schema);
        }
    }

    class SequenceChangedRunnable
    extends RunnableAdapter {
        private final ConnectionProfile profile;
        private final Sequence sequence;

        SequenceChangedRunnable(ConnectionProfile profile, Sequence sequence) {
            this.profile = profile;
            this.sequence = sequence;
        }

        public void run() {
            SWTConnectionListenerWrapper.this.sequenceChanged_(this.profile, this.sequence);
        }
    }

    class TableChangedRunnable
    extends RunnableAdapter {
        private final ConnectionProfile profile;
        private final Table table;

        TableChangedRunnable(ConnectionProfile profile, Table table) {
            this.profile = profile;
            this.table = table;
        }

        public void run() {
            SWTConnectionListenerWrapper.this.tableChanged_(this.profile, this.table);
        }
    }
}

