/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.js.handlers;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.wst.jsdt.chromium.debug.js.JSDebuggerPlugin;
import org.eclipse.wst.jsdt.chromium.debug.js.Messages;
import org.eclipse.wst.jsdt.chromium.debug.js.util.ChromiumUtil;
import org.eclipse.wst.jsdt.chromium.debug.js.util.ExceptionUtil;
import org.eclipse.wst.jsdt.chromium.debug.js.util.WorbenchResourceUtil;

public class ChromiumHandler
extends AbstractHandler {
    private static final String WEBAPP = "webapp";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            String url = ChromiumUtil.guessUrl();
            IProject project = ChromiumUtil.guessProject();
            if (url == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.js", Messages.ERROR_UNABLE_TO_DETECT_LAUNCH_URL));
            }
            if (project == null || !project.isAccessible()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.js", Messages.ERROR_UNABLE_TO_DETECT_DEBUGGING_PROJECT));
            }
            String projectName = project.getName();
            IFolder webapp = WorbenchResourceUtil.findFolder((IContainer)project, WEBAPP);
            if (webapp == null || !webapp.isAccessible()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.js", Messages.ERROR_UNABLE_TO_DETECT_WEBAPP_FOLDER));
            }
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.wst.jsdt.js.chromium.ChromiumLaunchConfigurationType");
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance((IContainer)project, projectName);
            workingCopy.setAttribute("attr_app_project", projectName);
            workingCopy.setAttribute("attr_app_project_relative_path", webapp.getProjectRelativePath().toOSString());
            workingCopy.setAttribute("attr_chromium_url", url);
            workingCopy.setAttribute("attr_base_url", url);
            workingCopy.setAttribute("debug_port", String.valueOf(ChromiumUtil.getRandomOpenPort()));
            DebugUITools.launch((ILaunchConfiguration)workingCopy, (String)"debug");
        }
        catch (IOException | CoreException e) {
            JSDebuggerPlugin.logError(e, e.getMessage());
            ExceptionUtil.showErrorDialog((Exception)e);
        }
        return null;
    }
}

