/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.text;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.wst.json.ui.internal.JSONUIPlugin;
import org.eclipse.wst.sse.ui.typing.AbstractCharacterPairInserter;

public class JSONCharacterPairInserter
extends AbstractCharacterPairInserter
implements IPropertyChangeListener {
    private boolean fCloseStrings;
    private boolean fCloseBrackets;
    private boolean fCloseBraces;

    public boolean hasPair(char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '[': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    public void initialize() {
        IPreferenceStore store = JSONUIPlugin.getDefault().getPreferenceStore();
        this.fCloseStrings = store.getBoolean("closeStrings");
        this.fCloseBraces = store.getBoolean("closeBraces");
        this.fCloseBrackets = store.getBoolean("closeBrackets");
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected char getPair(char c) {
        switch (c) {
            case '\"': 
            case '\'': {
                return c;
            }
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
        }
        throw new IllegalArgumentException();
    }

    protected LinkedModeUI.IExitPolicy getExitPolicy(char exit, char escape, IDocument document) {
        return new ExitPolicy(exit, escape, document);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("closeBrackets".equals(event.getProperty())) {
            this.fCloseBrackets = (Boolean)event.getNewValue();
        } else if ("closeBraces".equals(event.getProperty())) {
            this.fCloseBraces = (Boolean)event.getNewValue();
        } else if ("closeStrings".equals(event.getProperty())) {
            this.fCloseStrings = (Boolean)event.getNewValue();
        }
    }

    protected boolean shouldPair(ISourceViewer viewer, char c) {
        switch (c) {
            case '\"': 
            case '\'': {
                return this.fCloseStrings;
            }
            case '(': 
            case '[': {
                return this.fCloseBrackets;
            }
            case '{': {
                return this.fCloseBraces;
            }
        }
        return false;
    }

    class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private char fExit;
        private char fEscape;
        private IDocument fDocument;

        public ExitPolicy(char exit, char escape, IDocument document) {
            this.fExit = exit;
            this.fEscape = escape;
            this.fDocument = document;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (!this.isMasked(offset)) {
                if (event.character == this.fExit) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                if (event.character == '\r' || event.character == '\n' && offset > 0) {
                    try {
                        if (this.fDocument.getChar(offset - 1) == '{') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            try {
                return this.fEscape == this.fDocument.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }
}

