/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.client;

import com.ibm.wsdl.util.xml.DOM2Writer;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import org.apache.wsil.Description;
import org.apache.wsil.Link;
import org.apache.wsil.QName;
import org.apache.wsil.Service;
import org.apache.wsil.ServiceName;
import org.apache.wsil.WSILDocument;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.extension.uddi.BusinessDescription;
import org.apache.wsil.extension.uddi.ServiceDescription;
import org.apache.wsil.extension.wsdl.ImplementedBinding;
import org.apache.wsil.extension.wsdl.Reference;
import org.apache.wsil.util.Util;
import org.apache.wsil.util.WSDLDocument;
import org.apache.wsil.util.WSILDocBuilder;
import org.apache.wsil.util.WSILProperties;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.ServiceKey;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSILProxy {
    private WSILDocument wsilDocument = null;
    private Vector wsilDocVector = new Vector();

    public WSILProxy() throws WSILException {
        String string = Util.formatURL(WSILProperties.WSIL_HOSTNAME, WSILProperties.WSIL_PORT, WSILProperties.WSIL_DOCUMENT_NAME);
        this.init(string);
    }

    public WSILProxy(String string) throws WSILException {
        this.init(string);
    }

    public WSILProxy(Element element) throws WSILException {
        try {
            StringWriter stringWriter = new StringWriter();
            DOM2Writer.serializeAsXML((Node)element, (Writer)stringWriter);
            StringReader stringReader = new StringReader(stringWriter.toString());
            this.wsilDocument = WSILDocument.newInstance();
            this.wsilDocument.read(stringReader);
            this.wsilDocVector.add(this.wsilDocument);
        }
        catch (Exception exception) {
            throw new WSILException("Invalid inspection element", exception);
        }
    }

    private void init(String string) throws WSILException {
        this.wsilDocument = WSILDocument.newInstance();
        try {
            URL uRL = new URL(string);
            this.wsilDocument.read(uRL);
            this.wsilDocVector.add(this.wsilDocument);
        }
        catch (MalformedURLException malformedURLException) {
            throw new WSILException("Invalid inspection.wsil document URL", malformedURLException);
        }
    }

    public WSILDocument getWSILDocument() {
        return this.wsilDocument;
    }

    public WSDLDocument[] getWSDLDocumentByServiceName(String string) throws WSILException {
        WSDLDocument[] wSDLDocumentArray = null;
        String[] stringArray = this.getWSDLDocumentLocations(string);
        if (stringArray != null) {
            wSDLDocumentArray = new WSDLDocument[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                wSDLDocumentArray[i] = this.readWSDLDocument(stringArray[i]);
            }
        }
        return wSDLDocumentArray;
    }

    public WSDLDocument[] getWSDLDocumentByName(String string) throws WSILException {
        Object[] objectArray = null;
        Vector<WSDLDocument> vector = new Vector<WSDLDocument>();
        this.handleLinks(this.wsilDocument);
        for (int i = 0; i < this.wsilDocVector.size(); ++i) {
            WSILDocument wSILDocument = (WSILDocument)this.wsilDocVector.elementAt(i);
            Service[] serviceArray = wSILDocument.getInspection().getServices();
            String string2 = null;
            for (int j = 0; j < serviceArray.length; ++j) {
                Description[] descriptionArray = serviceArray[j].getDescriptions();
                for (int k = 0; k < descriptionArray.length; ++k) {
                    string2 = descriptionArray[k].getLocation();
                    if (string2 == null || string2.indexOf(string) == -1) continue;
                    vector.add(this.readWSDLDocument(wSILDocument.resolveURL(string2)));
                }
            }
        }
        if (vector.size() != 0) {
            objectArray = new WSDLDocument[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public WSDLDocument[] getWSDLDocumentByBinding(QName qName) throws WSILException {
        Object[] objectArray = null;
        Vector<WSDLDocument> vector = new Vector<WSDLDocument>();
        this.handleLinks(this.wsilDocument);
        for (int i = 0; i < this.wsilDocVector.size(); ++i) {
            WSILDocument wSILDocument = (WSILDocument)this.wsilDocVector.elementAt(i);
            Service[] serviceArray = wSILDocument.getInspection().getServices();
            Object var7_7 = null;
            for (int j = 0; j < serviceArray.length; ++j) {
                Description[] descriptionArray = serviceArray[j].getDescriptions();
                for (int k = 0; k < descriptionArray.length; ++k) {
                    Reference reference = (Reference)descriptionArray[k].getExtensionElement();
                    if (reference == null) continue;
                    ImplementedBinding[] implementedBindingArray = reference.getImplementedBindings();
                    for (int i2 = 0; i2 < implementedBindingArray.length; ++i2) {
                        QName qName2 = implementedBindingArray[i2].getBindingName();
                        if (!qName2.equals(qName)) continue;
                        vector.add(this.readWSDLDocument(wSILDocument.resolveURL(descriptionArray[k].getLocation())));
                    }
                }
            }
        }
        if (vector.size() != 0) {
            objectArray = new WSDLDocument[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public WSDLDocument[] getWSDLDocumentByPortType(QName qName) throws WSILException {
        Object[] objectArray = null;
        Vector<WSDLDocument> vector = new Vector<WSDLDocument>();
        this.handleLinks(this.wsilDocument);
        for (int i = 0; i < this.wsilDocVector.size(); ++i) {
            WSILDocument wSILDocument = (WSILDocument)this.wsilDocVector.elementAt(i);
            Service[] serviceArray = wSILDocument.getInspection().getServices();
            Object var7_7 = null;
            for (int j = 0; j < serviceArray.length; ++j) {
                Description[] descriptionArray = serviceArray[j].getDescriptions();
                for (int k = 0; k < descriptionArray.length; ++k) {
                    Description description = descriptionArray[k];
                    Reference reference = (Reference)description.getExtensionElement();
                    if (reference == null) continue;
                    ImplementedBinding[] implementedBindingArray = reference.getImplementedBindings();
                    WSDLDocument wSDLDocument = null;
                    try {
                        wSDLDocument = this.readWSDLDocument(wSILDocument.resolveURL(description.getLocation()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (wSDLDocument == null) continue;
                    for (int i2 = 0; i2 < implementedBindingArray.length; ++i2) {
                        PortType portType;
                        if (vector.contains(wSDLDocument)) continue;
                        QName qName2 = implementedBindingArray[i2].getBindingName();
                        javax.xml.namespace.QName qName3 = new javax.xml.namespace.QName(qName2.getNamespaceURI(), qName2.getLocalName());
                        Binding binding = wSDLDocument.getDefinitions().getBinding(qName3);
                        if (binding == null || (portType = binding.getPortType()) == null || !portType.getQName().getLocalPart().equals(qName.getLocalName()) || !portType.getQName().getNamespaceURI().equals(qName.getNamespaceURI())) continue;
                        vector.add(wSDLDocument);
                    }
                }
            }
        }
        if (vector.size() != 0) {
            objectArray = new WSDLDocument[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public BusinessService[] getBusinessServiceByServiceName(String string) throws WSILException {
        Vector<BusinessService> vector = new Vector<BusinessService>();
        Object[] objectArray = null;
        this.handleLinks(this.wsilDocument);
        for (int i = 0; i < this.wsilDocVector.size(); ++i) {
            WSILDocument wSILDocument = (WSILDocument)this.wsilDocVector.elementAt(i);
            Service[] serviceArray = wSILDocument.getInspection().getServices();
            for (int j = 0; j < serviceArray.length; ++j) {
                if (!serviceArray[j].getServiceNames()[0].getText().equals(string)) continue;
                Description[] descriptionArray = serviceArray[j].getDescriptions();
                for (int k = 0; k < descriptionArray.length; ++k) {
                    ServiceDescription serviceDescription = (ServiceDescription)descriptionArray[k].getExtensionElement();
                    if (serviceDescription == null) continue;
                    String string2 = serviceDescription.getLocation();
                    ServiceKey serviceKey = serviceDescription.getServiceKey();
                    try {
                        Properties properties = new Properties();
                        properties.setProperty("org.uddi4j.TransportClassName", WSILProperties.TRANSPORT_CLASS);
                        properties.setProperty("org.uddi4j.inquiryURL", new URL(string2).toString());
                        UDDIProxy uDDIProxy = new UDDIProxy(properties);
                        ServiceDetail serviceDetail = uDDIProxy.get_serviceDetail(serviceKey.getText());
                        Vector vector2 = serviceDetail.getBusinessServiceVector();
                        if (vector2.size() <= 0) continue;
                        BusinessService businessService = (BusinessService)vector2.firstElement();
                        vector.add(businessService);
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new WSILException("Problems connecting to registry", malformedURLException);
                    }
                    catch (UDDIException uDDIException) {
                        throw new WSILException("Unable to find service " + string, uDDIException);
                    }
                    catch (TransportException transportException) {
                        throw new WSILException("SOAP transport problems", transportException);
                    }
                }
            }
        }
        if (vector.size() != 0) {
            objectArray = new BusinessService[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public void print(OutputStream outputStream) throws WSILException {
        this.wsilDocument.write(new PrintWriter(outputStream));
    }

    public String[] getWSDLDocumentLocations(String string) throws WSILException {
        Object[] objectArray = null;
        Vector<String> vector = new Vector<String>();
        this.handleLinks(this.wsilDocument);
        for (int i = 0; i < this.wsilDocVector.size(); ++i) {
            WSILDocument wSILDocument = (WSILDocument)this.wsilDocVector.elementAt(i);
            Service[] serviceArray = wSILDocument.getInspection().getServices();
            for (int j = 0; j < serviceArray.length; ++j) {
                ServiceName[] serviceNameArray = serviceArray[j].getServiceNames();
                for (int k = 0; k < serviceNameArray.length; ++k) {
                    if (!serviceNameArray[k].getText().equals(string)) continue;
                    Description[] descriptionArray = serviceArray[j].getDescriptions();
                    String string2 = null;
                    for (int i2 = 0; i2 < descriptionArray.length; ++i2) {
                        String string3 = descriptionArray[i2].getLocation();
                        if (string2 != null && string2.equals(string3) || !descriptionArray[i2].getReferencedNamespace().equals("http://schemas.xmlsoap.org/wsdl/")) continue;
                        string2 = string3;
                        vector.add(wSILDocument.resolveURL(string3));
                    }
                }
            }
        }
        if (vector.size() != 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    private WSDLDocument readWSDLDocument(String string) throws WSILException {
        WSDLDocument wSDLDocument = null;
        try {
            wSDLDocument = new WSDLDocument(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new WSILException("Invalid WSDL document URL", malformedURLException);
        }
        catch (WSDLException wSDLException) {
            throw new WSILException("Problems creating WSDL document", wSDLException);
        }
        return wSDLDocument;
    }

    private void handleLinks(WSILDocument wSILDocument) throws WSILException {
        Link[] linkArray = wSILDocument.getInspection().getLinks();
        for (int i = 0; i < linkArray.length; ++i) {
            Object object;
            Object object2;
            String string = linkArray[i].getReferencedNamespace();
            String string2 = wSILDocument.resolveURL(linkArray[i].getLocation());
            ExtensionElement extensionElement = linkArray[i].getExtensionElement();
            if (string.equals("http://schemas.xmlsoap.org/ws/2001/10/inspection/")) {
                object2 = WSILDocument.newInstance();
                try {
                    object = new URL(string2);
                    ((WSILDocument)object2).read((URL)object);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new WSILException("Invalid wsil document URL", malformedURLException);
                }
                this.wsilDocVector.add(object2);
                this.handleLinks((WSILDocument)object2);
                continue;
            }
            if (string.equals("urn:uddi-org:api") || string.equals("urn:uddi-org:api_v2")) {
                object2 = (BusinessDescription)linkArray[i].getExtensionElement();
                if (object2 == null) continue;
                object = object2.getLocation();
                String string3 = object2.getBusinessKey().getText();
                try {
                    WSILDocBuilder wSILDocBuilder = new WSILDocBuilder(new URL((String)object), string3);
                    this.wsilDocVector.add(wSILDocBuilder.getWSILDocument());
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new WSILException("Problems creating WSIL document", malformedURLException);
                }
            }
            throw new WSILException("Invalid wsil link namespace: " + string);
        }
    }

    public static void main(String[] stringArray) {
        Vector vector = new Vector();
        try {
            if (stringArray.length > 0 && stringArray[0].equals("-?")) {
                throw new IllegalArgumentException("Usage: WSILProxy <wsinspectionURL>");
            }
            WSILProxy wSILProxy = stringArray.length == 0 ? new WSILProxy() : new WSILProxy(stringArray[0]);
            System.out.println(wSILProxy.getWSILDocument().toString());
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: " + exception.getMessage());
            exception.printStackTrace();
        }
        System.exit(0);
    }
}

