/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.stack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.collection.MapTools;
import org.eclipse.jpt.common.utility.internal.stack.ArrayStack;
import org.eclipse.jpt.common.utility.internal.stack.DequeStack;
import org.eclipse.jpt.common.utility.internal.stack.EmptyStack;
import org.eclipse.jpt.common.utility.internal.stack.FixedCapacityArrayStack;
import org.eclipse.jpt.common.utility.internal.stack.LinkedStack;
import org.eclipse.jpt.common.utility.internal.stack.ListStack;
import org.eclipse.jpt.common.utility.internal.stack.SynchronizedStack;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class StackTools {
    public static <E> boolean pushAll(Stack<? super E> stack, Iterable<? extends E> iterable) {
        return StackTools.pushAll(stack, iterable.iterator());
    }

    public static <E> boolean pushAll(Stack<? super E> stack, Iterator<? extends E> iterator) {
        return iterator.hasNext() && StackTools.pushAll_(stack, iterator);
    }

    private static <E> boolean pushAll_(Stack<? super E> stack, Iterator<? extends E> iterator) {
        do {
            stack.push(iterator.next());
        } while (iterator.hasNext());
        return true;
    }

    public static <E> boolean pushAll(Stack<? super E> stack, E ... array) {
        int len = array.length;
        return len != 0 && StackTools.pushAll_(stack, array, len);
    }

    private static <E> boolean pushAll_(Stack<? super E> stack, E[] array, int arrayLength) {
        int i = 0;
        do {
            stack.push(array[i++]);
        } while (i < arrayLength);
        return true;
    }

    public static <E> ArrayList<E> popAll(Stack<? extends E> stack) {
        ArrayList result = new ArrayList();
        StackTools.popAllTo(stack, result);
        return result;
    }

    public static <E> boolean popAllTo(Stack<? extends E> stack, Collection<? super E> collection) {
        return !stack.isEmpty() && StackTools.popAllTo_(stack, collection);
    }

    private static <E> boolean popAllTo_(Stack<? extends E> stack, Collection<? super E> collection) {
        do {
            collection.add(stack.pop());
        } while (!stack.isEmpty());
        return true;
    }

    public static <E> boolean popAllTo(Stack<? extends E> stack, List<? super E> list, int index) {
        return !stack.isEmpty() && StackTools.popAllTo_(stack, list, index);
    }

    private static <E> boolean popAllTo_(Stack<? extends E> stack, List<? super E> list, int index) {
        return index == list.size() ? StackTools.popAllTo_(stack, list) : list.addAll(index, StackTools.popAll(stack));
    }

    public static <E> boolean popAllTo(Stack<? extends E> stack, Queue<? super E> queue) {
        return !stack.isEmpty() && StackTools.popAllTo_(stack, queue);
    }

    private static <E> boolean popAllTo_(Stack<? extends E> stack, Queue<? super E> queue) {
        do {
            queue.enqueue(stack.pop());
        } while (!stack.isEmpty());
        return true;
    }

    public static <E> boolean popAllTo(Stack<? extends E> stack1, Stack<? super E> stack2) {
        return !stack1.isEmpty() && StackTools.popAllTo_(stack1, stack2);
    }

    private static <E> boolean popAllTo_(Stack<? extends E> stack1, Stack<? super E> stack2) {
        do {
            stack2.push(stack1.pop());
        } while (!stack1.isEmpty());
        return true;
    }

    public static <K, V> boolean popAllTo(Stack<? extends V> stack, Map<K, V> map, Transformer<? super V, ? extends K> keyTransformer) {
        return !stack.isEmpty() && StackTools.popAllTo_(stack, map, keyTransformer);
    }

    private static <K, V, E extends V> boolean popAllTo_(Stack<E> stack, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer) {
        do {
            MapTools.add(map, stack.pop(), keyTransformer);
        } while (!stack.isEmpty());
        return true;
    }

    public static <K, V, E> boolean popAllTo(Stack<E> stack, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        return !stack.isEmpty() && StackTools.popAllTo_(stack, map, keyTransformer, valueTransformer);
    }

    private static <K, V, E> boolean popAllTo_(Stack<E> stack, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        do {
            MapTools.add(map, stack.pop(), keyTransformer, valueTransformer);
        } while (!stack.isEmpty());
        return true;
    }

    public static <E> ArrayStack<E> arrayStack() {
        return StackTools.arrayStack(10);
    }

    public static <E> ArrayStack<E> arrayStack(int initialCapacity) {
        return new ArrayStack(initialCapacity);
    }

    public static <E> ArrayStack<E> arrayStack(Iterable<? extends E> iterable) {
        return StackTools.arrayStack(iterable.iterator());
    }

    public static <E> ArrayStack<E> arrayStack(Iterable<? extends E> iterable, int iterableSize) {
        return StackTools.arrayStack(iterable.iterator(), iterableSize);
    }

    public static <E> ArrayStack<E> arrayStack(Iterator<? extends E> iterator) {
        ArrayStack<E> result = StackTools.arrayStack();
        StackTools.pushAll(result, iterator);
        return result;
    }

    public static <E> ArrayStack<E> arrayStack(Iterator<? extends E> iterator, int iteratorSize) {
        ArrayStack<E> result = StackTools.arrayStack(iteratorSize);
        StackTools.pushAll(result, iterator);
        return result;
    }

    public static <E> ArrayStack<E> arrayStack(E ... array) {
        ArrayStack<E> result = StackTools.arrayStack(array.length);
        StackTools.pushAll(result, array);
        return result;
    }

    public static <E> LinkedStack<E> linkedStack() {
        return StackTools.linkedStack(0);
    }

    public static <E> LinkedStack<E> linkedStack(int cacheSize) {
        return new LinkedStack(cacheSize);
    }

    public static <E> LinkedStack<E> linkedStack(Iterable<? extends E> iterable) {
        return StackTools.linkedStack(iterable.iterator());
    }

    public static <E> LinkedStack<E> linkedStack(Iterable<? extends E> iterable, int cacheSize) {
        return StackTools.linkedStack(iterable.iterator(), cacheSize);
    }

    public static <E> LinkedStack<E> linkedStack(Iterator<? extends E> iterator) {
        LinkedStack<E> result = StackTools.linkedStack();
        StackTools.pushAll(result, iterator);
        return result;
    }

    public static <E> LinkedStack<E> linkedStack(Iterator<? extends E> iterator, int cacheSize) {
        LinkedStack<E> result = StackTools.linkedStack(cacheSize);
        StackTools.pushAll(result, iterator);
        return result;
    }

    public static <E> LinkedStack<E> linkedStack(E ... array) {
        LinkedStack<E> result = StackTools.linkedStack();
        StackTools.pushAll(result, array);
        return result;
    }

    public static <E> LinkedStack<E> linkedStack(E[] array, int cacheSize) {
        LinkedStack<E> result = StackTools.linkedStack(cacheSize);
        StackTools.pushAll(result, array);
        return result;
    }

    public static <E> FixedCapacityArrayStack<E> fixedCapacityArrayStack(int capacity) {
        return new FixedCapacityArrayStack(capacity);
    }

    public static <E> FixedCapacityArrayStack<E> fixedCapacityArrayStack(Collection<? extends E> collection) {
        FixedCapacityArrayStack<E> result = StackTools.fixedCapacityArrayStack(collection.size());
        StackTools.pushAll(result, collection);
        return result;
    }

    public static <E> SynchronizedStack<E> synchronizedStack() {
        ArrayStack<E> stack = StackTools.arrayStack();
        return StackTools.synchronizedStack(stack);
    }

    public static <E> SynchronizedStack<E> synchronizedStack(Object mutex) {
        LinkedStack<E> stack = StackTools.linkedStack();
        return StackTools.synchronizedStack(stack, mutex);
    }

    public static <E> SynchronizedStack<E> synchronizedStack(Stack<E> stack) {
        return new SynchronizedStack<E>(stack);
    }

    public static <E> SynchronizedStack<E> synchronizedStack(Stack<E> stack, Object mutex) {
        return new SynchronizedStack<E>(stack, mutex);
    }

    public static <E> ListStack<E> adapt(List<E> list) {
        return new ListStack<E>(list);
    }

    public static <E> DequeStack<E> adapt(Deque<E> deque) {
        return new DequeStack<E>(deque);
    }

    public static <E> Stack<E> emptyStack() {
        return EmptyStack.instance();
    }

    private StackTools() {
        throw new UnsupportedOperationException();
    }
}

