/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.internal.actions.OpenJ2EEResourceAction;
import org.eclipse.jst.j2ee.internal.webservice.OpenExternalWSDLAction;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceUIResourceHandler;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceExtManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceHelper;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class WebServicesNavigatorGroupOpenListener
extends CommonActionProvider {
    private OpenExternalWSDLAction openExternalWSDLAction;
    private OpenJ2EEResourceAction openAction;

    public void init(ICommonActionExtensionSite aConfig) {
        this.openExternalWSDLAction = new OpenExternalWSDLAction(WebServiceUIResourceHandler.WebServiceGroupContentExtension_UI_1);
        this.openAction = new OpenJ2EEResourceAction();
    }

    public void setContext(ActionContext aContext) {
        if (aContext != null && aContext.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)aContext.getSelection();
            WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
            if (selection == null || selection.getFirstElement() == null) {
                return;
            }
            Object selectedObject = selection.getFirstElement();
            if (serviceHelper == null) {
                return;
            }
            if (serviceHelper.isService(selectedObject)) {
                WsddResource resource = WebServicesManager.getInstance().getWsddResource((EObject)selectedObject);
                if (resource == null) {
                    this.openExternalWSDLAction.selectionChanged(selection);
                    super.setContext(aContext);
                    return;
                }
                ArrayList<WsddResource> wsddSelection = new ArrayList<WsddResource>();
                wsddSelection.add(resource);
                this.openAction.selectionChanged((IStructuredSelection)new StructuredSelection(wsddSelection));
            } else if (serviceHelper.isWSDLResource(selectedObject)) {
                Resource wsdl = (Resource)selectedObject;
                IFile wsdlFile = WorkbenchResourceHelper.getFile((Resource)wsdl);
                if (wsdlFile == null || !wsdlFile.exists()) {
                    this.openExternalWSDLAction.selectionChanged(selection);
                    super.setContext(aContext);
                    return;
                }
                this.openAction.selectionChanged(selection);
            } else {
                this.openAction.selectionChanged(selection);
            }
        }
        super.setContext(aContext);
    }

    public void fillActionBars(IActionBars theActionBars) {
        IFile wsdlFile;
        if (this.getContext() == null || this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        Object first = selection.getFirstElement();
        WSDLServiceHelper helper = WSDLServiceExtManager.getServiceHelper();
        if (helper != null && helper.isService(first)) {
            WsddResource resource = WebServicesManager.getInstance().getWsddResource((EObject)first);
            if (resource == null) {
                IFile wsdlFile2 = WorkbenchResourceHelper.getFile((EObject)((EObject)first));
                if (wsdlFile2 == null || !wsdlFile2.exists()) {
                    this.openExternalWSDLAction.selectionChanged(selection);
                    theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openExternalWSDLAction);
                    return;
                }
                this.openAction.selectionChanged(selection);
                theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
                return;
            }
            ArrayList<WsddResource> wsddSelection = new ArrayList<WsddResource>();
            wsddSelection.add(resource);
            this.openAction.selectionChanged((IStructuredSelection)new StructuredSelection(wsddSelection));
            theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
            return;
        }
        if (helper != null && helper.isWSDLResource(first) && ((wsdlFile = WorkbenchResourceHelper.getFile((Resource)((Resource)first))) == null || !wsdlFile.exists())) {
            this.openExternalWSDLAction.selectionChanged(selection);
            theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openExternalWSDLAction);
            return;
        }
        this.openAction.selectionChanged(selection);
        if (this.openAction.isEnabled()) {
            theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        IFile wsdlFile;
        if (this.getContext() == null || this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        Object first = selection.getFirstElement();
        WSDLServiceHelper helper = WSDLServiceExtManager.getServiceHelper();
        if (helper != null && helper.isService(first)) {
            IFile wsdlFile2 = WorkbenchResourceHelper.getFile((EObject)((EObject)first));
            if (wsdlFile2 == null || !wsdlFile2.exists()) {
                this.openExternalWSDLAction.selectionChanged(selection);
                menu.insertAfter("group.open", (IAction)this.openExternalWSDLAction);
                return;
            }
        } else if (helper != null && helper.isWSDLResource(first) && ((wsdlFile = WorkbenchResourceHelper.getFile((Resource)((Resource)first))) == null || !wsdlFile.exists())) {
            this.openExternalWSDLAction.selectionChanged(selection);
            menu.insertAfter("group.open", (IAction)this.openExternalWSDLAction);
            return;
        }
        this.openAction.selectionChanged(selection);
        if (this.openAction.isEnabled()) {
            menu.insertAfter("group.open", (IAction)this.openAction);
        }
    }
}

