/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.tests.internal.swt.bindings;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jpt.common.ui.internal.swt.bindings.SWTBindingTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextFieldModelBindingUITest
extends ApplicationWindow {
    private final TestModel testModel = new TestModel("Scooby Doo");
    private static final String DEFAULT_NAME = "Scooby Doo";
    private final ModifiablePropertyValueModel<TestModel> testModelModel = new SimplePropertyValueModel((Object)this.testModel);
    private final ModifiablePropertyValueModel<String> nameModel = this.buildNameModel((PropertyValueModel<TestModel>)this.testModelModel);
    private final ModifiablePropertyValueModel<String> allCapsNameModel = this.buildAllCapsNameModel((PropertyValueModel<TestModel>)this.testModelModel);

    public static void main(String[] args) throws Exception {
        TextFieldModelBindingUITest window = new TextFieldModelBindingUITest();
        window.setBlockOnOpen(true);
        window.open();
        Display.getCurrent().dispose();
        System.exit(0);
    }

    private TextFieldModelBindingUITest() {
        super(null);
    }

    private ModifiablePropertyValueModel<String> buildNameModel(PropertyValueModel<TestModel> vm) {
        return new PropertyAspectAdapter<TestModel, String>(vm, new String[]{"name"}){

            protected String buildValue_() {
                return ((TestModel)((Object)this.subject)).name();
            }

            protected void setValue_(String value) {
                ((TestModel)((Object)this.subject)).setName(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildAllCapsNameModel(PropertyValueModel<TestModel> vm) {
        return new PropertyAspectAdapter<TestModel, String>(vm, new String[]{"name"}){

            protected String buildValue_() {
                return ((TestModel)((Object)this.subject)).name().toUpperCase();
            }

            protected void setValue_(String value) {
            }
        };
    }

    protected Control createContents(Composite parent) {
        ((Shell)parent).setText(((Object)((Object)this)).getClass().getSimpleName());
        parent.setSize(400, 100);
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new FormLayout());
        Control textFieldPanel = this.buildTextFieldPanel(mainPanel);
        this.buildControlPanel(mainPanel, textFieldPanel);
        return mainPanel;
    }

    private Control buildTextFieldPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.bottom = new FormAttachment(100, -35);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        panel.setLayoutData((Object)fd);
        panel.setLayout((Layout)new FillLayout());
        this.buildNameTextField(panel);
        this.buildReadOnlyNameTextField(panel);
        this.buildAllCapsNameTextField(panel);
        return panel;
    }

    private void buildNameTextField(Composite parent) {
        Text textField = new Text(parent, 4);
        SWTBindingTools.bind(this.nameModel, (Text)textField);
    }

    private void buildReadOnlyNameTextField(Composite parent) {
        Text textField = new Text(parent, 4);
        textField.setEnabled(false);
        SWTBindingTools.bind(this.nameModel, (Text)textField);
    }

    private void buildAllCapsNameTextField(Composite parent) {
        Text textField = new Text(parent, 4);
        textField.setEnabled(false);
        SWTBindingTools.bind(this.allCapsNameModel, (Text)textField);
    }

    private void buildControlPanel(Composite parent, Control checkBoxPanel) {
        Composite panel = new Composite(parent, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(checkBoxPanel);
        fd.bottom = new FormAttachment(100);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        panel.setLayoutData((Object)fd);
        panel.setLayout((Layout)new FillLayout());
        this.buildResetNameButton(panel);
        this.buildClearModelButton(panel);
        this.buildRestoreModelButton(panel);
        this.buildPrintModelButton(panel);
    }

    private void buildResetNameButton(Composite parent) {
        this.buildResetNameACI().fill(parent);
    }

    private ActionContributionItem buildResetNameACI() {
        Action action = new Action("reset name", 1){

            public void run() {
                TextFieldModelBindingUITest.this.resetName();
            }
        };
        action.setToolTipText("reset name");
        return new ActionContributionItem((IAction)action);
    }

    void resetName() {
        this.testModel.setName(DEFAULT_NAME);
    }

    private void buildClearModelButton(Composite parent) {
        this.buildClearModelACI().fill(parent);
    }

    private ActionContributionItem buildClearModelACI() {
        Action action = new Action("clear model", 1){

            public void run() {
                TextFieldModelBindingUITest.this.clearModel();
            }
        };
        action.setToolTipText("clear model");
        return new ActionContributionItem((IAction)action);
    }

    void clearModel() {
        this.testModelModel.setValue(null);
    }

    private void buildRestoreModelButton(Composite parent) {
        this.buildRestoreModelACI().fill(parent);
    }

    private ActionContributionItem buildRestoreModelACI() {
        Action action = new Action("restore model", 1){

            public void run() {
                TextFieldModelBindingUITest.this.restoreModel();
            }
        };
        action.setToolTipText("restore model");
        return new ActionContributionItem((IAction)action);
    }

    void restoreModel() {
        this.testModelModel.setValue((Object)this.testModel);
    }

    private void buildPrintModelButton(Composite parent) {
        this.buildPrintModelACI().fill(parent);
    }

    private ActionContributionItem buildPrintModelACI() {
        Action action = new Action("print model", 1){

            public void run() {
                TextFieldModelBindingUITest.this.printModel();
            }
        };
        action.setToolTipText("print model");
        return new ActionContributionItem((IAction)action);
    }

    void printModel() {
        System.out.println("name: " + this.testModel.name());
    }

    class TestModel
    extends AbstractModel {
        private String name;
        public static final String NAME_PROPERTY = "name";

        public TestModel(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public void setName(String name) {
            String old = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, old, name);
        }

        public String toString() {
            return "TestModel(" + this.name + ")";
        }
    }
}

