/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.relation;

import java.util.Properties;
import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.utility.internal.iterable.SubIterableWrapper;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationshipStrategy;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CreateRelationsTest {
    private IJPAEditorFeatureProvider featureProvider;
    final String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    IEclipseFacade eclipseFacade = null;
    private static final int MAX_NUM_OF_ITERATIONS = 250;
    PersistentType t1 = null;
    ICompilationUnit cu1 = null;
    PersistentType t2 = null;
    ICompilationUnit cu2 = null;
    private IJPAEditorFeatureProvider featureProvider20;
    private JpaProject jpa20Project;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        IFile entity = this.factory.createEntity(this.jpaProject, "org.eclipse.Entity1");
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement(null)).andReturn((Object)JPACreateFactory.getPersistentType(entity));
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit((PersistentType)EasyMock.isA(PersistentType.class))).andReturn((Object)JavaCore.createCompilationUnitFrom((IFile)entity)).anyTimes();
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        this.t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        EasyMock.expect((Object)this.featureProvider.getPictogramElementForBusinessObject((Object)this.t1)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        this.cu1 = JavaCore.createCompilationUnitFrom((IFile)customerFile);
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit(this.t1)).andStubReturn((Object)this.cu1);
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.Address");
        Assert.assertNotNull((Object)customerType);
        this.t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        EasyMock.expect((Object)this.featureProvider.getPictogramElementForBusinessObject((Object)this.t2)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        this.cu2 = JavaCore.createCompilationUnitFrom((IFile)addressFile);
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit(this.t2)).andStubReturn((Object)this.cu2);
        Properties props = new Properties();
        props.setProperty(JPADiagramPropertyPage.PROP_COLLECTION_TYPE.getLocalName(), "collection");
        EasyMock.expect((Object)this.featureProvider.loadProperties(this.jpaProject.getProject())).andStubReturn((Object)props);
        EasyMock.replay((Object[])new Object[]{this.featureProvider});
        this.jpa20Project = this.factory.createJPA20Project("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpa20Project);
        IFile entity20 = this.factory.createEntity(this.jpa20Project, "org.eclipse.Entity1");
        Thread.sleep(2000L);
        this.featureProvider20 = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider20.getBusinessObjectForPictogramElement(null)).andReturn((Object)JPACreateFactory.getPersistentType(entity20));
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit((PersistentType)EasyMock.isA(PersistentType.class))).andReturn((Object)JavaCore.createCompilationUnitFrom((IFile)entity20)).anyTimes();
    }

    public ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaCore.createCompilationUnitFrom((IFile)file);
    }

    @Test
    public void testCreateOneToOneUnidirRelation() throws Exception {
        OneToOneUniDirRelation rel = new OneToOneUniDirRelation(this.featureProvider, this.t1, this.t2, "address", true, false);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"oneToOne", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
    }

    @Test
    public void testCreateOneToOneBidirRelation() throws Exception {
        OneToOneBiDirRelation rel = new OneToOneBiDirRelation(this.featureProvider, this.t1, this.t2, "address", "customer", true, null, false);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"oneToOne", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
        PersistentAttribute inverseAt = this.t2.getAttributeNamed("customer");
        Assert.assertNotNull((Object)inverseAt);
        attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(inverseAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"manyToMany", (Object)attributeMapping.getKey());
        strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertEquals((Object)"address", (Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
    }

    @Test
    public void testCreateOneToManyUnidirRelation() throws Exception {
        OneToManyUniDirRelation rel = new OneToManyUniDirRelation(this.featureProvider, this.t1, this.t2, "address", true);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"oneToMany", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
    }

    @Test
    public void testCreateManyToOneUnidirRelation() throws Exception {
        ManyToOneUniDirRelation rel = new ManyToOneUniDirRelation(this.featureProvider, this.t1, this.t2, "address", true, false);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"manyToOne", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
    }

    @Test
    public void testCreateManyToOneBidirRelation() throws Exception {
        ManyToOneBiDirRelation rel = new ManyToOneBiDirRelation(this.featureProvider, this.t1, this.t2, "address", "customer", true, null, false);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"manyToOne", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
        Assert.assertEquals((Object)"customer", (Object)rel.getInverseAttributeName());
        PersistentAttribute inverseAt = this.t2.getAttributeNamed("customer");
        Assert.assertNotNull((Object)inverseAt);
        attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(inverseAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"oneToMany", (Object)attributeMapping.getKey());
        strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertEquals((Object)"address", (Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
    }

    @Test
    public void testCreateManyToManyUnidirRelation() throws Exception {
        ManyToManyUniDirRelation rel = new ManyToManyUniDirRelation(this.featureProvider, this.t1, this.t2, "address", true);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"manyToMany", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
    }

    @Test
    public void testCreateManyToManyBidirRelation() throws Exception {
        ManyToManyBiDirRelation rel = new ManyToManyBiDirRelation(this.featureProvider, this.t1, this.t2, "address", "customer", true, null);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)this.t1, (Object)rel.getOwner());
        Assert.assertSame((Object)this.t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = this.t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ownerAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"manyToMany", (Object)attributeMapping.getKey());
        SpecifiedRelationshipStrategy strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertNull((Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
        PersistentAttribute inverseAt = this.t2.getAttributeNamed("customer");
        Assert.assertNotNull((Object)inverseAt);
        attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(inverseAt);
        Assert.assertTrue((boolean)RelationshipMapping.class.isInstance(attributeMapping));
        Assert.assertEquals((Object)"manyToMany", (Object)attributeMapping.getKey());
        strategy = ((RelationshipMapping)attributeMapping).getRelationship().getStrategy();
        Assert.assertTrue((boolean)SpecifiedMappedByRelationshipStrategy.class.isInstance(strategy));
        Assert.assertEquals((Object)"address", (Object)((SpecifiedMappedByRelationshipStrategy)strategy).getMappedByAttribute());
    }

    @Test
    public void testCreateOneToManyUnidirRelation20() throws Exception {
        Assert.assertNotNull((Object)this.jpa20Project);
        IFile customerFile = this.factory.createEntityInProject(this.jpa20Project.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createEntityInProject(this.jpa20Project.getProject(), new String[]{"com"}, "Address");
        this.jpa20Project.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpa20Project.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, customerType.getTypeBinding().getQualifiedName());
        EasyMock.expect((Object)this.featureProvider20.getPictogramElementForBusinessObject((Object)t1)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        ICompilationUnit cu1 = JavaCore.createCompilationUnitFrom((IFile)customerFile);
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpa20Project.getJavaResourceType("com.Address");
        Assert.assertNotNull((Object)customerType);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, addressType.getTypeBinding().getQualifiedName());
        EasyMock.expect((Object)this.featureProvider20.getPictogramElementForBusinessObject((Object)t2)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        ICompilationUnit cu2 = JavaCore.createCompilationUnitFrom((IFile)addressFile);
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit(t2)).andStubReturn((Object)cu2);
        Properties props = new Properties();
        props.setProperty(JPADiagramPropertyPage.PROP_COLLECTION_TYPE.getLocalName(), "list");
        EasyMock.expect((Object)this.featureProvider20.loadProperties(this.jpa20Project.getProject())).andReturn((Object)props);
        EasyMock.replay((Object[])new Object[]{this.featureProvider20});
        OneToManyUniDirRelation rel = new OneToManyUniDirRelation(this.featureProvider20, t1, t2, "address", true);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"address", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = t1.getAttributeNamed("address");
        Assert.assertNotNull((Object)ownerAt);
        Annotation o1 = ownerAt.getJavaPersistentAttribute().getResourceAttribute().getAnnotation("javax.persistence.OneToMany");
        Assert.assertNotNull((Object)o1);
        Annotation o2 = ownerAt.getJavaPersistentAttribute().getResourceAttribute().getAnnotation("javax.persistence.JoinColumn");
        Assert.assertNotNull((Object)o2);
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)o2;
        Assert.assertNotNull((Object)joinColumn.getName());
        Assert.assertNotNull((Object)joinColumn.getReferencedColumnName());
        Assert.assertEquals((Object)"Customer_id", (Object)joinColumn.getName());
        Assert.assertEquals((Object)"id", (Object)joinColumn.getReferencedColumnName());
    }

    @Test
    public void testCreateOneToManyUnidirIDClassRelation20() throws Exception {
        Assert.assertNotNull((Object)this.jpa20Project);
        IFile simpleEmployeeFile = this.factory.createIdClassInProject(this.jpa20Project.getProject(), new String[]{"com", "test"}, "Employee");
        IFile employeeFile = this.factory.createEntityWithCompositePKInProject(this.jpa20Project.getProject(), new String[]{"com", "test"}, "Employee");
        IFile projectFile = this.factory.createEntityInProject(this.jpa20Project.getProject(), new String[]{"com"}, "Project");
        this.jpa20Project.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)simpleEmployeeFile.exists());
        Assert.assertTrue((boolean)employeeFile.exists());
        JavaResourceAbstractType employeeType = this.jpa20Project.getJavaResourceType("com.test.Employee");
        Assert.assertNotNull((Object)employeeType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, employeeType.getTypeBinding().getQualifiedName());
        EasyMock.expect((Object)this.featureProvider20.getPictogramElementForBusinessObject((Object)t1)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        ICompilationUnit cu1 = JavaCore.createCompilationUnitFrom((IFile)employeeFile);
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        Assert.assertTrue((boolean)projectFile.exists());
        JavaResourceAbstractType projectType = this.jpa20Project.getJavaResourceType("com.Project");
        Assert.assertNotNull((Object)employeeType);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, projectType.getTypeBinding().getQualifiedName());
        EasyMock.expect((Object)this.featureProvider20.getPictogramElementForBusinessObject((Object)t2)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        ICompilationUnit cu2 = JavaCore.createCompilationUnitFrom((IFile)projectFile);
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit(t2)).andStubReturn((Object)cu2);
        Properties props = new Properties();
        props.setProperty(JPADiagramPropertyPage.PROP_COLLECTION_TYPE.getLocalName(), "list");
        EasyMock.expect((Object)this.featureProvider20.loadProperties(this.jpa20Project.getProject())).andReturn((Object)props);
        EasyMock.replay((Object[])new Object[]{this.featureProvider20});
        OneToManyUniDirRelation rel = new OneToManyUniDirRelation(this.featureProvider20, t1, t2, "project", true);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"project", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = t1.getAttributeNamed("project");
        Assert.assertNotNull((Object)ownerAt);
        Annotation o1 = ownerAt.getJavaPersistentAttribute().getResourceAttribute().getAnnotation("javax.persistence.OneToMany");
        Assert.assertNotNull((Object)o1);
        Annotation o2 = ownerAt.getJavaPersistentAttribute().getResourceAttribute().getAnnotation("javax.persistence.JoinColumns");
        Assert.assertNotNull((Object)o2);
        Assert.assertEquals((long)2L, (long)ownerAt.getJavaPersistentAttribute().getResourceAttribute().getAnnotationsSize("javax.persistence.JoinColumn"));
    }

    @Test
    public void testCreateOneToManyUnidirEmbeddedRelation20() throws Exception {
        Assert.assertNotNull((Object)this.jpa20Project);
        IFile simpleEmployeeFile = this.factory.createEmbeddedClassInProject(this.jpa20Project.getProject(), new String[]{"com", "test"}, "EmployeerId");
        IFile employeeFile = this.factory.createEntityWithEmbeddedPKInProject(this.jpa20Project.getProject(), new String[]{"com", "test"}, "Employeer");
        IFile projectFile = this.factory.createEntityInProject(this.jpa20Project.getProject(), new String[]{"com"}, "Person");
        this.jpa20Project.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)simpleEmployeeFile.exists());
        Assert.assertTrue((boolean)employeeFile.exists());
        JavaResourceAbstractType employeeType = this.jpa20Project.getJavaResourceType("com.test.Employeer");
        Assert.assertNotNull((Object)employeeType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, employeeType.getTypeBinding().getQualifiedName());
        EasyMock.expect((Object)this.featureProvider20.getPictogramElementForBusinessObject((Object)t1)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        ICompilationUnit cu1 = JavaCore.createCompilationUnitFrom((IFile)employeeFile);
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        Embeddable emb = JpaArtifactFactory.instance().getPersistenceUnit(t1).getEmbeddable("com.test.EmployeerId");
        emb.getAllAttributeMappings().iterator();
        Assert.assertTrue((boolean)projectFile.exists());
        JavaResourceAbstractType projectType = this.jpa20Project.getJavaResourceType("com.Person");
        Assert.assertNotNull((Object)employeeType);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpa20Project, projectType.getTypeBinding().getQualifiedName());
        EasyMock.expect((Object)this.featureProvider20.getPictogramElementForBusinessObject((Object)t2)).andStubReturn((Object)((PictogramElement)EasyMock.isA(Shape.class)));
        ICompilationUnit cu2 = JavaCore.createCompilationUnitFrom((IFile)projectFile);
        EasyMock.expect((Object)this.featureProvider20.getCompilationUnit(t2)).andStubReturn((Object)cu2);
        Properties props = new Properties();
        props.setProperty(JPADiagramPropertyPage.PROP_COLLECTION_TYPE.getLocalName(), "list");
        EasyMock.expect((Object)this.featureProvider20.loadProperties(this.jpa20Project.getProject())).andReturn((Object)props);
        EasyMock.replay((Object[])new Object[]{this.featureProvider20});
        OneToManyUniDirRelation rel = new OneToManyUniDirRelation(this.featureProvider20, t1, t2, "person", true);
        Assert.assertNotNull((Object)rel);
        Assert.assertSame((Object)t1, (Object)rel.getOwner());
        Assert.assertSame((Object)t2, (Object)rel.getInverse());
        Assert.assertEquals((Object)"person", (Object)rel.getOwnerAttributeName());
        PersistentAttribute ownerAt = t1.getAttributeNamed("person");
        Assert.assertNotNull((Object)ownerAt);
        Annotation o1 = ownerAt.getJavaPersistentAttribute().getResourceAttribute().getAnnotation("javax.persistence.OneToMany");
        Assert.assertNotNull((Object)o1);
        Annotation o2 = ownerAt.getJavaPersistentAttribute().getResourceAttribute().getAnnotation("javax.persistence.JoinColumns");
        Assert.assertNotNull((Object)o2);
        Assert.assertEquals((long)1L, (long)ownerAt.getJavaPersistentAttribute().getResourceAttribute().getAnnotationsSize("javax.persistence.JoinColumn"));
        SubIterableWrapper nestedAnnotations = new SubIterableWrapper((Iterable)ownerAt.getJavaPersistentAttribute().getResourceAttribute().getAnnotations("javax.persistence.JoinColumn"));
        for (JoinColumnAnnotation joinColumn : nestedAnnotations) {
            Assert.assertEquals((Object)"Employeer_firstName", (Object)joinColumn.getName());
            Assert.assertEquals((Object)"firstName", (Object)joinColumn.getReferencedColumnName());
        }
    }
}

