/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.junit4;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import junit.framework.Assert;
import org.eclipse.core.internal.events.BuildManager;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.NotificationManager;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.resources.AliasManager;
import org.eclipse.core.internal.resources.CharsetManager;
import org.eclipse.core.internal.resources.ContentDescriptionManager;
import org.eclipse.core.internal.resources.LocalMetaArea;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.NatureManager;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFilterMatcherDescriptor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jst.jsf.test.util.Activator;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestUtil;
import org.eclipse.jst.jsf.test.util.mock.AbstractWorkspaceContextWithEvents;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContext;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class RealWorkspaceContext
extends AbstractWorkspaceContextWithEvents {
    private DecoratedWorkspace _workspace;
    private final CopyOnWriteArrayList<IResourceChangeListener> _listeners = new CopyOnWriteArrayList();
    private final Workspace _actualWorkspace = (Workspace)ResourcesPlugin.getWorkspace();

    public RealWorkspaceContext() {
        this._workspace = new DecoratedWorkspace(this, this._actualWorkspace, this._listeners);
    }

    @Override
    protected void doInit() throws Exception {
        this.setWorkspace((IWorkspace)this._workspace);
        RealWorkspaceContext.setWorkspace((IResource)this._actualWorkspace.getRoot(), (IWorkspace)this._workspace);
    }

    private static void setWorkspace(IResource root, IWorkspace workspace) throws Exception {
        Class<Resource> rootClass = Resource.class;
        Field declaredField = rootClass.getDeclaredField("workspace");
        declaredField.setAccessible(true);
        declaredField.set(root, workspace);
    }

    private void setWorkspace(IWorkspace workspace) throws Exception {
        Class<ResourcesPlugin> resPlugin = ResourcesPlugin.class;
        Field declaredField = resPlugin.getDeclaredField("workspace");
        declaredField.setAccessible(true);
        declaredField.set(null, workspace);
    }

    @Override
    public void doDispose() throws Exception {
        RealWorkspaceContext.setWorkspace((IResource)this._actualWorkspace.getRoot(), (IWorkspace)this._actualWorkspace);
        this.setWorkspace((IWorkspace)this._workspace._ws);
        this._workspace = null;
    }

    @Override
    public IWorkspace getWorkspace() {
        this.assertInitialized();
        return this._workspace;
    }

    @Override
    public IResource getResource(IPath path) {
        this.assertInitialized();
        IWorkspaceRoot root = this._workspace.getRoot();
        IResource res = root.findMember(path, false);
        if (res != null && res.exists()) {
            return res;
        }
        return null;
    }

    @Override
    public IFile getFile(IPath path) {
        return (IFile)this.getResource(path);
    }

    @Override
    public IProject getProject(IPath path) {
        return (IProject)this.getResource(path);
    }

    @Override
    public IProject createProject(String baseId) {
        this.assertInitialized();
        int suffix = 0;
        String projectName = null;
        do {
            projectName = baseId + "_" + suffix++;
        } while (this._workspace.getRoot().getProject(projectName).exists());
        Assert.assertNotNull((Object)projectName);
        return this.createProject2(projectName);
    }

    private IProject createProject2(String projectName) {
        this.assertInitialized();
        ProjectTestEnvironment testEnv = new ProjectTestEnvironment(projectName);
        Assert.assertTrue((boolean)testEnv.createProject(false));
        return testEnv.getTestProject();
    }

    @Override
    public IProject createProject(IPath path) {
        return this.createProject2(path.toString());
    }

    @Override
    public IProject loadProject(IPath path, IWorkspaceContext.ZipFileLoader zipFileLoader) throws Exception {
        this.assertInitialized();
        Assert.assertFalse((boolean)this._workspace.getRoot().getProject(path.toString()).exists());
        return TestUtil.createProjectFromZip(zipFileLoader.getFile(), path.toString());
    }

    @Override
    public IProject loadProject(IPath path, Bundle bundle, String pathToZip) throws Exception {
        this.assertInitialized();
        Assert.assertFalse((boolean)this._workspace.getRoot().getProject(path.toString()).exists());
        return TestUtil.createProjectFromZip(bundle, path.toString(), pathToZip);
    }

    @Override
    public IFile attachFile(IProject project, IPath projectRelativePath, File file) throws Exception {
        this.assertInitialized();
        ByteArrayOutputStream stream = JSFTestUtil.loadFromFile(file);
        return TestUtil.createFile(project, projectRelativePath.toString(), stream.toString());
    }

    @Override
    public void fireWorkspaceEvent(final IResourceChangeEvent event) {
        this.assertInitialized();
        for (final IResourceChangeListener listener : this._listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.resourceChanged(event);
                }

                public void handleException(Throwable exception) {
                    Activator.log("While processing mock resource event", exception);
                }
            });
        }
    }

    @Override
    public List<IResourceChangeListener> getListeners() {
        this.assertInitialized();
        return Collections.unmodifiableList(this._listeners);
    }

    @Override
    public List<IResourceChangeListener> getListeners(List<Class<? extends IResourceChangeListener>> includeListeners) {
        ArrayList<IResourceChangeListener> listeners = new ArrayList<IResourceChangeListener>();
        block0: for (IResourceChangeListener listener : this.getListeners()) {
            for (Class<? extends IResourceChangeListener> clazz : includeListeners) {
                if (!clazz.isAssignableFrom(listener.getClass())) continue;
                listeners.add(listener);
                continue block0;
            }
        }
        return listeners;
    }

    @Override
    protected void assertInitialized() {
        super.assertInitialized();
    }

    @Override
    public void ensureAllMembers(IProject project) throws Exception {
    }

    private static class DecoratedWorkspace
    extends Workspace {
        private final Workspace _ws;
        private final List<IResourceChangeListener> _listeners;
        private final RealWorkspaceContext _wsContext;

        public DecoratedWorkspace(RealWorkspaceContext wsContext, Workspace ws, List<IResourceChangeListener> listeners) {
            this._wsContext = wsContext;
            this._ws = ws;
            this._listeners = listeners;
        }

        protected void flushBuildOrder() {
            this.invokeOnWorkspace("flushBuildOrder", new Class[0], new Object[0]);
        }

        private void invokeOnWorkspace(String name, Class<?>[] classes, Object[] values) {
            try {
                Class<Workspace> workspaceClass = Workspace.class;
                Method declaredMethod = workspaceClass.getDeclaredMethod(name, classes);
                declaredMethod.setAccessible(true);
                declaredMethod.invoke((Object)this._ws, values);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public void addLifecycleListener(ILifecycleListener listener) {
            this._ws.addLifecycleListener(listener);
        }

        public void addResourceChangeListener(IResourceChangeListener listener) {
            this.addResourceChangeListener(listener, 7);
        }

        public void addResourceChangeListener(IResourceChangeListener listener, int eventMask) {
            this._wsContext.assertInitialized();
            if (Thread.currentThread() == Display.getDefault().getThread()) {
                this._listeners.add(listener);
            }
            this._ws.addResourceChangeListener(listener, eventMask);
        }

        public ISavedState addSaveParticipant(Plugin plugin, ISaveParticipant participant) throws CoreException {
            return this._ws.addSaveParticipant(plugin, participant);
        }

        public ISavedState addSaveParticipant(String pluginId, ISaveParticipant participant) throws CoreException {
            return this._ws.addSaveParticipant(pluginId, participant);
        }

        public void beginOperation(boolean createNewTree) throws CoreException {
            this._ws.beginOperation(createNewTree);
        }

        public void broadcastBuildEvent(Object source, int type, int buildTrigger) {
            this._ws.broadcastBuildEvent(source, type, buildTrigger);
        }

        public void broadcastPostChange() {
            this._ws.broadcastPostChange();
        }

        public void build(int trigger, IProgressMonitor monitor) throws CoreException {
            this._ws.build(trigger, monitor);
        }

        public void checkpoint(boolean build) {
            this._ws.checkpoint(build);
        }

        public void close(IProgressMonitor monitor) throws CoreException {
            this._ws.close(monitor);
        }

        public IProject[][] computePrerequisiteOrder(IProject[] targets) {
            return this._ws.computePrerequisiteOrder(targets);
        }

        public IWorkspace.ProjectOrder computeProjectOrder(IProject[] projects) {
            return this._ws.computeProjectOrder(projects);
        }

        public IStatus copy(IResource[] resources, IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
            return this._ws.copy(resources, destination, force, monitor);
        }

        public IStatus copy(IResource[] resources, IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
            return this._ws.copy(resources, destination, updateFlags, monitor);
        }

        public int countResources(IPath root, int depth, boolean phantom) {
            return this._ws.countResources(root, depth, phantom);
        }

        public ResourceInfo createResource(IResource resource, boolean phantom) throws CoreException {
            return this._ws.createResource(resource, phantom);
        }

        public ResourceInfo createResource(IResource resource, int updateFlags) throws CoreException {
            return this._ws.createResource(resource, updateFlags);
        }

        public ResourceInfo createResource(IResource resource, ResourceInfo info, boolean phantom, boolean overwrite, boolean keepSyncInfo) throws CoreException {
            return this._ws.createResource(resource, info, phantom, overwrite, keepSyncInfo);
        }

        public IStatus delete(IResource[] resources, boolean force, IProgressMonitor monitor) throws CoreException {
            return this._ws.delete(resources, force, monitor);
        }

        public IStatus delete(IResource[] resources, int updateFlags, IProgressMonitor monitor) throws CoreException {
            return this._ws.delete(resources, updateFlags, monitor);
        }

        public void deleteMarkers(IMarker[] markers) throws CoreException {
            this._ws.deleteMarkers(markers);
        }

        public void endOperation(ISchedulingRule rule, boolean build) throws CoreException {
            this._ws.endOperation(rule, build);
        }

        public <T> T getAdapter(Class<T> adapter) {
            return (T)this._ws.getAdapter(adapter);
        }

        public void forgetSavedTree(String pluginId) {
            this._ws.forgetSavedTree(pluginId);
        }

        public AliasManager getAliasManager() {
            return this._ws.getAliasManager();
        }

        public BuildManager getBuildManager() {
            return this._ws.getBuildManager();
        }

        public IBuildConfiguration[] getBuildOrder() {
            return this._ws.getBuildOrder();
        }

        public CharsetManager getCharsetManager() {
            return this._ws.getCharsetManager();
        }

        public ContentDescriptionManager getContentDescriptionManager() {
            return this._ws.getContentDescriptionManager();
        }

        public Map getDanglingReferences() {
            return this._ws.getDanglingReferences();
        }

        public IWorkspaceDescription getDescription() {
            return this._ws.getDescription();
        }

        public ElementTree getElementTree() {
            return this._ws.getElementTree();
        }

        public FileSystemResourceManager getFileSystemManager() {
            return this._ws.getFileSystemManager();
        }

        public MarkerManager getMarkerManager() {
            return this._ws.getMarkerManager();
        }

        public LocalMetaArea getMetaArea() {
            return this._ws.getMetaArea();
        }

        public IFilterMatcherDescriptor getFilterMatcherDescriptor(String filterMAtcherId) {
            return this._ws.getFilterMatcherDescriptor(filterMAtcherId);
        }

        public IFilterMatcherDescriptor[] getFilterMatcherDescriptors() {
            return this._ws.getFilterMatcherDescriptors();
        }

        public IProjectNatureDescriptor getNatureDescriptor(String natureId) {
            return this._ws.getNatureDescriptor(natureId);
        }

        public IProjectNatureDescriptor[] getNatureDescriptors() {
            return this._ws.getNatureDescriptors();
        }

        public NatureManager getNatureManager() {
            return this._ws.getNatureManager();
        }

        public NotificationManager getNotificationManager() {
            return this._ws.getNotificationManager();
        }

        public IPathVariableManager getPathVariableManager() {
            return this._ws.getPathVariableManager();
        }

        public IPropertyManager getPropertyManager() {
            return this._ws.getPropertyManager();
        }

        public RefreshManager getRefreshManager() {
            return this._ws.getRefreshManager();
        }

        public ResourceInfo getResourceInfo(IPath path, boolean phantom, boolean mutable) {
            return this._ws.getResourceInfo(path, phantom, mutable);
        }

        public IWorkspaceRoot getRoot() {
            return this._ws.getRoot();
        }

        public IResourceRuleFactory getRuleFactory() {
            return this._ws.getRuleFactory();
        }

        public SaveManager getSaveManager() {
            return this._ws.getSaveManager();
        }

        public ISynchronizer getSynchronizer() {
            return this._ws.getSynchronizer();
        }

        public WorkManager getWorkManager() throws CoreException {
            return this._ws.getWorkManager();
        }

        public int hashCode() {
            return this._ws.hashCode();
        }

        public WorkspaceDescription internalGetDescription() {
            return this._ws.internalGetDescription();
        }

        public boolean isAutoBuilding() {
            return this._ws.isAutoBuilding();
        }

        public boolean isOpen() {
            return this._ws.isOpen();
        }

        public boolean isTreeLocked() {
            return this._ws.isTreeLocked();
        }

        public IProjectDescription loadProjectDescription(InputStream stream) throws CoreException {
            return this._ws.loadProjectDescription(stream);
        }

        public IProjectDescription loadProjectDescription(IPath path) throws CoreException {
            return this._ws.loadProjectDescription(path);
        }

        public IStatus move(IResource[] resources, IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
            return this._ws.move(resources, destination, force, monitor);
        }

        public IStatus move(IResource[] resources, IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
            return this._ws.move(resources, destination, updateFlags, monitor);
        }

        public IProjectDescription newProjectDescription(String projectName) {
            return this._ws.newProjectDescription(projectName);
        }

        public Resource newResource(IPath path, int type) {
            Resource res = this._ws.newResource(path, type);
            try {
                RealWorkspaceContext.setWorkspace((IResource)res, (IWorkspace)this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return res;
        }

        public ElementTree newWorkingTree() {
            return this._ws.newWorkingTree();
        }

        public IStatus open(IProgressMonitor monitor) throws CoreException {
            return this._ws.open(monitor);
        }

        public void prepareOperation(ISchedulingRule rule, IProgressMonitor monitor) throws CoreException {
            this._ws.prepareOperation(rule, monitor);
        }

        public void removeResourceChangeListener(IResourceChangeListener listener) {
            this._wsContext.assertInitialized();
            if (Thread.currentThread() == Display.getDefault().getThread()) {
                this._listeners.remove(listener);
            }
            this._ws.removeResourceChangeListener(listener);
        }

        public void removeSaveParticipant(Plugin plugin) {
            this._ws.removeSaveParticipant(plugin);
        }

        public void removeSaveParticipant(String pluginId) {
            this._ws.removeSaveParticipant(pluginId);
        }

        public void run(IWorkspaceRunnable action, IProgressMonitor monitor) throws CoreException {
            this._ws.run(action, monitor);
        }

        public void run(IWorkspaceRunnable action, ISchedulingRule rule, int options, IProgressMonitor monitor) throws CoreException {
            this._ws.run(action, rule, options, monitor);
        }

        public IStatus save(boolean full, IProgressMonitor monitor) throws CoreException {
            return this._ws.save(full, monitor);
        }

        public IStatus save(boolean full, boolean keepConsistencyWhenCanceled, IProgressMonitor monitor) throws CoreException {
            return this._ws.save(full, keepConsistencyWhenCanceled, monitor);
        }

        public void setCrashed(boolean value) {
            this._ws.setCrashed(value);
        }

        public void setDescription(IWorkspaceDescription value) {
            this._ws.setDescription(value);
        }

        public void setTreeLocked(boolean locked) {
            this._ws.setTreeLocked(locked);
        }

        public String[] sortNatureSet(String[] natureIds) {
            return this._ws.sortNatureSet(natureIds);
        }

        public String toDebugString() {
            return this._ws.toDebugString();
        }

        public String toString() {
            return this._ws.toString();
        }

        public URI transferVariableDefinition(IResource source, IResource dest, URI sourceURI) throws CoreException {
            return this._ws.transferVariableDefinition(source, dest, sourceURI);
        }

        public void updateModificationStamp(ResourceInfo info) {
            info.incrementModificationStamp();
        }

        public IStatus validateEdit(IFile[] files, Object context) {
            return this._ws.validateEdit(files, context);
        }

        public IStatus validateLinkLocation(IResource resource, IPath unresolvedLocation) {
            return this._ws.validateLinkLocation(resource, unresolvedLocation);
        }

        public IStatus validateLinkLocationURI(IResource resource, URI unresolvedLocation) {
            return this._ws.validateLinkLocationURI(resource, unresolvedLocation);
        }

        public IStatus validateName(String segment, int type) {
            return this._ws.validateName(segment, type);
        }

        public IStatus validateNatureSet(String[] natureIds) {
            return this._ws.validateNatureSet(natureIds);
        }

        public IStatus validatePath(String path, int type) {
            return this._ws.validatePath(path, type);
        }

        public IStatus validateProjectLocation(IProject context, IPath location) {
            return this._ws.validateProjectLocation(context, location);
        }

        public IStatus validateProjectLocationURI(IProject project, URI location) {
            return this._ws.validateProjectLocationURI(project, location);
        }

        public IStatus validateFiltered(IResource resource) {
            return this._ws.validateFiltered(resource);
        }
    }
}

