/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.integration.tests.util;

import java.util.Collection;
import org.eclipse.jst.ws.jaxws.dom.integration.internal.util.CommonNavigatorFinder;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.navigator.CommonNavigator;

public class CommonNavigatorFinderTest
extends MockObjectTestCase {
    private CommonNavigatorFinder finder;
    private Mock<IWorkbenchWindow> wbWindow;
    private Mock<IWorkbenchPage> wbPage;

    protected void setUp() throws Exception {
        super.setUp();
        this.wbPage = this.mock(IWorkbenchPage.class);
        this.wbWindow = this.mock(IWorkbenchWindow.class);
        this.wbWindow.stubs().method("getActivePage").will(this.returnValue(this.wbPage.proxy()));
        this.finder = new CommonNavigatorFinder((IWorkbenchWindow)this.wbWindow.proxy());
    }

    public void testWbWindowIsNull() {
        this.finder = new CommonNavigatorFinder(null);
        CommonNavigatorFinderTest.assertTrue((String)"Empty collection expected", (boolean)this.finder.findCommonNavigators().isEmpty());
    }

    public void testNoCommonNavigatorsOpened() {
        this.wbPage.stubs().method("getViewReferences").will(this.returnValue(new IViewReference[0]));
        CommonNavigatorFinderTest.assertTrue((String)"Empty collection expected", (boolean)this.finder.findCommonNavigators().isEmpty());
    }

    public void testCommonNavigatorNotYetInstantiated() {
        IViewReference viewRef = this.mockViewReference(null);
        this.wbPage.stubs().method("getViewReferences").will(this.returnValue(new IViewReference[]{viewRef}));
        CommonNavigatorFinderTest.assertTrue((String)"Empty collection expected", (boolean)this.finder.findCommonNavigators().isEmpty());
    }

    public void testNonCommonNavigatorViewNotFound() {
        Mock viewPart = this.mock(IViewPart.class);
        IViewReference viewRef = this.mockViewReference((IViewPart)viewPart.proxy());
        this.wbPage.stubs().method("getViewReferences").will(this.returnValue(new IViewReference[]{viewRef}));
        CommonNavigatorFinderTest.assertTrue((String)"Empty collection expected", (boolean)this.finder.findCommonNavigators().isEmpty());
    }

    public void testCommonNavigatorOpened() {
        CommonNavigator navigatorMock = new CommonNavigator();
        IViewReference viewRef = this.mockViewReference((IViewPart)navigatorMock);
        this.wbPage.stubs().method("getViewReferences").will(this.returnValue(new IViewReference[]{viewRef}));
        Collection foundNavigators = this.finder.findCommonNavigators();
        CommonNavigatorFinderTest.assertEquals((String)"One navigator expected", (int)1, (int)foundNavigators.size());
        CommonNavigatorFinderTest.assertSame((String)"Unexpected navigator", (Object)navigatorMock, foundNavigators.iterator().next());
    }

    private IViewReference mockViewReference(IViewPart viewPart) {
        Mock viewRefMock = this.mock(IViewReference.class);
        viewRefMock.stubs().method("getView").will(this.returnValue(viewPart));
        return (IViewReference)viewRefMock.proxy();
    }
}

