/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests.testcase;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.IMutableValidator;
import org.eclipse.wst.validation.MutableWorkspaceSettings;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResults;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.tests.testcase.TestEnvironment;

public class TestSuite4
extends TestCase {
    private TestEnvironment _env;
    private IProject _project;

    public static Test suite() {
        return new TestSuite(TestSuite4.class);
    }

    public TestSuite4(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._env = new TestEnvironment();
        IFacetedProjectWorkingCopy project = FacetedProjectFramework.createNewProject();
        project.setProjectName("FacetProject");
        IProjectFacet pf = ProjectFacetsManager.getProjectFacet((String)"java");
        IProjectFacetVersion ipv = pf.getVersion("1.5");
        HashSet<IProjectFacetVersion> set = new HashSet<IProjectFacetVersion>(1);
        set.add(ipv);
        project.setProjectFacets(set);
        project.commitChanges(null);
        this._project = project.getProject();
        IPath folder = this._env.addFolder(this._project.getFullPath(), "source");
        ResourcesPlugin.getWorkspace().getRoot().findMember(folder);
        this._env.addFile(folder, "first.test1", "info - information\nwarning - warning\nerror - error\n\nt1error - extra error\nt1warning - extra warning");
        TestSuite4.enableOnlyT4Validators();
    }

    private static void enableOnlyT4Validators() throws InvocationTargetException {
        ValidationFramework vf = ValidationFramework.getDefault();
        MutableWorkspaceSettings ws = vf.getWorkspaceSettings();
        IMutableValidator[] iMutableValidatorArray = ws.getValidators();
        int n = iMutableValidatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMutableValidator v = iMutableValidatorArray[n2];
            boolean enable = v.getValidatorClassname().startsWith("org.eclipse.wst.validation.tests.T4");
            v.setBuildValidation(enable);
            v.setManualValidation(enable);
            ++n2;
        }
        vf.applyChanges(ws, true);
    }

    protected void tearDown() throws Exception {
        this._project.delete(true, null);
        this._env.dispose();
        super.tearDown();
    }

    public void testFacetVersions() throws CoreException, UnsupportedEncodingException, InterruptedException {
        Tracing.log((String)"TestSuite4-01: testFacetVersions starting");
        NullProgressMonitor monitor = new NullProgressMonitor();
        ValidationFramework vf = ValidationFramework.getDefault();
        IProject[] projects = new IProject[]{this._project};
        ValidationResults vr = vf.validate(projects, true, false, (IProgressMonitor)monitor);
        int errors = vr.getSeverityError();
        TestSuite4.assertEquals((String)"Number of errors", (int)1, (int)errors);
        Tracing.log((String)"TestSuite4-02:testFacetVersions finished");
    }
}

