/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.contentassist;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xsl.ui.tests.AbstractSourceViewerTest;
import org.junit.Assert;
import org.junit.Test;

public class TestExcludeResultPrefixesCompletionProposal
extends AbstractSourceViewerTest {
    private ICompletionProposal[] setupProposals(int column, int line) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException, BadLocationException, Exception {
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument document = (IStructuredDocument)this.sourceViewer.getDocument();
        int offset = document.getLineOffset(line) + column;
        ICompletionProposal[] proposals = this.getProposals(offset);
        return proposals;
    }

    @Test
    public void testAllDefaultValueNoProposals() throws Exception {
        this.fileName = "TestResultPrefixes.xsl";
        int column = 29;
        int line = 2;
        ICompletionProposal[] proposals = this.setupProposals(column, line);
        Assert.assertEquals((String)"Found proposals when #all already in result value.", (long)0L, (long)proposals.length);
    }

    @Test
    public void testXHTMLNamespacePropsoalAvailable() throws Exception {
        this.fileName = "TestResultPrefixesEmpty.xsl";
        int column = 29;
        int line = 3;
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument cfr_ignored_0 = (IStructuredDocument)this.sourceViewer.getDocument();
        ICompletionProposal[] proposals = this.getProposals(line, column);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        Assert.assertEquals((String)"Proposal length not 2.", (long)2L, (long)proposals.length);
        Assert.assertEquals((String)"Proposal did not find xhtml as proposal value.", (Object)"xhtml", (Object)proposals[1].getDisplayString());
    }

    @Test
    public void testAllPropsoalAvailable() throws Exception {
        this.fileName = "TestResultPrefixesEmpty.xsl";
        int column = 29;
        int line = 3;
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument cfr_ignored_0 = (IStructuredDocument)this.sourceViewer.getDocument();
        ICompletionProposal[] proposals = this.getProposals(line, column);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        Assert.assertEquals((String)"Proposal length not 2.", (long)2L, (long)proposals.length);
        Assert.assertEquals((String)"Proposal did not find xhtml as proposal value.", (Object)"#all", (Object)proposals[0].getDisplayString());
    }

    @Test
    public void testExcludeXHTMLProposal() throws Exception {
        this.fileName = "TestResultPrefixesWithXhtml.xsl";
        int column = 35;
        int line = 2;
        ICompletionProposal[] proposals = this.setupProposals(column, line);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        int cnt = 0;
        while (cnt < proposals.length) {
            if (proposals[cnt].getDisplayString().equals("xhtml")) {
                Assert.fail((String)"XHTML Proposal found, when it should not have been!");
            }
            ++cnt;
        }
    }

    @Test
    public void testTestProposal() throws Exception {
        this.fileName = "TestResultPrefixesWithXhtml.xsl";
        int column = 35;
        int line = 3;
        ICompletionProposal[] proposals = this.setupProposals(column, line);
        Assert.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        Assert.assertFalse((String)"Proposals returned more than one.", (proposals.length > 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Did not find test in proposal list", (Object)"test", (Object)proposals[0].getDisplayString());
    }
}

