/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.queue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.queue.ArrayQueue;
import org.eclipse.jpt.common.utility.internal.queue.LinkedQueue;
import org.eclipse.jpt.common.utility.internal.queue.QueueTools;
import org.eclipse.jpt.common.utility.internal.queue.SynchronizedQueue;
import org.eclipse.jpt.common.utility.internal.stack.ArrayStack;
import org.eclipse.jpt.common.utility.internal.stack.StackTools;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.deque.DequeToolsTests;
import org.eclipse.jpt.common.utility.tests.internal.queue.QueueTests;

public class SynchronizedQueueTests
extends QueueTests {
    private volatile SynchronizedQueue<String> sq;
    volatile boolean timeoutOccurred;
    volatile long startTime;
    volatile long endTime;
    volatile Object dequeuedObject;
    boolean commandExecuted;
    static final String ITEM_1 = new String();
    static final String ITEM_2 = new String();

    public SynchronizedQueueTests(String name) {
        super(name);
    }

    @Override
    Queue<String> buildQueue() {
        return QueueTools.synchronizedQueue();
    }

    @Override
    public void testClone() {
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sq = QueueTools.synchronizedQueue();
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
        this.dequeuedObject = null;
    }

    public void testConstructorQueue() throws Exception {
        ArrayQueue innerQueue = QueueTools.arrayQueue();
        SynchronizedQueue stack = QueueTools.synchronizedQueue((Queue)innerQueue);
        SynchronizedQueueTests.assertNotNull((Object)stack);
        SynchronizedQueueTests.assertSame((Object)stack, (Object)stack.getMutex());
    }

    public void testConstructorQueue_NPE() throws Exception {
        boolean exCaught = false;
        try {
            SynchronizedQueue stack = QueueTools.synchronizedQueue(null);
            SynchronizedQueueTests.fail((String)("bogus stack: " + stack));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        SynchronizedQueueTests.assertTrue((boolean)exCaught);
    }

    public void testConstructorQueueObject() throws Exception {
        String mutex = "mutex";
        ArrayQueue innerQueue = QueueTools.arrayQueue();
        SynchronizedQueue stack = QueueTools.synchronizedQueue((Queue)innerQueue, (Object)mutex);
        SynchronizedQueueTests.assertNotNull((Object)stack);
        SynchronizedQueueTests.assertSame((Object)mutex, (Object)stack.getMutex());
    }

    public void testConstructorQueueObject_NPE1() throws Exception {
        String mutex = "mutex";
        boolean exCaught = false;
        try {
            SynchronizedQueue stack = QueueTools.synchronizedQueue(null, (Object)mutex);
            SynchronizedQueueTests.fail((String)("bogus stack: " + stack));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        SynchronizedQueueTests.assertTrue((boolean)exCaught);
    }

    public void testConstructorQueueObject_NPE2() throws Exception {
        ArrayQueue innerQueue = QueueTools.arrayQueue();
        boolean exCaught = false;
        try {
            SynchronizedQueue stack = QueueTools.synchronizedQueue((Queue)innerQueue, null);
            SynchronizedQueueTests.fail((String)("bogus stack: " + stack));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        SynchronizedQueueTests.assertTrue((boolean)exCaught);
    }

    public void testConcurrentDequeue() throws Exception {
        this.verifyConcurrentDequeue(new SlowLinkedQueue<String>(), "first");
        this.verifyConcurrentDequeue(new SlowSynchronizedQueue<String>(), "second");
    }

    private void verifyConcurrentDequeue(SlowQueue<String> slowQueue, String expected) throws Exception {
        slowQueue.enqueue("first");
        slowQueue.enqueue("second");
        Thread thread = this.buildThread(this.buildRunnableDequeue(slowQueue));
        thread.start();
        Thread.sleep(TWO_TICKS);
        SynchronizedQueueTests.assertEquals((String)expected, (String)((String)slowQueue.dequeue()));
        thread.join();
        SynchronizedQueueTests.assertTrue((boolean)slowQueue.isEmpty());
    }

    private Runnable buildRunnableDequeue(final SlowQueue<String> slowQueue) {
        return new Runnable(){

            @Override
            public void run() {
                slowQueue.slowDequeue();
            }
        };
    }

    public void testConcurrentEnqueue() throws Exception {
        this.verifyConcurrentEnqueue(new SlowLinkedQueue<String>(), "second", "first");
        this.verifyConcurrentEnqueue(new SlowSynchronizedQueue<String>(), "first", "second");
    }

    private void verifyConcurrentEnqueue(SlowQueue<String> slowQueue, String first, String second) throws Exception {
        Thread thread = this.buildThread(this.buildRunnableEnqueue(slowQueue, "first"));
        thread.start();
        Thread.sleep(TWO_TICKS);
        slowQueue.enqueue("second");
        thread.join();
        SynchronizedQueueTests.assertEquals((String)first, (String)((String)slowQueue.dequeue()));
        SynchronizedQueueTests.assertEquals((String)second, (String)((String)slowQueue.dequeue()));
        SynchronizedQueueTests.assertTrue((boolean)slowQueue.isEmpty());
    }

    private Runnable buildRunnableEnqueue(final SlowQueue<String> slowQueue, final String element) {
        return new Runnable(){

            @Override
            public void run() {
                slowQueue.slowEnqueue(element);
            }
        };
    }

    public void testConcurrentIsEmpty() throws Exception {
        this.verifyConcurrentIsEmpty(new SlowLinkedQueue<String>(), true);
        this.verifyConcurrentIsEmpty(new SlowSynchronizedQueue<String>(), false);
    }

    private void verifyConcurrentIsEmpty(SlowQueue<String> slowQueue, boolean empty) throws Exception {
        Thread thread = this.buildThread(this.buildRunnableEnqueue(slowQueue, "first"));
        thread.start();
        Thread.sleep(TWO_TICKS);
        SynchronizedQueueTests.assertEquals((boolean)empty, (boolean)slowQueue.isEmpty());
        thread.join();
        SynchronizedQueueTests.assertEquals((String)"first", (String)((String)slowQueue.dequeue()));
        SynchronizedQueueTests.assertTrue((boolean)slowQueue.isEmpty());
    }

    public void testWaitUntilEmpty() throws Exception {
        this.verifyWaitUntilEmpty(-1L);
        SynchronizedQueueTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.dequeuedObject);
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilEmpty2() throws Exception {
        this.verifyWaitUntilEmpty(0L);
        SynchronizedQueueTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.dequeuedObject);
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilEmptyTimeout() throws Exception {
        this.verifyWaitUntilEmpty(TICK);
        SynchronizedQueueTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.dequeuedObject);
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitUntilEmpty(long timeout) throws Exception {
        this.sq.enqueue((Object)ITEM_1);
        Runnable r1 = this.buildRunnable(this.buildDequeueCommand(), this.sq, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitUntilEmptyCommand(timeout), this.sq, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitUntilEmptyCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedQueue<String> synchronizedQueue) throws InterruptedException {
                SynchronizedQueueTests.this.startTime = System.currentTimeMillis();
                SynchronizedQueueTests.this.timeoutOccurred = this.timeoutOccurred(synchronizedQueue);
                SynchronizedQueueTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedQueue<String> synchronizedQueue) throws InterruptedException {
                if (timeout < 0L) {
                    synchronizedQueue.waitUntilEmpty();
                    return false;
                }
                return !synchronizedQueue.waitUntilEmpty(timeout);
            }
        };
    }

    public void testWaitUntilNotEmpty() throws Exception {
        this.verifyWaitUntilNotEmpty(-1L);
        SynchronizedQueueTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertFalse((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.sq.peek());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilNotEmpty2() throws Exception {
        this.verifyWaitUntilNotEmpty(0L);
        SynchronizedQueueTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertFalse((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.sq.peek());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilNotEmptyTimeout() throws Exception {
        this.verifyWaitUntilNotEmpty(TICK);
        SynchronizedQueueTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertFalse((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.sq.peek());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitUntilNotEmpty(long timeout) throws Exception {
        Runnable r1 = this.buildRunnable(this.buildEnqueueCommand(), this.sq, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitUntilNotEmptyCommand(timeout), this.sq, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitUntilNotEmptyCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedQueue<String> synchronizedQueue) throws InterruptedException {
                SynchronizedQueueTests.this.startTime = System.currentTimeMillis();
                SynchronizedQueueTests.this.timeoutOccurred = this.timeoutOccurred(synchronizedQueue);
                SynchronizedQueueTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedQueue<String> synchronizedQueue) throws InterruptedException {
                if (timeout < 0L) {
                    synchronizedQueue.waitUntilNotEmpty();
                    return false;
                }
                return !synchronizedQueue.waitUntilNotEmpty(timeout);
            }
        };
    }

    public void testWaitToDequeue() throws Exception {
        this.verifyWaitToDequeue(-1L);
        SynchronizedQueueTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.dequeuedObject);
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToDequeue2() throws Exception {
        this.verifyWaitToDequeue(0L);
        SynchronizedQueueTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.dequeuedObject);
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToDequeueTimeout() throws Exception {
        this.verifyWaitToDequeue(TICK);
        SynchronizedQueueTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertNull((Object)this.dequeuedObject);
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.sq.peek());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToDequeue(long timeout) throws Exception {
        Runnable r1 = this.buildRunnable(this.buildEnqueueCommand(), this.sq, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitToDequeueCommand(timeout), this.sq, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitToDequeueCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedQueue<String> synchronizedQueue) throws InterruptedException {
                SynchronizedQueueTests.this.startTime = System.currentTimeMillis();
                this.waitToDequeue(synchronizedQueue);
                SynchronizedQueueTests.this.endTime = System.currentTimeMillis();
            }

            private void waitToDequeue(SynchronizedQueue<String> synchronizedQueue) throws InterruptedException {
                if (timeout < 0L) {
                    SynchronizedQueueTests.this.dequeuedObject = synchronizedQueue.waitToDequeue();
                    return;
                }
                try {
                    SynchronizedQueueTests.this.dequeuedObject = synchronizedQueue.waitToDequeue(timeout);
                }
                catch (NoSuchElementException noSuchElementException) {
                    SynchronizedQueueTests.this.timeoutOccurred = true;
                }
            }
        };
    }

    public void testWaitToEnqueue() throws Exception {
        this.verifyWaitToEnqueue(-1L);
        SynchronizedQueueTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.dequeuedObject);
        SynchronizedQueueTests.assertFalse((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertSame((Object)ITEM_2, (Object)this.sq.peek());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToEnqueue2() throws Exception {
        this.verifyWaitToEnqueue(0L);
        SynchronizedQueueTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.dequeuedObject);
        SynchronizedQueueTests.assertFalse((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertSame((Object)ITEM_2, (Object)this.sq.peek());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToEnqueueTimeout() throws Exception {
        this.verifyWaitToEnqueue(TICK);
        SynchronizedQueueTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedQueueTests.assertSame((Object)ITEM_1, (Object)this.dequeuedObject);
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToEnqueue(long timeout) throws Exception {
        this.sq.enqueue((Object)ITEM_1);
        Runnable r1 = this.buildRunnable(this.buildDequeueCommand(), this.sq, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitToEnqueueCommand(timeout), this.sq, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitToEnqueueCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedQueue<String> synchronizedQueue) throws InterruptedException {
                SynchronizedQueueTests.this.startTime = System.currentTimeMillis();
                SynchronizedQueueTests.this.timeoutOccurred = this.timeoutOccurred(synchronizedQueue);
                SynchronizedQueueTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedQueue<String> synchronizedQueue) throws InterruptedException {
                if (timeout < 0L) {
                    synchronizedQueue.waitToEnqueue((Object)ITEM_2);
                    return false;
                }
                return !synchronizedQueue.waitToEnqueue((Object)ITEM_2, timeout);
            }
        };
    }

    private Command buildEnqueueCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedQueue<String> synchronizedQueue) {
                synchronizedQueue.enqueue((Object)ITEM_1);
            }
        };
    }

    private Command buildDequeueCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedQueue<String> synchronizedQueue) {
                SynchronizedQueueTests.this.dequeuedObject = synchronizedQueue.dequeue();
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedQueue<String> synchronizedQueue, final long sleep) {
        return new MultiThreadedTestCase.TestRunnable(this){

            @Override
            protected void run_() throws Throwable {
                if (sleep != 0L) {
                    Thread.sleep(sleep);
                }
                command.execute((SynchronizedQueue<String>)synchronizedQueue);
            }
        };
    }

    long calculateElapsedTime() {
        return this.endTime - this.startTime;
    }

    public void testExecute() throws Exception {
        org.eclipse.jpt.common.utility.command.Command command = new org.eclipse.jpt.common.utility.command.Command(){

            public void execute() {
                SynchronizedQueueTests.this.commandExecuted = true;
            }
        };
        this.commandExecuted = false;
        this.sq.execute(command);
        SynchronizedQueueTests.assertTrue((boolean)this.commandExecuted);
    }

    public void testEnqueueAllIterable() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        this.sq.enqueueAll(list);
        SynchronizedQueueTests.assertEquals((String)"one", (String)((String)this.sq.dequeue()));
        SynchronizedQueueTests.assertEquals((String)"two", (String)((String)this.sq.dequeue()));
        SynchronizedQueueTests.assertEquals((String)"three", (String)((String)this.sq.dequeue()));
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
    }

    public void testEnqueueAllIterable_empty() throws Exception {
        ArrayList list = new ArrayList();
        this.sq.enqueueAll(list);
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
    }

    public void testEnqueueAllObjectArray() throws Exception {
        this.sq.enqueueAll((Object[])new String[]{"one", "two", "three"});
        SynchronizedQueueTests.assertEquals((String)"one", (String)((String)this.sq.dequeue()));
        SynchronizedQueueTests.assertEquals((String)"two", (String)((String)this.sq.dequeue()));
        SynchronizedQueueTests.assertEquals((String)"three", (String)((String)this.sq.dequeue()));
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
    }

    public void testEnqueueAllObjectArray_empty() throws Exception {
        this.sq.enqueueAll((Object[])new String[0]);
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
    }

    public void testEnqueueAllStack() throws Exception {
        ArrayStack stack = StackTools.arrayStack();
        stack.push((Object)"one");
        stack.push((Object)"two");
        stack.push((Object)"three");
        this.sq.enqueueAll((Stack)stack);
        SynchronizedQueueTests.assertEquals((String)"three", (String)((String)this.sq.dequeue()));
        SynchronizedQueueTests.assertEquals((String)"two", (String)((String)this.sq.dequeue()));
        SynchronizedQueueTests.assertEquals((String)"one", (String)((String)this.sq.dequeue()));
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
    }

    public void testEnqueueAllStack_empty() throws Exception {
        ArrayStack stack = StackTools.arrayStack();
        this.sq.enqueueAll((Stack)stack);
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
    }

    public void testEnqueueAllQueue() throws Exception {
        ArrayQueue queue = QueueTools.arrayQueue();
        queue.enqueue((Object)"one");
        queue.enqueue((Object)"two");
        queue.enqueue((Object)"three");
        this.sq.enqueueAll((Queue)queue);
        SynchronizedQueueTests.assertEquals((String)"one", (String)((String)this.sq.dequeue()));
        SynchronizedQueueTests.assertEquals((String)"two", (String)((String)this.sq.dequeue()));
        SynchronizedQueueTests.assertEquals((String)"three", (String)((String)this.sq.dequeue()));
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
    }

    public void testEnqueueAllQueue_empty() throws Exception {
        ArrayQueue queue = QueueTools.arrayQueue();
        this.sq.enqueueAll((Queue)queue);
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
    }

    public void testDrain() throws Exception {
        this.sq.enqueue((Object)"one");
        this.sq.enqueue((Object)"two");
        this.sq.enqueue((Object)"three");
        ArrayList list = this.sq.drain();
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertEquals((String)"one", (String)((String)list.get(0)));
        SynchronizedQueueTests.assertEquals((String)"two", (String)((String)list.get(1)));
        SynchronizedQueueTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testDrain_empty() throws Exception {
        ArrayList list = this.sq.drain();
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertTrue((boolean)list.isEmpty());
    }

    public void testDrainToCollection() throws Exception {
        this.sq.enqueue((Object)"one");
        this.sq.enqueue((Object)"two");
        this.sq.enqueue((Object)"three");
        ArrayList list = new ArrayList();
        SynchronizedQueueTests.assertTrue((boolean)this.sq.drainTo(list));
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertEquals((String)"one", (String)((String)list.get(0)));
        SynchronizedQueueTests.assertEquals((String)"two", (String)((String)list.get(1)));
        SynchronizedQueueTests.assertEquals((String)"three", (String)((String)list.get(2)));
    }

    public void testDrainToCollection_empty() throws Exception {
        ArrayList list = new ArrayList();
        SynchronizedQueueTests.assertFalse((boolean)this.sq.drainTo(list));
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertTrue((boolean)list.isEmpty());
    }

    public void testDrainToListInt() throws Exception {
        this.sq.enqueue((Object)"one");
        this.sq.enqueue((Object)"two");
        this.sq.enqueue((Object)"three");
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        SynchronizedQueueTests.assertTrue((boolean)this.sq.drainTo(list, 2));
        SynchronizedQueueTests.assertEquals((String)"aaa", (String)((String)list.get(0)));
        SynchronizedQueueTests.assertEquals((String)"bbb", (String)((String)list.get(1)));
        SynchronizedQueueTests.assertEquals((String)"one", (String)((String)list.get(2)));
        SynchronizedQueueTests.assertEquals((String)"two", (String)((String)list.get(3)));
        SynchronizedQueueTests.assertEquals((String)"three", (String)((String)list.get(4)));
        SynchronizedQueueTests.assertEquals((String)"ccc", (String)((String)list.get(5)));
    }

    public void testDrainToListInt_end() throws Exception {
        this.sq.enqueue((Object)"one");
        this.sq.enqueue((Object)"two");
        this.sq.enqueue((Object)"three");
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        SynchronizedQueueTests.assertTrue((boolean)this.sq.drainTo(list, 3));
        SynchronizedQueueTests.assertEquals((String)"aaa", (String)((String)list.get(0)));
        SynchronizedQueueTests.assertEquals((String)"bbb", (String)((String)list.get(1)));
        SynchronizedQueueTests.assertEquals((String)"ccc", (String)((String)list.get(2)));
        SynchronizedQueueTests.assertEquals((String)"one", (String)((String)list.get(3)));
        SynchronizedQueueTests.assertEquals((String)"two", (String)((String)list.get(4)));
        SynchronizedQueueTests.assertEquals((String)"three", (String)((String)list.get(5)));
    }

    public void testDrainToListInt_empty() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        SynchronizedQueueTests.assertFalse((boolean)this.sq.drainTo(list, 2));
        SynchronizedQueueTests.assertEquals((String)"aaa", (String)((String)list.get(0)));
        SynchronizedQueueTests.assertEquals((String)"bbb", (String)((String)list.get(1)));
        SynchronizedQueueTests.assertEquals((String)"ccc", (String)((String)list.get(2)));
    }

    public void testDrainToStack() throws Exception {
        this.sq.enqueue((Object)"one");
        this.sq.enqueue((Object)"two");
        this.sq.enqueue((Object)"three");
        ArrayStack stack = StackTools.arrayStack();
        SynchronizedQueueTests.assertTrue((boolean)this.sq.drainTo((Stack)stack));
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertEquals((String)"three", (String)((String)stack.pop()));
        SynchronizedQueueTests.assertEquals((String)"two", (String)((String)stack.pop()));
        SynchronizedQueueTests.assertEquals((String)"one", (String)((String)stack.pop()));
        SynchronizedQueueTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testDrainToStack_empty() throws Exception {
        ArrayStack stack = StackTools.arrayStack();
        SynchronizedQueueTests.assertFalse((boolean)this.sq.drainTo((Stack)stack));
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testDrainToQueue() throws Exception {
        this.sq.enqueue((Object)"one");
        this.sq.enqueue((Object)"two");
        this.sq.enqueue((Object)"three");
        ArrayQueue queue = QueueTools.arrayQueue();
        SynchronizedQueueTests.assertTrue((boolean)this.sq.drainTo((Queue)queue));
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        SynchronizedQueueTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        SynchronizedQueueTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
        SynchronizedQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testDrainToQueue_empty() throws Exception {
        ArrayQueue queue = QueueTools.arrayQueue();
        SynchronizedQueueTests.assertFalse((boolean)this.sq.drainTo((Queue)queue));
        SynchronizedQueueTests.assertTrue((boolean)this.sq.isEmpty());
        SynchronizedQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testDrainToMapTransformer() {
        this.sq.enqueue((Object)"one");
        this.sq.enqueue((Object)"two");
        this.sq.enqueue((Object)"zero");
        HashMap map = new HashMap();
        SynchronizedQueueTests.assertTrue((boolean)this.sq.drainTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER));
        SynchronizedQueueTests.assertEquals((String)"one", (String)((String)map.get("o")));
        SynchronizedQueueTests.assertEquals((String)"two", (String)((String)map.get("t")));
        SynchronizedQueueTests.assertEquals((String)"zero", (String)((String)map.get("z")));
    }

    public void testDrainToMapTransformer_empty() {
        HashMap map = new HashMap();
        SynchronizedQueueTests.assertFalse((boolean)this.sq.drainTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER));
        SynchronizedQueueTests.assertTrue((boolean)map.isEmpty());
    }

    public void testDrainToMapTransformerTransformer() {
        this.sq.enqueue((Object)"one");
        this.sq.enqueue((Object)"two");
        this.sq.enqueue((Object)"zero");
        HashMap map = new HashMap();
        SynchronizedQueueTests.assertTrue((boolean)this.sq.drainTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER, DequeToolsTests.EMPHASIZER));
        SynchronizedQueueTests.assertEquals((String)"*one*", (String)((String)map.get("o")));
        SynchronizedQueueTests.assertEquals((String)"*two*", (String)((String)map.get("t")));
        SynchronizedQueueTests.assertEquals((String)"*zero*", (String)((String)map.get("z")));
    }

    public void testDrainToMapTransformerTransformer_empty() {
        HashMap map = new HashMap();
        SynchronizedQueueTests.assertFalse((boolean)this.sq.drainTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER, DequeToolsTests.EMPHASIZER));
        SynchronizedQueueTests.assertTrue((boolean)map.isEmpty());
    }

    private static interface Command {
        public void execute(SynchronizedQueue<String> var1) throws InterruptedException;
    }

    private class SlowLinkedQueue<E>
    extends LinkedQueue<E>
    implements SlowQueue<E> {
        private static final long serialVersionUID = 1L;

        SlowLinkedQueue() {
        }

        @Override
        public Object slowDequeue() {
            try {
                Thread.sleep(5L * TICK);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return this.dequeue();
        }

        @Override
        public void slowEnqueue(E element) {
            try {
                Thread.sleep(5L * TICK);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            this.enqueue(element);
        }
    }

    private static interface SlowQueue<E>
    extends Queue<E> {
        public Object slowDequeue();

        public void slowEnqueue(E var1);
    }

    private class SlowSynchronizedQueue<E>
    extends SynchronizedQueue<E>
    implements SlowQueue<E> {
        private static final long serialVersionUID = 1L;

        SlowSynchronizedQueue() {
            super((Queue)QueueTools.linkedQueue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object slowDequeue() {
            Object object = this.getMutex();
            synchronized (object) {
                try {
                    Thread.sleep(5L * TICK);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                return this.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void slowEnqueue(E element) {
            Object object = this.getMutex();
            synchronized (object) {
                try {
                    Thread.sleep(5L * TICK);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                this.enqueue(element);
            }
        }
    }
}

