/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.internal.symbols.ResourceBundleSymbolSourceProvider;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class TestResourceBundleSymbolSourceProvider
extends TestCase {
    private IFile _testJSP;
    private JSFFacetedTestEnvironment _jsfFactedTestEnvironment;
    private WebProjectTestEnvironment _projectTestEnvironment;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        this._projectTestEnvironment = new WebProjectTestEnvironment("TestResourceBundleSymbolSourceProvider_" + this.getName(), JavaFacet.VERSION_1_5, ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.5"));
        this._projectTestEnvironment.createProject(false);
        JDTTestEnvironment jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)this._projectTestEnvironment);
        TestFileResource input = new TestFileResource();
        input.load(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/bundle1.resources.data");
        jdtTestEnvironment.addResourceFile("src", (InputStream)new ByteArrayInputStream(input.toBytes()), "beans", "bundle.properties");
        input = new TestFileResource();
        input.load(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/bundle2.resources.data");
        jdtTestEnvironment.addResourceFile("src", (InputStream)new ByteArrayInputStream(input.toBytes()), "beans", "bundle2.properties");
        this._projectTestEnvironment.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/faces-config_1_2.xml.data", "/WEB-INF/faces-config.xml");
        IResource res = this._projectTestEnvironment.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/testdata1.jsp.data", "testdata1.jsp");
        this._testJSP = (IFile)res;
        this._jsfFactedTestEnvironment = new JSFFacetedTestEnvironment(this._projectTestEnvironment);
        this._jsfFactedTestEnvironment.initialize("1.2");
    }

    public void testSanity() {
        IJSFAppConfigManager appconfigMgr = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)this._projectTestEnvironment.getTestProject());
        List resourceBundles = appconfigMgr.getResourceBundles();
        TestResourceBundleSymbolSourceProvider.assertEquals((int)2, (int)resourceBundles.size());
    }

    public void testGetSymbolsIAdaptableInt() {
        ResourceBundleSymbolSourceProvider sourceProvider = new ResourceBundleSymbolSourceProvider();
        ISymbol[] symbols = sourceProvider.getSymbols((IAdaptable)this._testJSP, 63);
        TestResourceBundleSymbolSourceProvider.assertEquals((int)2, (int)symbols.length);
        ArrayList<String> testProps = new ArrayList<String>();
        testProps.add("prop1");
        testProps.add("one");
        testProps.add("two");
        this.assertContains(symbols, "resBundleProp1", testProps);
        testProps.clear();
        testProps.add("x_prop1");
        testProps.add("x_one");
        testProps.add("x_two");
        this.assertContains(symbols, "resBundleProp2", testProps);
    }

    private void assertContains(ISymbol[] symbols, String varName, List<String> properties) {
        ArrayList<String> copyProperties = new ArrayList<String>(properties);
        ArrayList<String> propsNotFound = new ArrayList<String>();
        boolean foundSymbol = false;
        ISymbol[] iSymbolArray = symbols;
        int n = symbols.length;
        int n2 = 0;
        while (n2 < n) {
            ISymbol symbol = iSymbolArray[n2];
            if (varName.equals(symbol.getName())) {
                foundSymbol = true;
                TestResourceBundleSymbolSourceProvider.assertTrue((boolean)(symbol instanceof IInstanceSymbol));
                IInstanceSymbol varSymbol = (IInstanceSymbol)symbol;
                EList props = varSymbol.getTypeDescriptor().getProperties();
                for (Object element : props) {
                    IPropertySymbol prop = (IPropertySymbol)element;
                    if (copyProperties.contains(prop.getName())) {
                        copyProperties.remove(prop.getName());
                        continue;
                    }
                    propsNotFound.add(prop.getName());
                }
            }
            ++n2;
        }
        TestResourceBundleSymbolSourceProvider.assertTrue((String)"Symbol not found", (boolean)foundSymbol);
        TestResourceBundleSymbolSourceProvider.assertTrue((String)String.format("%d properties not found, %s not found, not matched %s", copyProperties.size(), Arrays.toString(copyProperties.toArray(new String[0])), Arrays.toString(propsNotFound.toArray(new String[0]))), (boolean)copyProperties.isEmpty());
    }
}

