/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import java.util.Locale;
import org.eclipse.wst.jsdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;

public class StatementRecoveryTest
extends AbstractCompilerTest {
    public static final boolean ONLY_DIET_PLUS_BODY_WITH_STATEMENT_RECOVERY = true;
    public static boolean optimizeStringLiterals = false;

    public StatementRecoveryTest(String testName) {
        super(testName);
    }

    public void checkParse(char[] source, String expectedDietUnitToString, String expectedDietWithStatementRecoveryUnitToString, String expectedDietPlusBodyUnitToString, String expectedDietPlusBodyWithStatementRecoveryUnitToString, String expectedFullUnitToString, String expectedFullWithStatementRecoveryUnitToString, String testName) {
        CompilationResult compilationResult;
        CompilationUnit sourceUnit;
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        CompilationUnitDeclaration computedUnit = parser.dietParse((ICompilationUnit)(sourceUnit = new CompilationUnit(source, testName, null)), compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0));
        String computedUnitToString = computedUnit.toString();
        if (!expectedDietPlusBodyWithStatementRecoveryUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest.assertEquals("Invalid unit diet+body structure with statement recovery enabled" + testName, expectedDietPlusBodyWithStatementRecoveryUnitToString, computedUnitToString);
    }

    public void test0001() {
        String expectedFullUnitToString;
        String expectedDietPlusBodyUnitToString;
        String expectedDietUnitToString;
        String s = "function foo() {\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function foo() {\n  System.out.println();\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = expectedDietPlusBodyUnitToString = "function foo() {\n  System.out.println();\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = expectedDietPlusBodyUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0002() {
        String expectedDietUnitToString;
        String s = " function foo() {\t\t\t\t\t\t\t\t\n    #                    \t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function foo() {\n  System.out.println();\n}\n";
        String expectedDietPlusBodyUnitToString = "function foo() {\n  System.out.println();\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "function foo() {\n  System.out.println();\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0002a() {
        String expectedDietUnitToString;
        String s = "    System.out.print1();\t\t\t\t\t\n    #                    \t\t\t\t\t\n    System.out.print2();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "System.out.print1();\nSystem.out.print2();\n";
        String expectedDietPlusBodyUnitToString = "  System.out.println();\n\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "System.out.print1();\nSystem.out.print2();\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0002b() {
        String expectedDietUnitToString;
        String s = "  foo = function () {\t\t\t\t\t\t\t\t\n    #                    \t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "foo = function () {\n  System.out.println();\n};\n";
        String expectedDietPlusBodyUnitToString = "foo = function () {\n  System.out.println();\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "foo = function () {\n  System.out.println();\n};\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0002c() {
        String expectedDietUnitToString;
        String s = "  obj ={\t\t\t\t\t\t\t\t\n   p1 : 2,\t\t\t\t\t\t\t\n meth: function () {\t\t\t\t\t\t\t\t\n    #                    \t\t\t\t\t\n    FOO();\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "obj = {\n  p1 : 2,\n  meth : function () {\n  FOO();\n}\n};\n";
        String expectedDietPlusBodyUnitToString = "obj = {\n  p1 : 2,\n  meth : function () {\n  FOO();\n}\n};\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "obj = {\n  p1 : 2,\n  meth : function () {\n  FOO();\n}\n};\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0003() {
        String expectedDietUnitToString;
        String s = "  function foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #                    \t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function foo() {\n  System.out.println();\n}\n";
        String expectedDietPlusBodyUnitToString = "function foo() {\n  System.out.println();\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "function foo() {\n  System.out.println();\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0003b() {
        String expectedDietUnitToString;
        String s = "  function foo1() {\t\t\t\t\t\t\t\t\n    var i;\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n  function foo2() {\t\t\t\t\t\t\t\t\n    #                    \t\t\t\t\t\n    a=1;\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n  function foo3() {\t\t\t\t\t\t\t\t\n    var k;\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function foo1() {\n}\nfunction foo2() {\n}\nfunction foo3() {\n}\n";
        String expectedDietPlusBodyUnitToString = "function foo1() {\n  var i;\n}\nfunction foo2() {\n  a = 1;\n}\nfunction foo3() {\n  var k;\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "function foo1() {\n  var i;\n}\nfunction foo2() {\n  a = 1;\n}\nfunction foo3() {\n  var k;\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0004() {
        String expectedDietUnitToString;
        String s = "  function foo() {\t\t\t\t\t\t\t\t\n    #                    \t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function foo() {\n  System.out.println();\n  System.out.println();\n}\n";
        String expectedDietPlusBodyUnitToString = "function foo() {\n  System.out.println();\n  System.out.println();\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "function foo() {\n  System.out.println();\n  System.out.println();\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0005() {
        String expectedDietUnitToString;
        String s = "  function foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #                    \t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function foo() {\n  System.out.println();\n  System.out.println();\n}\n";
        String expectedDietPlusBodyUnitToString = "function foo() {\n  System.out.println();\n  System.out.println();\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "function foo() {\n  System.out.println();\n  System.out.println();\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0006() {
        String expectedDietUnitToString;
        String s = "function foo() {\n    System.out.println();\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #                    \t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n}\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function foo() {\n  System.out.println();\n  System.out.println();\n  System.out.println();\n  System.out.println();\n}\n";
        String expectedDietPlusBodyUnitToString = "function foo() {\n  System.out.println();\n  System.out.println();\n  System.out.println();\n  System.out.println();\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "function foo() {\n  System.out.println();\n  System.out.println();\n  System.out.println();\n  System.out.println();\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0007() {
        String expectedDietUnitToString;
        String s = "function foo() {\n    #                    \t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    if(true) {\t\t\t\t\t\t\t\t\n      System.out.println();\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n}\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function foo() {\n  System.out.println();\n  if (true)\n      {\n        System.out.println();\n      }\n  System.out.println();\n}\n";
        String expectedDietPlusBodyUnitToString = "function foo() {\n  System.out.println();\n  if (true)\n      {\n        System.out.println();\n      }\n  System.out.println();\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "function foo() {\n  System.out.println();\n  if (true)\n      {\n        System.out.println();\n      }\n  System.out.println();\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0008() {
        String expectedDietUnitToString;
        String s = "function X() {\t\t\t\t\t\t\t\t\n  function foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    if(true) {\t\t\t\t\t\t\t\t\n      System.out.println();\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #                    \t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function X() {\n  function foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "function X() {\n  function foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "function X() {\n  function foo() {\n    System.out.println();\n    if (true)\n        {\n          System.out.println();\n        }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0009() {
        String expectedDietUnitToString;
        String s = "function X() {\t\t\t\t\t\t\t\t\n  function foo() {\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    if(true) {\t\t\t\t\t\t\t\t\n      System.out.println();\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    #                    \t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n    if(true) {\t\t\t\t\t\t\t\t\n      System.out.println();\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    System.out.println();\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function X() {\n  function foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "function X() {\n  function foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "function X() {\n  function foo() {\n    System.out.println();\n    if (true)\n        {\n          System.out.println();\n        }\n    System.out.println();\n    System.out.println();\n    if (true)\n        {\n          System.out.println();\n        }\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0010() {
        String expectedDietUnitToString;
        String s = "function X() {\t\t\t\t\t\t\t\t\n  function foo() {\t\t\t\t\t\t\t\t\n    bar(\\u0029\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function X() {\n  function foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "function X() {\n  function foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "function X() {\n  function foo() {\n    bar();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0011() {
        String expectedDietUnitToString;
        String s = "function X() {\t\t\t\t\t\t\t\t\n  function foo() {\t\t\t\t\t\t\t\t\n    if(true) {\t\t\t\t\t\t\t\t\n      foo();\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n    for(;\t\t\t\t\t\t\t\t\t\n    if(true) {\t\t\t\t\t\t\t\t\n      foo();\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function X() {\n  function foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "function X() {\n  function foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "function X() {\n}\nfunction foo() {\n  if (true)\n      {\n        foo();\n      }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0012() {
        String expectedDietUnitToString;
        String s = "function X() {\t\t\t\t\t\t\t\t\n  function foo() {\t\t\t\t\t\t\t\t\n    if() {\t\t\t\t\t\t\t\t\t\n      foo();\t\t\t\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function X() {\n  function foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "function X() {\n  function foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "function X() {\n  function foo() {\n    if ($missing$)\n        {\n          foo();\n        }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0013() {
        String expectedDietUnitToString;
        String s = "function X() {\t\t\t\t\t\t\t\t\n  function foo() {\t\t\t\t\t\t\t\t\n    for(var i\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "function X() {\n  function foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "function X() {\n  function foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "function X() {\n}\nfunction foo() {\n  var i;\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedFullWithStatementRecoveryUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }
}

