/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.state;

import junit.framework.TestCase;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomPackage;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingParameterStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingUse;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.state.ParameterPropertyStateAdapter;

public class ParameterPropertyStateAdapterTest
extends TestCase {
    private ParameterPropertyStateAdapter adapter;
    private IWebParam param;
    private IWebMethod method;
    private IServiceEndpointInterface sei;

    public void setUp() {
        this.sei = DomFactory.eINSTANCE.createIServiceEndpointInterface();
        this.method = DomFactory.eINSTANCE.createIWebMethod();
        this.method.setSoapBindingStyle(SOAPBindingStyle.DOCUMENT);
        this.method.setSoapBindingUse(SOAPBindingUse.LITERAL);
        this.method.setSoapBindingParameterStyle(SOAPBindingParameterStyle.WRAPPED);
        this.sei.getWebMethods().add((Object)this.method);
        this.param = DomFactory.eINSTANCE.createIWebParam();
        this.param.eSet((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__IMPLEMENTATION, (Object)"testParam");
        this.param.setName("testParam");
        this.method.getParameters().add((Object)this.param);
        this.adapter = new ParameterPropertyStateAdapter();
        this.adapter.setTarget((Notifier)this.param);
    }

    public void testIsChagebleNameCorrectSoapBinding() {
        ParameterPropertyStateAdapterTest.assertTrue((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
    }

    public void testIsChagebleNameIncorrectSoapBinding() {
        this.method.setSoapBindingStyle(SOAPBindingStyle.RPC);
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        this.method.setSoapBindingStyle(SOAPBindingStyle.DOCUMENT);
        this.method.setSoapBindingUse(SOAPBindingUse.ENCODED);
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        this.method.setSoapBindingUse(SOAPBindingUse.LITERAL);
        this.method.setSoapBindingParameterStyle(SOAPBindingParameterStyle.BARE);
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
    }

    public void testIsChagebleNameParamInHeader() {
        this.param.setHeader(true);
        this.method.setSoapBindingStyle(SOAPBindingStyle.RPC);
        ParameterPropertyStateAdapterTest.assertTrue((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        this.method.setSoapBindingStyle(SOAPBindingStyle.DOCUMENT);
        ParameterPropertyStateAdapterTest.assertTrue((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
    }

    public void testIsChagebleTargetNSCorrectSoapBinding() {
        ParameterPropertyStateAdapterTest.assertTrue((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TARGET_NAMESPACE));
    }

    public void testIsChagebleTargetNSIncorrectSoapBinding() {
        this.method.setSoapBindingStyle(SOAPBindingStyle.RPC);
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TARGET_NAMESPACE));
        this.method.setSoapBindingStyle(SOAPBindingStyle.DOCUMENT);
        this.method.setSoapBindingUse(SOAPBindingUse.ENCODED);
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TARGET_NAMESPACE));
        this.method.setSoapBindingUse(SOAPBindingUse.LITERAL);
        this.method.setSoapBindingParameterStyle(SOAPBindingParameterStyle.BARE);
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TARGET_NAMESPACE));
    }

    public void testIsChagebleTargetNSParamInHeader() {
        this.method.setSoapBindingStyle(SOAPBindingStyle.RPC);
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TARGET_NAMESPACE));
        this.param.setHeader(true);
        ParameterPropertyStateAdapterTest.assertTrue((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TARGET_NAMESPACE));
    }

    public void testIsChageblePartNameCorrectSoapBinding() {
        this.method.setSoapBindingStyle(SOAPBindingStyle.RPC);
        ParameterPropertyStateAdapterTest.assertTrue((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__PART_NAME));
    }

    public void testIsChageblePartNameIncorrectSoapBinding() {
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__PART_NAME));
        this.method.setSoapBindingStyle(SOAPBindingStyle.RPC);
        this.method.setSoapBindingUse(SOAPBindingUse.ENCODED);
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__PART_NAME));
        this.method.setSoapBindingUse(SOAPBindingUse.LITERAL);
        this.method.setSoapBindingParameterStyle(SOAPBindingParameterStyle.BARE);
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__PART_NAME));
    }

    public void testIsChagebleTargetNSHeader() {
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__HEADER));
        this.method.setSoapBindingStyle(SOAPBindingStyle.RPC);
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__HEADER));
    }

    public void testReturnParamNotEditable() {
        this.param.eSet((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__IMPLEMENTATION, (Object)"return");
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__PART_NAME));
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TARGET_NAMESPACE));
        this.method.setSoapBindingStyle(SOAPBindingStyle.RPC);
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__PART_NAME));
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TARGET_NAMESPACE));
    }

    public void testOutsideInWebService() {
        IWebService ws = DomFactory.eINSTANCE.createIWebService();
        ws.setWsdlLocation("C:/test/wsdl/location");
        this.sei.getImplementingWebServices().add((Object)ws);
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__PART_NAME));
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TARGET_NAMESPACE));
        this.method.setSoapBindingStyle(SOAPBindingStyle.RPC);
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__NAME));
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__PART_NAME));
        ParameterPropertyStateAdapterTest.assertFalse((boolean)this.adapter.isChangeable((EStructuralFeature)DomPackage.Literals.IWEB_PARAM__TARGET_NAMESPACE));
    }
}

