/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.testutils.project;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ws.jaxws.testutils.jobs.JobUtils;
import org.eclipse.jst.ws.jaxws.testutils.threading.TestContext;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class TestProjectsUtils {
    public static String readSource(Class<?> classContext, String filePath) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(classContext.getResourceAsStream(filePath));){
            StringBuffer sb = new StringBuffer();
            char[] buff = new char[512];
            int len = 0;
            while ((len = isr.read(buff)) > 0) {
                sb.append(String.valueOf(buff, 0, len));
            }
            String string = sb.toString();
            return string;
        }
    }

    public static void waitForIndexer() throws JavaModelException {
        new SearchEngine().searchAllTypeNames(null, 0, null, 8, 5, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[0]), new TypeNameRequestor(){

            public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            }

            public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            }
        }, 3, null);
    }

    public static IProject createJavaProject(String projectName) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        project.create(null);
        project.open(null);
        JobUtils.waitForIndexer();
        IProjectDescription description = project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        project.setDescription(description, null);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        TestProjectsUtils.addToClasspath(javaProject, JavaRuntime.getDefaultJREContainerEntry());
        String[] stringArray = new String[]{"javax.jws", "javax.xml.ws"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleName = stringArray[n2];
            Bundle bundle = Platform.getBundle((String)bundleName);
            Assert.assertNotNull((String)("The " + bundleName + " bundle was not found"), (Object)bundle);
            IPath absoluteLocation = null;
            String location = bundle.getLocation();
            if (location.indexOf("reference:file:") >= 0) {
                location = location.substring(location.indexOf("reference:file:") + "reference:file:".length());
            }
            if (!((absoluteLocation = Path.fromOSString((String)location).makeAbsolute()).toFile().exists() || (absoluteLocation = Path.fromOSString((String)System.getProperty("user.dir")).addTrailingSeparator().append(location)).toFile().exists() || (absoluteLocation = Path.fromOSString((String)System.getProperty("user.home")).addTrailingSeparator().append(location)).toFile().exists())) {
                absoluteLocation = Path.fromOSString((String)Platform.getInstallLocation().getURL().getFile().toString()).addTrailingSeparator().append(location);
            }
            Assert.assertTrue((String)("Expected jar at " + absoluteLocation + " does not exist based on bundle location " + bundle.getLocation() + " from " + System.getProperty("user.dir")), (boolean)absoluteLocation.toFile().exists());
            TestProjectsUtils.addToClasspath(javaProject, JavaCore.newLibraryEntry((IPath)absoluteLocation, null, null));
            ++n2;
        }
        return project;
    }

    private static void addToClasspath(IJavaProject javaProject, IClasspathEntry cpEntry) throws JavaModelException {
        IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = cpEntry;
        javaProject.setRawClasspath(newEntries, null);
    }

    public static IPackageFragmentRoot getSourceFolder(IProject project, String folderName) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getElementName().equals(folderName)) {
                return root;
            }
            ++n2;
        }
        return null;
    }

    public static IPackageFragmentRoot createSourceFolder(IProject project, String folderName) throws CoreException {
        if (TestProjectsUtils.getSourceFolder(project, folderName) != null) {
            throw new IllegalStateException("Source folder already exists: " + folderName);
        }
        IFolder srcFolder = project.getFolder(folderName);
        srcFolder.create(true, true, null);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry srcCpEntry = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath().makeAbsolute());
        IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[newEntries.length - 1] = srcCpEntry;
        javaProject.setRawClasspath(newEntries, null);
        return TestProjectsUtils.getSourceFolder(project, folderName);
    }

    public static File importFileIntoProject(Class<?> classContext, String relativeSrcFileLocation, IContainer targetResource, String targetFileName) throws IOException {
        String src = TestProjectsUtils.readSource(classContext, relativeSrcFileLocation);
        File f = new File(String.valueOf(targetResource.getLocation().toOSString()) + "\\" + targetFileName);
        if (f.exists()) {
            throw new IllegalStateException("File already exists: " + f.getAbsolutePath());
        }
        if (f.isDirectory()) {
            throw new IllegalStateException(String.valueOf(f.getAbsolutePath()) + " is a directory");
        }
        if (f.createNewFile()) {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));
            out.write(src);
            out.flush();
            out.close();
        }
        return f;
    }

    public static void deleteWorkspaceProjects() throws JavaModelException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        JobUtils.waitForJobs();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                project.delete(false, (IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                new Logger().logError(e.getMessage());
            }
            JobUtils.waitForJobs();
            ++n2;
        }
    }

    public static IProject createEjb3Project(String projectName) throws CoreException {
        IProject ejbProject = TestProjectsUtils.createProjectWithFacet(projectName, new String[]{"jst.java", "jst.ejb"}, new String[]{"5.0", "3.0"});
        IJavaProject javaP = JavaCore.create((IProject)ejbProject);
        TestProjectsUtils.removeAllSourceFolders(javaP);
        IFolder srcFolder = ejbProject.getFolder("ejbModule");
        IClasspathEntry ejbModuleCpEntry = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath().makeAbsolute());
        TestProjectsUtils.addToClasspath(JavaCore.create((IProject)ejbProject), ejbModuleCpEntry);
        return ejbProject;
    }

    private static void removeAllSourceFolders(IJavaProject javaP) throws JavaModelException {
        ArrayList<IClasspathEntry> newClasspath = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = javaP.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpEntry = iClasspathEntryArray[n2];
            if (cpEntry.getEntryKind() != 3) {
                newClasspath.add(cpEntry);
            }
            ++n2;
        }
        javaP.setRawClasspath(newClasspath.toArray(new IClasspathEntry[newClasspath.size()]), (IProgressMonitor)new NullProgressMonitor());
    }

    private static IProject createProjectWithFacet(final String projectName, final String[] facetId, final String[] facetVersion) throws CoreException {
        assert (facetId.length == facetVersion.length);
        final IProject[] result = new IProject[1];
        try {
            TestContext.run(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        result[0] = TestProjectsUtils.createJavaProject(projectName);
                        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)result[0], (boolean)true, (IProgressMonitor)new NullProgressMonitor());
                        int i = 0;
                        while (i < facetId.length) {
                            IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetId[i]);
                            facetedProject.installProjectFacet(facet.getVersion(facetVersion[i]), null, monitor);
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, true, (IProgressMonitor)new NullProgressMonitor(), PlatformUI.getWorkbench().getDisplay());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return result[0];
    }

    public static IProject createWeb25Project(String projectName) throws CoreException {
        IProject webProject = TestProjectsUtils.createProjectWithFacet(projectName, new String[]{"jst.java", "jst.web"}, new String[]{"5.0", "2.5"});
        IJavaProject javaP = JavaCore.create((IProject)webProject);
        TestProjectsUtils.removeAllSourceFolders(javaP);
        return webProject;
    }

    public static void executeWorkspaceRunnable(IWorkspaceRunnable runnable) throws CoreException {
        TestProjectsUtils.executeWorkspaceRunnable(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    private static void executeWorkspaceRunnable(IWorkspaceRunnable runnable, IProgressMonitor monitor) throws CoreException {
        TestProjectsUtils.workspace().run(runnable, monitor);
    }

    private static void runInTestContext(final IWorkspaceRunnable runnable, IProgressMonitor pm) throws CoreException {
        IRunnableWithProgress textCtxRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    TestProjectsUtils.executeWorkspaceRunnable(runnable, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            textCtxRunnable.run(pm);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            throw new IllegalStateException("Unexected exception thrown by runnable", e.getCause());
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("Interruption is not supported");
        }
    }

    private static IWorkspace workspace() {
        return ResourcesPlugin.getWorkspace();
    }
}

