/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.tests.model.ContainerInitializer;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.model.VariablesInitializer;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.UserLibraryJsGlobalScopeContainer;

public class ClasspathInitializerTests
extends ModifyingResourceTests {
    public ClasspathInitializerTests(String name) {
        super(name);
    }

    public static Test suite() {
        return ClasspathInitializerTests.buildModelTestSuite(ClasspathInitializerTests.class);
    }

    @Override
    protected void tearDown() throws Exception {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        manager.containers = new HashMap(5);
        manager.variables = new HashMap(5);
        super.tearDown();
    }

    public void testContainerInitializer01() throws CoreException {
        try {
            this.createProject("P1");
            this.createFile("/P1/lib.jar", "");
            ContainerInitializer.setInitializer(new DefaultContainerInitializer(new String[]{"P2", "/P1/lib.jar"}));
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            IPackageFragmentRoot root = p2.getPackageFragmentRoot((IResource)this.getFile("/P1/lib.jar"));
            ClasspathInitializerTests.assertTrue((String)"/P1/lib.jar should exist", (boolean)root.exists());
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testContainerInitializer02() throws CoreException {
        try {
            this.createProject("P1");
            this.createFile("/P1/lib.jar", "");
            ContainerInitializer.setInitializer(new DefaultContainerInitializer(new String[]{"P2", "/P1/lib.jar"}));
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            this.simulateExitRestart();
            this.startDeltas();
            p2.getResolvedIncludepath(true);
            this.assertDeltas("Unexpected delta on startup", "");
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testContainerInitializer03() throws CoreException {
        try {
            this.createProject("P1");
            this.createFile("/P1/lib.jar", "");
            ContainerInitializer.setInitializer(new DefaultContainerInitializer(new String[]{"P2", "/P1/lib.jar"}));
            this.createJavaProject("P2", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            this.createFile("/P1/lib2.jar", "");
            ContainerInitializer.setInitializer(new DefaultContainerInitializer(new String[]{"P2", "/P1/lib2.jar"}));
            this.simulateExitRestart();
            this.startDeltas();
            this.getJavaProject("P2").getResolvedIncludepath(true);
            this.assertDeltas("Unexpected delta on startup", "P2[*]: {CHILDREN}\n\t/P1/lib.jar[*]: {REMOVED FROM CLASSPATH}\n\t/P1/lib2.jar[*]: {ADDED TO CLASSPATH}");
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testContainerInitializer04() throws CoreException {
        try {
            this.createProject("P1");
            this.createFile("/P1/lib.jar", "");
            DefaultContainerInitializer initializer = new DefaultContainerInitializer(new String[]{"P2", "/P1/lib.jar"});
            ContainerInitializer.setInitializer(initializer);
            this.createJavaProject("P2", new String[]{""}, new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            this.simulateExitRestart();
            this.startDeltas();
            this.createFile("/P2/X.js", "public class X {}");
            ClasspathInitializerTests.assertEquals((String)"Should not get exception", null, (Object)((Object)initializer.exception));
            this.assertDeltas("Unexpected delta on startup", "P2[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[+]: {}");
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testContainerInitializer05() throws CoreException {
        try {
            try {
                NullContainerInitializer nullInitializer = new NullContainerInitializer();
                ContainerInitializer.setInitializer(nullInitializer);
                this.createJavaProject("P1", new String[]{""}, new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
                this.simulateExitRestart();
                this.startDeltas();
                this.createFile("/P1/X.js", "public class X {}");
                this.assertDeltas("Unexpected delta on startup", "P1[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.java[+]: {}");
                ClasspathInitializerTests.assertTrue((String)"initializer did not run", (boolean)nullInitializer.hasRun);
                ClasspathInitializerTests.waitForAutoBuild();
                nullInitializer.hasRun = false;
                this.getJavaProject("P1").getResolvedIncludepath(true);
                ClasspathInitializerTests.assertTrue((String)"initializer did not run", (boolean)nullInitializer.hasRun);
                ClasspathInitializerTests.waitForAutoBuild();
                this.createFile("/P1/lib.jar", "");
                ContainerInitializer.setInitializer(new DefaultContainerInitializer(new String[]{"P1", "/P1/lib.jar"}));
                this.clearDeltas();
                this.getJavaProject("P1").getResolvedIncludepath(true);
                this.assertDeltas("Unexpected delta after setting container", "P1[*]: {CHILDREN}\n\tlib.jar[*]: {ADDED TO CLASSPATH}");
            }
            catch (StackOverflowError e) {
                e.printStackTrace();
                ClasspathInitializerTests.assertTrue((String)"stack overflow assigning container", (boolean)false);
                this.stopDeltas();
                this.deleteProject("P1");
            }
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
        }
    }

    public void testContainerInitializer06() throws CoreException {
        IJavaScriptUnit workingCopy = null;
        try {
            this.createProject("P1");
            ContainerInitializer.setInitializer(new DefaultContainerInitializer(new String[]{"P2", ""}));
            this.createJavaProject("P2", new String[]{"src"}, new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            this.createFile("/P2/src/X,java", "public class X {\n}");
            ContainerInitializer.setInitializer(new DefaultContainerInitializer(new String[]{"P2", "/P1"}));
            this.simulateExitRestart();
            this.startDeltas();
            workingCopy = this.getCompilationUnit("/P2/src/X.js");
            workingCopy.becomeWorkingCopy(null);
            this.assertDeltas("Unexpected delta on startup", "P2[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\t[Working copy] X.java[+]: {PRIMARY WORKING COPY}");
        }
        finally {
            this.stopDeltas();
            if (workingCopy != null) {
                workingCopy.discardWorkingCopy();
            }
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testContainerInitializer07() throws CoreException {
        try {
            boolean gotException = false;
            try {
                ContainerInitializer.setInitializer(new DefaultContainerInitializer(new String[]{"P1", "/P1/lib.jar"}){

                    @Override
                    public void initialize(IPath containerPath, IJavaScriptProject project) throws CoreException {
                        throw new OperationCanceledException("test");
                    }
                });
                IJavaScriptProject p1 = this.createJavaProject("P1", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
                p1.getResolvedIncludepath(true);
            }
            catch (OperationCanceledException operationCanceledException) {
                gotException = true;
            }
            ClasspathInitializerTests.assertTrue((String)"Should get an OperationCanceledException", (boolean)gotException);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
        }
    }

    public void testContainerInitializer08() throws CoreException {
        final String[] projects = new String[10];
        int i = 0;
        while (i < 10) {
            projects[i] = "P" + i;
            ++i;
        }
        try {
            String[] projectRefs = new String[18];
            int i2 = 0;
            while (i2 < 9) {
                projectRefs[i2 * 2] = "P" + i2;
                projectRefs[i2 * 2 + 1] = "/P" + i2 + "/test.jar";
                ++i2;
            }
            ContainerInitializer.setInitializer(new DefaultContainerInitializer(projectRefs){

                void foo(int n) {
                    if (n > 0) {
                        this.foo(n - 1);
                        return;
                    }
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    int i = 0;
                    while (i < 9) {
                        try {
                            JavaScriptCore.create((IProject)root.getProject(projects[i])).getResolvedIncludepath(true);
                        }
                        catch (JavaScriptModelException javaScriptModelException) {}
                        ++i;
                    }
                }

                @Override
                public void initialize(IPath containerPath, IJavaScriptProject project) throws CoreException {
                    this.foo(500);
                    super.initialize(containerPath, project);
                }
            });
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int i = 0;
                    while (i < 10) {
                        ClasspathInitializerTests.this.createProject(projects[i]);
                        ClasspathInitializerTests.this.editFile("/" + projects[i] + "/.project", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>" + projects[i] + "</name>\n" + "\t<comment></comment>\n" + "\t<projects>\n" + (i == 0 ? "" : "<project>" + projects[i - 1] + "</project>\n") + "\t</projects>\n" + "\t<buildSpec>\n" + "\t\t<buildCommand>\n" + "\t\t\t<name>org.eclipse.wst.jsdt.core.javabuilder</name>\n" + "\t\t\t<arguments>\n" + "\t\t\t</arguments>\n" + "\t\t</buildCommand>\n" + "\t</buildSpec>\n" + "\t<natures>\n" + "\t\t<nature>org.eclipse.wst.jsdt.core.javanature</nature>\n" + "\t</natures>\n" + "</projectDescription>");
                        ClasspathInitializerTests.this.createFile("/" + projects[i] + "/.classpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n" + (i == 0 ? "" : "<classpathentry kind=\"src\" path=\"/" + projects[i - 1] + "\"/>\n") + "\t<classpathentry kind=\"con\" path=\"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER\"/>\n" + "\t<classpathentry kind=\"output\" path=\"\"/>\n" + "</classpath>");
                        ++i;
                    }
                }
            }, null);
            this.getJavaProject("P0").getResolvedIncludepath(true);
        }
        finally {
            this.stopDeltas();
            this.deleteProjects(projects);
        }
    }

    public void testContainerInitializer09() throws CoreException {
        try {
            DefaultContainerInitializer initializer = new DefaultContainerInitializer(new String[]{"P1", "/P1/lib.jar"}){

                @Override
                protected DefaultContainerInitializer.DefaultContainer newContainer(char[][] libPaths) {
                    return new DefaultContainerInitializer.DefaultContainer(libPaths){

                        @Override
                        public IIncludePathEntry[] getClasspathEntries() {
                            return this.getIncludepathEntries();
                        }

                        @Override
                        public IIncludePathEntry[] getIncludepathEntries() {
                            try {
                                ClasspathInitializerTests.this.getJavaProject("P1").getResolvedIncludepath(true);
                            }
                            catch (JavaScriptModelException javaScriptModelException) {}
                            return super.getIncludepathEntries();
                        }
                    };
                }
            };
            ContainerInitializer.setInitializer(initializer);
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ClasspathInitializerTests.this.createProject("P1");
                    ClasspathInitializerTests.this.editFile("/P1/.project", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>P1</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.wst.jsdt.core.javabuilder</name>\n\t\t\t<arguments>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t\t<nature>org.eclipse.wst.jsdt.core.javanature</nature>\n\t</natures>\n</projectDescription>");
                    ClasspathInitializerTests.this.createFile("/P1/.classpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"con\" path=\"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER\"/>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>");
                }
            }, null);
            this.getJavaProject("P1").getResolvedIncludepath(true);
        }
        finally {
            this.stopDeltas();
            ContainerInitializer.setInitializer(null);
            this.deleteProject("P1");
        }
    }

    public void testContainerInitializer10() throws CoreException {
        class LogListener
        implements ILogListener {
            IStatus log;

            LogListener() {
            }

            public void logging(IStatus status, String plugin) {
                this.log = status;
            }
        }
        LogListener listener = new LogListener();
        try {
            Platform.addLogListener((ILogListener)listener);
            final IJavaScriptProject p1 = this.createJavaProject("P1");
            final IJavaScriptProject p2 = this.createJavaProject("P2");
            ContainerInitializer.setInitializer(new DefaultContainerInitializer(new String[]{"P3", "/P1"}){

                @Override
                public void initialize(IPath containerPath, IJavaScriptProject project) throws CoreException {
                    super.initialize(containerPath, project);
                    ClasspathInitializerTests.this.getJavaModel().refreshExternalArchives(new IJavaScriptElement[]{p1}, null);
                }
            });
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    p2.setRawIncludepath(new IIncludePathEntry[]{JavaScriptCore.newSourceEntry((IPath)new Path("/P2/src"))}, null);
                    ClasspathInitializerTests.this.createProject("P3");
                    ClasspathInitializerTests.this.editFile("/P3/.project", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>P3</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.wst.jsdt.core.javabuilder</name>\n\t\t\t<arguments>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t\t<nature>org.eclipse.wst.jsdt.core.javanature</nature>\n\t</natures>\n</projectDescription>\n");
                    ClasspathInitializerTests.this.createFile("/P3/.classpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"src\" path=\"\"/>\n\t<classpathentry kind=\"var\" path=\"JCL_LIB\"/>\n\t<classpathentry kind=\"con\" path=\"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER\"/>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>");
                }
            }, null);
            ClasspathInitializerTests.assertEquals((String)"Should not get any exception in log", null, (Object)listener.log);
        }
        finally {
            Platform.removeLogListener((ILogListener)listener);
            this.deleteProject("P1");
            this.deleteProject("P2");
            this.deleteProject("P3");
        }
    }

    public void testContainerInitializer11() throws CoreException {
        boolean hasExited = false;
        try {
            ContainerInitializer.setInitializer(null);
            this.createJavaProject("P", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            this.simulateExitRestart();
            DefaultContainerInitializer initializer = new DefaultContainerInitializer(new String[0]){

                @Override
                public void initialize(IPath containerPath, IJavaScriptProject project) throws CoreException {
                    ClasspathInitializerTests.assertTrue((String)"Should not initialize container on shutdown", (boolean)false);
                }
            };
            ContainerInitializer.setInitializer(initializer);
            this.simulateExit();
            hasExited = true;
        }
        finally {
            ContainerInitializer.setInitializer(null);
            if (hasExited) {
                this.simulateRestart();
            }
            this.deleteProject("P");
        }
    }

    public void testContainerInitializer12() throws CoreException {
        try {
            ContainerInitializer.setInitializer(new DefaultContainerInitializer(new String[]{"P1", "/P1/lib.jar"}));
            IJavaScriptProject project = this.createJavaProject("P1", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            this.createFile("/P1/lib.jar", "");
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)this.getFile("/P1/lib.jar"));
            ClasspathInitializerTests.assertTrue((String)"/P1/lib.jar should exist", (boolean)root.exists());
            this.deleteProject("P1");
            class Initializer
            extends DefaultContainerInitializer {
                boolean initialized;

                public Initializer(String[] args) {
                    super(args);
                }

                @Override
                public void initialize(IPath containerPath, IJavaScriptProject p) throws CoreException {
                    super.initialize(containerPath, p);
                    this.initialized = true;
                }
            }
            Initializer initializer = new Initializer(new String[]{"P1", "/P1/lib.jar"});
            ContainerInitializer.setInitializer(initializer);
            this.createJavaProject("P1", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            this.createFile("/P1/lib.jar", "");
            ClasspathInitializerTests.assertTrue((String)"/P1/lib.jar should exist", (boolean)root.exists());
            ClasspathInitializerTests.assertTrue((String)"Should have been initialized", (boolean)initializer.initialized);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
        }
    }

    public void testContainerInitializer13() throws CoreException {
        IResourceChangeListener listener = new IResourceChangeListener(){
            StringBuffer buffer = new StringBuffer();

            public void resourceChanged(IResourceChangeEvent event) {
                this.buffer.append(event.getDelta().findMember((IPath)new Path("/P1")));
            }

            public String toString() {
                return this.buffer.toString();
            }
        };
        try {
            NullContainerInitializer nullInitializer = new NullContainerInitializer();
            ContainerInitializer.setInitializer(nullInitializer);
            IJavaScriptProject project = this.createJavaProject("P1", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            this.simulateExitRestart();
            this.getWorkspace().addResourceChangeListener(listener, 1);
            project.findPackageFragmentRoots(project.getRawIncludepath()[0]);
            ClasspathInitializerTests.assertEquals((String)"Unexpected resource delta on startup", (String)"", (String)listener.toString());
        }
        finally {
            this.getWorkspace().removeResourceChangeListener(listener);
            this.deleteProject("P1");
        }
    }

    public void testContainerInitializer14() throws CoreException {
        try {
            this.createProject("P1");
            this.createFile("/P1/lib.jar", "");
            class Container
            extends DefaultContainerInitializer {
                int initializeCount;

                Container(String[] values) {
                    super(values);
                    this.initializeCount = 0;
                }

                @Override
                public void initialize(IPath containerPath, IJavaScriptProject project) throws CoreException {
                    ++this.initializeCount;
                    super.initialize(containerPath, ClasspathInitializerTests.this.getJavaProject("P1"));
                }
            }
            Container container = new Container(new String[]{"P2", "/P1/lib.jar"});
            ContainerInitializer.setInitializer(container);
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            p2.getResolvedIncludepath(true);
            ClasspathInitializerTests.assertEquals((String)"Unexpected number of initalizations", (int)1, (int)container.initializeCount);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testContainerInitializer15() throws CoreException {
        try {
            class Container
            extends DefaultContainerInitializer {
                Container(String[] values) {
                    super(values);
                }

                @Override
                public void initialize(IPath containerPath, IJavaScriptProject project) throws CoreException {
                }
            }
            Container container = new Container(new String[]{"P1", "/P1/lib.jar"});
            ContainerInitializer.setInitializer(container);
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            IJsGlobalScopeContainer JsGlobalScopeContainer = JavaScriptCore.getJsGlobalScopeContainer((IPath)new Path("org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"), (IJavaScriptProject)p1);
            this.assertClasspathEquals(JsGlobalScopeContainer.getIncludepathEntries(), "");
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
        }
    }

    public void testContainerInitializer16() throws CoreException {
        try {
            ContainerInitializer.setInitializer(new DefaultContainerInitializer(new String[]{"P1", "/P1"}));
            JavaScriptModelException exception = null;
            try {
                IJavaScriptProject p1 = this.createJavaProject("P1", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
                p1.getResolvedIncludepath(true);
            }
            catch (JavaScriptModelException e) {
                exception = e;
            }
            this.assertExceptionEquals("Unexpected expection", "Project cannot reference itself: P1", exception);
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
        }
    }

    public void testVariableInitializer01() throws CoreException {
        try {
            this.createProject("P1");
            this.createFile("/P1/lib.jar", "");
            VariablesInitializer.setInitializer(new DefaultVariableInitializer(new String[]{"TEST_LIB", "/P1/lib.jar"}));
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[0], new String[]{"TEST_LIB"});
            IPackageFragmentRoot root = p2.getPackageFragmentRoot((IResource)this.getFile("/P1/lib.jar"));
            ClasspathInitializerTests.assertTrue((String)"/P1/lib.jar should exist", (boolean)root.exists());
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
            VariablesInitializer.reset();
        }
    }

    public void testVariableInitializer02() throws CoreException {
        try {
            this.createProject("P1");
            this.createFile("/P1/lib.jar", "");
            this.createFile("/P1/src.zip", "");
            VariablesInitializer.setInitializer(new DefaultVariableInitializer(new String[]{"TEST_LIB", "/P1/lib.jar", "TEST_SRC", "/P1/src.zip", "TEST_ROOT", "src"}));
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[0], new String[]{"TEST_LIB,TEST_SRC,TEST_ROOT"});
            IPackageFragmentRoot root = p2.getPackageFragmentRoot((IResource)this.getFile("/P1/lib.jar"));
            ClasspathInitializerTests.assertEquals((String)"Unexpected source attachment path", (String)"/P1/src.zip", (String)root.getSourceAttachmentPath().toString());
            ClasspathInitializerTests.assertEquals((String)"Unexpected source attachment root path", (String)"src", (String)root.getSourceAttachmentRootPath().toString());
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
            VariablesInitializer.reset();
        }
    }

    public void testVariableInitializer03() throws CoreException {
        try {
            this.createProject("P1");
            this.createFile("/P1/lib.jar", "");
            this.createFile("/P1/src.zip", "");
            String[] variableValues = new String[]{"TEST_LIB", "/P1/lib.jar", "TEST_SRC", "/P1/src.zip", "TEST_ROOT", "src"};
            VariablesInitializer.setInitializer(new DefaultVariableInitializer(variableValues));
            this.createJavaProject("P2", new String[0], new String[]{"TEST_LIB,TEST_SRC,TEST_ROOT"});
            this.simulateExitRestart();
            this.startDeltas();
            this.getJavaProject("P2").getResolvedIncludepath(true);
            this.assertDeltas("Unexpected delta on startup", "");
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
            VariablesInitializer.reset();
        }
    }

    public void testVariableInitializer04() throws CoreException {
        try {
            final StringBuffer buffer = new StringBuffer();
            VariablesInitializer.setInitializer(new VariablesInitializer.ITestInitializer(){

                @Override
                public void initialize(String variable) throws JavaScriptModelException {
                    buffer.append("Initializing " + variable + "\n");
                    Path path = new Path(variable.toLowerCase());
                    buffer.append("Setting variable " + variable + " to " + path + "\n");
                    JavaScriptCore.setIncludepathVariable((String)variable, (IPath)path, null);
                }
            });
            this.createJavaProject("P", new String[0], new String[]{"TEST_LIB,TEST_SRC,TEST_ROOT"});
            ClasspathInitializerTests.assertEquals((String)"Initializing TEST_LIB\nSetting variable TEST_LIB to test_lib\n", (String)buffer.toString());
        }
        finally {
            this.deleteProject("P");
            VariablesInitializer.reset();
        }
    }

    public void testVariableInitializer05() throws CoreException {
        try {
            final StringBuffer buffer = new StringBuffer();
            VariablesInitializer.setInitializer(new VariablesInitializer.ITestInitializer(){

                @Override
                public void initialize(String variable) throws JavaScriptModelException {
                    buffer.append("Initializing " + variable + "\n");
                    Path path = new Path(variable.toLowerCase());
                    JavaScriptCore.getIncludepathVariable((String)"TEST_SRC");
                    buffer.append("Setting variable " + variable + " to " + path + "\n");
                    JavaScriptCore.setIncludepathVariable((String)variable, (IPath)path, null);
                }
            });
            this.createJavaProject("P", new String[0], new String[]{"TEST_LIB,TEST_SRC,TEST_ROOT"});
            ClasspathInitializerTests.assertEquals((String)"Initializing TEST_LIB\nInitializing TEST_SRC\nSetting variable TEST_SRC to test_src\nSetting variable TEST_LIB to test_lib\n", (String)buffer.toString());
        }
        finally {
            this.deleteProject("P");
            VariablesInitializer.reset();
        }
    }

    public void testVariableInitializer06() throws CoreException {
        try {
            final StringBuffer buffer = new StringBuffer();
            VariablesInitializer.setInitializer(new VariablesInitializer.ITestInitializer(){

                @Override
                public void initialize(String variable) {
                    buffer.append("Ignoring request to initialize");
                }
            });
            IPath path = JavaScriptCore.getIncludepathVariable((String)"TEST_SRC");
            ClasspathInitializerTests.assertEquals((String)"Unexpected value of TEST_SRC after initializer was called", null, (Object)path);
            Path varValue = new Path("src.zip");
            JavaScriptCore.setIncludepathVariable((String)"TEST_SRC", (IPath)varValue, null);
            path = JavaScriptCore.getIncludepathVariable((String)"TEST_SRC");
            ClasspathInitializerTests.assertEquals((String)"Unexpected value of TEST_SRC after setting it", (Object)varValue, (Object)path);
        }
        finally {
            VariablesInitializer.reset();
        }
    }

    public void testVariableInitializer07() throws CoreException {
        try {
            this.createProject("P1");
            this.createFile("/P1/lib.jar", "");
            this.createFile("/P1/src.zip", "");
            String[] variableValues = new String[]{"TEST_LIB", "/P1/lib.jar", "TEST_SRC", "/P1/src.zip", "TEST_ROOT", "src"};
            VariablesInitializer.setInitializer(new DefaultVariableInitializer(variableValues));
            this.createJavaProject("P2", new String[0], new String[]{"TEST_LIB,TEST_SRC,TEST_ROOT"});
            this.createFile("/P1/lib2.jar", "");
            VariablesInitializer.setInitializer(new DefaultVariableInitializer(new String[]{"TEST_LIB", "/P1/lib2.jar", "TEST_SRC", "/P1/src.zip", "TEST_ROOT", "src"}));
            this.simulateExitRestart();
            this.startDeltas();
            this.getJavaProject("P2").getResolvedIncludepath(true);
            this.assertDeltas("Unexpected delta on startup", "P2[*]: {CHILDREN}\n\t/P1/lib.jar[*]: {REMOVED FROM CLASSPATH}\n\t/P1/lib2.jar[*]: {ADDED TO CLASSPATH}");
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P1");
            this.deleteProject("P2");
            VariablesInitializer.reset();
        }
    }

    public void testVariableInitializer08() throws CoreException {
        try {
            boolean gotException = false;
            try {
                VariablesInitializer.setInitializer(new DefaultVariableInitializer(new String[]{"TEST_LIB", "/P1/lib.jar"}){

                    @Override
                    public void initialize(String variable) throws JavaScriptModelException {
                        throw new OperationCanceledException("test");
                    }
                });
                IJavaScriptProject p1 = this.createJavaProject("P1", new String[0], new String[]{"TEST_LIB"});
                p1.getResolvedIncludepath(true);
            }
            catch (OperationCanceledException operationCanceledException) {
                gotException = true;
            }
            ClasspathInitializerTests.assertTrue((String)"Should get an OperationCanceledException", (boolean)gotException);
        }
        finally {
            this.deleteProject("P1");
            VariablesInitializer.reset();
        }
    }

    public void testVariableInitializer09() throws CoreException {
        try {
            VariablesInitializer.setInitializer(new DefaultVariableInitializer(new String[]{"TEST_LIB", "/P1/lib.jar"}){

                @Override
                public void initialize(String variable) throws JavaScriptModelException {
                    JavaScriptCore.removeIncludepathVariable((String)"TEST_LIB", null);
                }
            });
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[0], new String[]{"TEST_LIB"});
            IIncludePathEntry[] resolvedClasspath = p1.getResolvedIncludepath(true);
            this.assertClasspathEquals(resolvedClasspath, "");
        }
        finally {
            this.deleteProject("P1");
            VariablesInitializer.reset();
        }
    }

    public void testVariableInitializer10() throws CoreException {
        try {
            VariablesInitializer.setInitializer(new DefaultVariableInitializer(new String[]{"TEST_LIB", "/P1/lib.jar"}){

                @Override
                public void initialize(String variable) throws JavaScriptModelException {
                }
            });
            JavaScriptCore.getIncludepathVariable((String)"TEST_LIB");
            ClasspathInitializerTests.assertEquals((String)"TEST_LIB should be null", null, (Object)JavaScriptCore.getIncludepathVariable((String)"TEST_LIB"));
        }
        finally {
            this.deleteProject("P1");
            VariablesInitializer.reset();
        }
    }

    public void testVariableInitializer11() throws CoreException {
        try {
            String varName = "TEST_LIB";
            String initialValue = "/P1/lib.jar";
            String newValue = "/tmp/file.jar";
            VariablesInitializer.setInitializer(new DefaultVariableInitializer(new String[]{varName, initialValue}));
            ClasspathInitializerTests.assertEquals((String)"JavaScriptCore classpath value should have been initialized", (String)JavaScriptCore.getIncludepathVariable((String)varName).toString(), (String)initialValue);
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            IEclipsePreferences preferences = manager.getInstancePreferences();
            preferences.put("org.eclipse.wst.jsdt.core.classpathVariable." + varName, newValue);
            ClasspathInitializerTests.assertEquals((String)"JavaScriptCore classpath value should be unchanged", (String)JavaScriptCore.getIncludepathVariable((String)varName).toString(), (String)initialValue);
            ClasspathInitializerTests.assertEquals((String)"JavaScriptCore preferences value should be unchanged", (String)preferences.get(varName, "X"), (String)initialValue);
        }
        finally {
            VariablesInitializer.reset();
        }
    }

    public void testVariableInitializerDeprecated() throws CoreException {
        try {
            String varName = "TEST_DEPRECATED";
            String filePath = "/P1/lib.jar";
            VariablesInitializer.setInitializer(new DefaultVariableInitializer(new String[]{varName, filePath}));
            ClasspathInitializerTests.assertEquals((String)"JavaScriptCore classpath value should have been initialized", (String)JavaScriptCore.getIncludepathVariable((String)varName).toString(), (String)filePath);
            ClasspathInitializerTests.assertEquals((String)"JavaScriptCore classpath variable should be deprecated", (String)"Test deprecated flag", (String)JavaScriptCore.getIncludepathVariableDeprecationMessage((String)varName));
            IJavaScriptProject project = this.createJavaProject("P1");
            this.createFile("/P1/lib.jar", "");
            IIncludePathEntry variable = JavaScriptCore.newVariableEntry((IPath)new Path("TEST_DEPRECATED"), null, null);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspathEntry((IJavaScriptProject)project, (IIncludePathEntry)variable, (boolean)false);
            this.assertStatus("Classpath variable 'TEST_DEPRECATED' in project P1 is deprecated: 'Test deprecated flag'", (IStatus)status);
            ClasspathInitializerTests.assertFalse((String)"Status should not be OK", (boolean)status.isOK());
            ClasspathInitializerTests.assertEquals((String)"Status should have WARNING severity", (int)2, (int)status.getSeverity());
            ClasspathInitializerTests.assertEquals((String)"Status should have deprecated code", (int)1010, (int)status.getCode());
        }
        finally {
            VariablesInitializer.reset();
            this.deleteProject("P1");
        }
    }

    public void testVariableInitializerUnboundAndDeprecated() throws CoreException {
        try {
            String varName = "TEST_DEPRECATED";
            String filePath = "/P1/lib.jar";
            VariablesInitializer.setInitializer(new DefaultVariableInitializer(new String[]{varName, filePath}));
            ClasspathInitializerTests.assertEquals((String)"JavaScriptCore classpath value should have been initialized", (String)JavaScriptCore.getIncludepathVariable((String)varName).toString(), (String)filePath);
            ClasspathInitializerTests.assertEquals((String)"JavaScriptCore classpath variable should be deprecated", (String)"Test deprecated flag", (String)JavaScriptCore.getIncludepathVariableDeprecationMessage((String)varName));
            IJavaScriptProject project = this.createJavaProject("P1");
            IIncludePathEntry variable = JavaScriptCore.newVariableEntry((IPath)new Path("TEST_DEPRECATED"), null, null);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspathEntry((IJavaScriptProject)project, (IIncludePathEntry)variable, (boolean)false);
            this.assertStatus("Project P1 is missing required library: 'lib.jar'", (IStatus)status);
            ClasspathInitializerTests.assertFalse((String)"Status should not be OK", (boolean)status.isOK());
            ClasspathInitializerTests.assertEquals((String)"Status should have WARNING severity", (int)4, (int)status.getSeverity());
            ClasspathInitializerTests.assertEquals((String)"Status should have deprecated code", (int)964, (int)status.getCode());
        }
        finally {
            VariablesInitializer.reset();
            this.deleteProject("P1");
        }
    }

    public void testVariableInitializerReadOnly() throws CoreException {
        try {
            String varName = "TEST_READ_ONLY";
            String path = "/P1/lib.jar";
            VariablesInitializer.setInitializer(new DefaultVariableInitializer(new String[]{varName, path}));
            ClasspathInitializerTests.assertEquals((String)"JavaScriptCore classpath value should have been initialized", (String)JavaScriptCore.getIncludepathVariable((String)varName).toString(), (String)path);
            ClasspathInitializerTests.assertTrue((String)"JavaScriptCore classpath variable should be read-only", (boolean)JavaScriptCore.isIncludepathVariableReadOnly((String)varName));
            IJavaScriptProject project = this.createJavaProject("P1");
            this.createFile("/P1/lib.jar", "");
            IIncludePathEntry variable = JavaScriptCore.newVariableEntry((IPath)new Path("TEST_READ_ONLY"), null, null);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspathEntry((IJavaScriptProject)project, (IIncludePathEntry)variable, (boolean)false);
            this.assertStatus("OK", (IStatus)status);
            ClasspathInitializerTests.assertTrue((String)"Status should be OK", (boolean)status.isOK());
            ClasspathInitializerTests.assertEquals((String)"Status should be VERIFIED_OK", (Object)JavaModelStatus.VERIFIED_OK, (Object)status);
        }
        finally {
            VariablesInitializer.reset();
            this.deleteProject("P1");
        }
    }

    public void testVariableInitializerDeprecatedAndReadOnly() throws CoreException {
        try {
            String varName = "TEST_DEPRECATED_READ_ONLY";
            String path = "/P1/lib.jar";
            VariablesInitializer.setInitializer(new DefaultVariableInitializer(new String[]{varName, path}));
            ClasspathInitializerTests.assertEquals((String)"JavaScriptCore classpath value should have been initialized", (String)JavaScriptCore.getIncludepathVariable((String)varName).toString(), (String)path);
            ClasspathInitializerTests.assertEquals((String)"JavaScriptCore classpath variable should be deprecated", (String)"A deprecated and read-only initializer", (String)JavaScriptCore.getIncludepathVariableDeprecationMessage((String)varName));
            ClasspathInitializerTests.assertTrue((String)"JavaScriptCore classpath variable should be read-only", (boolean)JavaScriptCore.isIncludepathVariableReadOnly((String)varName));
            IJavaScriptProject project = this.createJavaProject("P1");
            this.createFile("/P1/lib.jar", "");
            IIncludePathEntry variable = JavaScriptCore.newVariableEntry((IPath)new Path("TEST_DEPRECATED_READ_ONLY"), null, null);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspathEntry((IJavaScriptProject)project, (IIncludePathEntry)variable, (boolean)false);
            this.assertStatus("Classpath variable 'TEST_DEPRECATED_READ_ONLY' in project P1 is deprecated: 'A deprecated and read-only initializer'", (IStatus)status);
            ClasspathInitializerTests.assertFalse((String)"Status should not be OK", (boolean)status.isOK());
            ClasspathInitializerTests.assertEquals((String)"Status should have WARNING severity", (int)2, (int)status.getSeverity());
            ClasspathInitializerTests.assertEquals((String)"Status should have deprecated code", (int)1010, (int)status.getCode());
        }
        finally {
            VariablesInitializer.reset();
            this.deleteProject("P1");
        }
    }

    public void testVariableInitializerBug172207() throws CoreException {
        try {
            String varName = "TEST_DEPRECATED_READ_ONLY";
            String path = "/P1/lib.jar";
            VariablesInitializer.setInitializer(new DefaultVariableInitializer(new String[]{varName, path}));
            ClasspathInitializerTests.assertEquals((String)"JavaScriptCore classpath value should have been initialized", (String)JavaScriptCore.getIncludepathVariable((String)varName).toString(), (String)path);
            ClasspathInitializerTests.assertEquals((String)"JavaScriptCore classpath variable should be deprecated", (String)"A deprecated and read-only initializer", (String)JavaScriptCore.getIncludepathVariableDeprecationMessage((String)varName));
            ClasspathInitializerTests.assertTrue((String)"JavaScriptCore classpath variable should be read-only", (boolean)JavaScriptCore.isIncludepathVariableReadOnly((String)varName));
            IJavaScriptProject project = this.createJavaProject("P1");
            this.createFile("/P1/lib.jar", "");
            IIncludePathEntry variable = JavaScriptCore.newVariableEntry((IPath)new Path("TEST_DEPRECATED_READ_ONLY"), null, null);
            IIncludePathEntry[] entries = project.getRawIncludepath();
            int length = entries.length;
            IIncludePathEntry[] iIncludePathEntryArray = entries;
            entries = new IIncludePathEntry[length + 1];
            System.arraycopy(iIncludePathEntryArray, 0, entries, 0, length);
            entries[length] = variable;
            project.setRawIncludepath(entries, null);
            ClasspathInitializerTests.waitForAutoBuild();
            IMarker[] markers = project.getProject().findMarkers("org.eclipse.wst.jsdt.core.buildpath_problem", false, 0);
            this.sortMarkers(markers);
            this.assertMarkers("Unexpected marker(s)", "Classpath variable 'TEST_DEPRECATED_READ_ONLY' in project P1 is deprecated: 'A deprecated and read-only initializer'", markers);
            ClasspathInitializerTests.assertEquals((String)"Marker on deprecated variable should be a WARNING", (int)1, (int)markers[0].getAttribute("severity", -1));
        }
        finally {
            VariablesInitializer.reset();
            this.deleteProject("P1");
        }
    }

    public void testUserLibraryInitializer1() throws CoreException {
        try {
            JsGlobalScopeContainerInitializer initializer = JavaScriptCore.getJsGlobalScopeContainerInitializer((String)"org.eclipse.wst.jsdt.USER_LIBRARY");
            String libraryName = "SWT";
            Path containerPath = new Path("org.eclipse.wst.jsdt.USER_LIBRARY");
            UserLibraryJsGlobalScopeContainer containerSuggestion = new UserLibraryJsGlobalScopeContainer(libraryName);
            initializer.requestJsGlobalScopeContainerUpdate(containerPath.append(libraryName), null, (IJsGlobalScopeContainer)containerSuggestion);
            this.createJavaProject("p61872");
            IFile jarFile = this.createFile("/p61872/swt.jar", "");
            IFile srcFile = this.createFile("/p61872/swtsrc.zip", "");
            Preferences preferences = JavaScriptCore.getPlugin().getPluginPreferences();
            String propertyName = "org.eclipse.wst.jsdt.core.userLibrary.SWT";
            StringBuffer propertyValue = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<userlibrary systemlibrary=\"false\" version=\"1\">\r\n<archive");
            String jarFullPath = this.getWorkspaceRoot().getLocation().append(jarFile.getFullPath()).toString();
            propertyValue.append(" path=\"" + jarFullPath);
            propertyValue.append("\"/>\r\n</userlibrary>\r\n");
            preferences.setValue(propertyName, propertyValue.toString());
            JavaScriptCore.getPlugin().savePluginPreferences();
            this.editFile("/p61872/.classpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry kind=\"con\" path=\"org.eclipse.wst.jsdt.USER_LIBRARY/SWT\"/>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>");
            IIncludePathEntry[] entries = this.getJavaProject("p61872").getResolvedIncludepath(true);
            ClasspathInitializerTests.assertEquals((String)"Invalid entries number in resolved classpath for project p61872!", (int)1, (int)entries.length);
            ClasspathInitializerTests.assertEquals((String)"Invalid path for project 61872 classpath entry!", (String)jarFullPath.toLowerCase(), (String)entries[0].getPath().toString().toLowerCase());
            ClasspathInitializerTests.assertNull((String)"Project 61872 classpath entry should not have any source attached!", (Object)entries[0].getSourceAttachmentPath());
            propertyValue = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<userlibrary systemlibrary=\"false\" version=\"1\">\r\n<archive");
            String srcFullPath = this.getWorkspaceRoot().getLocation().append(srcFile.getFullPath()).toString();
            propertyValue.append(" sourceattachment=\"" + srcFullPath);
            propertyValue.append("\" path=\"" + jarFullPath);
            propertyValue.append("\"/>\r\n</userlibrary>\r\n");
            preferences.setValue(propertyName, propertyValue.toString());
            JavaScriptCore.getPlugin().savePluginPreferences();
            entries = this.getJavaProject("p61872").getResolvedIncludepath(true);
            ClasspathInitializerTests.assertEquals((String)"Invalid entries number in resolved classpath for project p61872!", (int)1, (int)entries.length);
            ClasspathInitializerTests.assertEquals((String)"Invalid path for project 61872 classpath entry!", (String)jarFullPath.toLowerCase(), (String)entries[0].getPath().toString().toLowerCase());
            ClasspathInitializerTests.assertEquals((String)"Invalid source attachement path for project 61872 classpath entry!", (String)srcFullPath.toLowerCase(), (String)entries[0].getSourceAttachmentPath().toString().toLowerCase());
        }
        finally {
            this.deleteProject("p61872");
        }
    }

    public static class DefaultContainerInitializer
    implements ContainerInitializer.ITestInitializer {
        Map containerValues = new HashMap();
        CoreException exception;

        public DefaultContainerInitializer(String[] values) {
            int i = 0;
            while (i < values.length) {
                String projectName = values[i];
                char[][] libPaths = CharOperation.splitOn((char)',', (char[])values[i + 1].toCharArray());
                this.containerValues.put(projectName, this.newContainer(libPaths));
                i += 2;
            }
        }

        protected DefaultContainer newContainer(char[][] libPaths) {
            return new DefaultContainer(libPaths);
        }

        @Override
        public boolean allowFailureContainer() {
            return true;
        }

        @Override
        public void initialize(IPath containerPath, IJavaScriptProject project) throws CoreException {
            if (this.containerValues == null) {
                return;
            }
            try {
                JavaScriptCore.setJsGlobalScopeContainer((IPath)containerPath, (IJavaScriptProject[])new IJavaScriptProject[]{project}, (IJsGlobalScopeContainer[])new IJsGlobalScopeContainer[]{(IJsGlobalScopeContainer)this.containerValues.get(project.getElementName())}, null);
            }
            catch (CoreException e) {
                this.exception = e;
                throw e;
            }
        }

        public static class DefaultContainer
        implements IJsGlobalScopeContainer {
            char[][] libPaths;

            public DefaultContainer(char[][] libPaths) {
                this.libPaths = libPaths;
            }

            public IIncludePathEntry[] getClasspathEntries() {
                return this.getIncludepathEntries();
            }

            public IIncludePathEntry[] getIncludepathEntries() {
                int length = this.libPaths.length;
                IIncludePathEntry[] entries = new IIncludePathEntry[length];
                int j = 0;
                while (j < length) {
                    Path path = new Path(new String(this.libPaths[j]));
                    entries[j] = path.segmentCount() == 1 ? JavaScriptCore.newProjectEntry((IPath)path) : JavaScriptCore.newLibraryEntry((IPath)path, null, null);
                    ++j;
                }
                return entries;
            }

            public String getDescription() {
                return "Test container";
            }

            public int getKind() {
                return 1;
            }

            public IPath getPath() {
                return new Path("org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER");
            }

            public String[] resolvedLibraryImport(String a) {
                return new String[]{a};
            }
        }
    }

    public static class DefaultVariableInitializer
    implements VariablesInitializer.ITestInitializer {
        Map variableValues = new HashMap();

        public DefaultVariableInitializer(String[] values) {
            int i = 0;
            while (i < values.length) {
                this.variableValues.put(values[i], new Path(values[i + 1]));
                i += 2;
            }
        }

        @Override
        public void initialize(String variable) throws JavaScriptModelException {
            if (this.variableValues == null) {
                return;
            }
            JavaScriptCore.setIncludepathVariable((String)variable, (IPath)((IPath)this.variableValues.get(variable)), null);
        }
    }

    public class NullContainerInitializer
    implements ContainerInitializer.ITestInitializer {
        public boolean hasRun = false;

        @Override
        public boolean allowFailureContainer() {
            return false;
        }

        @Override
        public void initialize(IPath containerPath, IJavaScriptProject project) throws CoreException {
            this.hasRun = true;
            JavaScriptCore.setJsGlobalScopeContainer((IPath)containerPath, (IJavaScriptProject[])new IJavaScriptProject[]{project}, (IJsGlobalScopeContainer[])new IJsGlobalScopeContainer[1], null);
        }
    }
}

