/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.ISourceManipulation;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.CopyMoveTests;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CopyMoveResourcesTests
extends CopyMoveTests {
    public CopyMoveResourcesTests(String name) {
        super(name);
    }

    @Override
    public IJavaScriptElement copyPositive(IJavaScriptElement element, IJavaScriptElement container, IJavaScriptElement sibling, String rename, boolean force) throws JavaScriptModelException {
        try {
            IJavaScriptElementDelta destDelta;
            this.startDeltas();
            if (force) {
                IJavaScriptElement collision = this.generateHandle(element, rename, container);
                CopyMoveResourcesTests.assertTrue((String)"Collision does not exist", (boolean)collision.exists());
            }
            ((ISourceManipulation)element).copy(container, sibling, rename, force, null);
            CopyMoveResourcesTests.assertTrue((String)"The original element must still exist", (boolean)element.exists());
            IJavaScriptElement copy = this.generateHandle(element, rename, container);
            CopyMoveResourcesTests.assertTrue((String)"Copy should exist", (boolean)copy.exists());
            if (element.getElementType() > 5) {
                this.ensureCorrectPositioning((IParent)container, sibling, copy);
            }
            CopyMoveResourcesTests.assertTrue((String)"Destination container not changed", ((destDelta = this.getDeltaFor(container, true)) != null && destDelta.getKind() == 4 ? 1 : 0) != 0);
            IJavaScriptElementDelta[] deltas = destDelta.getAddedChildren();
            boolean found = false;
            int i = 0;
            while (i < deltas.length) {
                if (deltas[i].getElement().equals(copy)) {
                    found = true;
                }
                ++i;
            }
            CopyMoveResourcesTests.assertTrue((String)"Added children not correct for element copy", (boolean)found);
            IJavaScriptElement iJavaScriptElement = copy;
            return iJavaScriptElement;
        }
        finally {
            this.stopDeltas();
        }
    }

    @Override
    public void movePositive(IJavaScriptElement[] elements, IJavaScriptElement[] destinations, IJavaScriptElement[] siblings, String[] names, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        try {
            int i;
            this.startDeltas();
            if (force) {
                i = 0;
                while (i < elements.length) {
                    IJavaScriptElement e = elements[i];
                    IJavaScriptElement collision = null;
                    collision = names == null ? this.generateHandle(e, null, destinations[i]) : this.generateHandle(e, names[i], destinations[i]);
                    CopyMoveResourcesTests.assertTrue((String)"Collision does not exist", (boolean)collision.exists());
                    ++i;
                }
            }
            this.getJavaModel().move(elements, destinations, siblings, names, force, monitor);
            i = 0;
            while (i < elements.length) {
                IJavaScriptElementDelta[] deltas;
                IJavaScriptElement element = elements[i];
                IJavaScriptElement moved = null;
                moved = names == null ? this.generateHandle(element, null, destinations[i]) : this.generateHandle(element, names[i], destinations[i]);
                if (!(destinations[i].equals(element.getParent()) || element.getElementType() == 5 && ((IJavaScriptUnit)element).isWorkingCopy())) {
                    CopyMoveResourcesTests.assertTrue((String)"The original element must not exist", (!element.exists() ? 1 : 0) != 0);
                }
                CopyMoveResourcesTests.assertTrue((String)"Moved element should exist", (boolean)moved.exists());
                IJavaScriptElementDelta destDelta = null;
                if (this.isMainType(element, destinations[i]) && names != null && names[i] != null) {
                    destDelta = this.getDeltaFor(moved.getParent());
                    CopyMoveResourcesTests.assertTrue((String)"Renamed compilation unit as result of main type not added", (destDelta != null && destDelta.getKind() == 1 ? 1 : 0) != 0);
                    deltas = destDelta.getAddedChildren();
                    CopyMoveResourcesTests.assertTrue((String)"Added children not correct for element copy", (boolean)deltas[0].getElement().equals(moved));
                    CopyMoveResourcesTests.assertTrue((String)"flag should be F_MOVED_FROM", ((deltas[0].getFlags() & 0x10) > 0 ? 1 : 0) != 0);
                    CopyMoveResourcesTests.assertTrue((String)"moved from handle should be original", (boolean)deltas[0].getMovedFromElement().equals(element));
                } else {
                    destDelta = this.getDeltaFor(destinations[i], true);
                    CopyMoveResourcesTests.assertTrue((String)"Destination container not changed", (destDelta != null && destDelta.getKind() == 4 ? 1 : 0) != 0);
                    deltas = destDelta.getAddedChildren();
                    int j = 0;
                    while (j < deltas.length - 1) {
                        IJavaScriptElement pkg = deltas[j].getElement();
                        CopyMoveResourcesTests.assertTrue((String)"Side effect child should be a package fragment", (pkg.getElementType() == 4 ? 1 : 0) != 0);
                        CopyMoveResourcesTests.assertTrue((String)"Side effect child should be an enclosing package", (boolean)element.getElementName().startsWith(pkg.getElementName()));
                        ++j;
                    }
                    IJavaScriptElementDelta pkgDelta = deltas[deltas.length - 1];
                    CopyMoveResourcesTests.assertTrue((String)"Added children not correct for element copy", (boolean)pkgDelta.getElement().equals(moved));
                    CopyMoveResourcesTests.assertTrue((String)"flag should be F_MOVED_FROM", ((pkgDelta.getFlags() & 0x10) > 0 ? 1 : 0) != 0);
                    CopyMoveResourcesTests.assertTrue((String)"moved from handle shoud be original", (boolean)pkgDelta.getMovedFromElement().equals(element));
                    IJavaScriptElementDelta sourceDelta = this.getDeltaFor(element, true);
                    CopyMoveResourcesTests.assertTrue((String)"moved to handle should be original", (boolean)sourceDelta.getMovedToElement().equals(moved));
                }
                ++i;
            }
        }
        finally {
            this.stopDeltas();
        }
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createJavaProject("P", new String[]{"src", "src2"});
    }

    public static Test suite() {
        return CopyMoveResourcesTests.buildModelTestSuite(CopyMoveResourcesTests.class);
    }

    @Override
    public void tearDown() throws Exception {
        this.deleteProject("P");
        super.tearDown();
    }

    public void testCopyCUAndType() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.copyNegative(new IJavaScriptElement[]{cuSource, cuSource.getType("X")}, new IJavaScriptElement[]{cuSource.getParent(), cuSource}, null, new String[]{"Y.js", "Y"}, false, 967);
    }

    public void testCopyCUForce() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/X.js", "package p2;\npublic class X {\n}");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.copyPositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, null, true);
    }

    public void testCopyCURename() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.copyPositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, "Y.js", false);
    }

    public void testCopyCUReadOnly() throws CoreException {
        if (!Util.isReadOnlySupported()) {
            return;
        }
        IFile file = null;
        IFile file2 = null;
        try {
            this.createFolder("/P/src/p1");
            file = this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
            Util.setReadOnly((IResource)file, (boolean)true);
            IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
            this.createFolder("/P/src/p2");
            IPackageFragment pkgDest = this.getPackage("/P/src/p2");
            this.copyPositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, null, false);
            file2 = this.getFile("/P/src/p2/X.js");
            CopyMoveResourcesTests.assertTrue((String)"Destination cu should be read-only", (boolean)file2.isReadOnly());
        }
        catch (Throwable throwable) {
            if (file != null) {
                Util.setReadOnly(file, (boolean)false);
            }
            if (file2 != null) {
                Util.setReadOnly(file2, (boolean)false);
            }
            this.deleteFolder("/P/src/p1");
            this.deleteFolder("/P/src/p2");
            throw throwable;
        }
        if (file != null) {
            Util.setReadOnly((IResource)file, (boolean)false);
        }
        if (file2 != null) {
            Util.setReadOnly((IResource)file2, (boolean)false);
        }
        this.deleteFolder("/P/src/p1");
        this.deleteFolder("/P/src/p2");
    }

    public void testCopyCURenameForce() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/Y.js", "package p2;\npublic class Y {\n}");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.copyPositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, "Y.js", true);
    }

    public void testCopyCUWithCollision() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/X.js", "package p2;\npublic class X {\n}");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.copyNegative((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, null, false, 977);
    }

    public void testCopyCUWithInvalidDestination() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.copyNegative((IJavaScriptElement)cuSource, (IJavaScriptElement)cuSource, null, null, false, 978);
    }

    public void testCopyCUWithNullContainer() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        try {
            cuSource.copy(null, null, null, false, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        CopyMoveResourcesTests.assertTrue((String)"Should not be able to move a cu to a null container", (boolean)false);
    }

    public void testCopyCUWithServerProperties() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        QualifiedName qualifiedName = new QualifiedName("x.y.z", "a property");
        cuSource.getUnderlyingResource().setPersistentProperty(qualifiedName, "some value");
        this.createFolder("/P/src/p2");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.copyPositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, null, false);
        IJavaScriptUnit cu = pkgDest.getJavaScriptUnit("X.js");
        String propertyValue = cu.getUnderlyingResource().getPersistentProperty(qualifiedName);
        CopyMoveResourcesTests.assertEquals((String)"Server property should be copied with cu", (String)"some value", (String)propertyValue);
    }

    public void testCopyPackageFragment() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IPackageFragment pkgSource = this.getPackage("/P/src/p1");
        IPackageFragmentRoot rootDest = this.getPackageFragmentRoot("P", "src2");
        this.copyPositive((IJavaScriptElement)pkgSource, (IJavaScriptElement)rootDest, null, null, false);
    }

    public void testCopyReadOnlyPackageFragment() throws CoreException {
        if (!Util.isReadOnlySupported()) {
            return;
        }
        IPackageFragment pkgSource = null;
        IPackageFragment pkg2 = null;
        try {
            this.createFolder("/P/src/p1/p2/p3");
            this.createFile("/P/src/p1/p2/p3/X.js", "package p1.p2.p3;\npublic class X {\n}");
            Util.setReadOnly((IResource)this.getFile("/P/src/p1/p2/p3/X.js"), (boolean)true);
            pkgSource = this.getPackage("/P/src/p1");
            Util.setReadOnly((IResource)pkgSource.getResource(), (boolean)true);
            pkg2 = this.getPackage("/P/src/p1/p2/p3");
            Util.setReadOnly((IResource)pkg2.getResource(), (boolean)true);
            IPackageFragmentRoot rootDest = this.getPackageFragmentRoot("P", "src2");
            this.copyPositive((IJavaScriptElement)pkg2, (IJavaScriptElement)rootDest, null, null, false);
            CopyMoveResourcesTests.assertTrue((String)"Not readOnly", (boolean)Util.isReadOnly((IResource)this.getPackage("/P/src2/p1").getResource()));
            CopyMoveResourcesTests.assertTrue((String)"Is readOnly", (!Util.isReadOnly((IResource)this.getPackage("/P/src2/p1/p2").getResource()) ? 1 : 0) != 0);
            CopyMoveResourcesTests.assertTrue((String)"Not readOnly", (boolean)Util.isReadOnly((IResource)this.getPackage("/P/src2/p1/p2/p3").getResource()));
            CopyMoveResourcesTests.assertTrue((String)"Is readOnly", (boolean)Util.isReadOnly((IResource)this.getFile("/P/src2/p1/p2/p3/X.js")));
        }
        finally {
            IFile xFile;
            IPackageFragment p3Fragment;
            IPackageFragment p1Fragment;
            IFile xSrcFile = this.getFile("/P/src/p1/p2/p3/X.js");
            if (xSrcFile != null) {
                Util.setReadOnly((IResource)xSrcFile, (boolean)false);
            }
            if (pkg2 != null) {
                Util.setReadOnly((IResource)pkg2.getResource(), (boolean)false);
            }
            if (pkgSource != null) {
                Util.setReadOnly((IResource)pkgSource.getResource(), (boolean)false);
            }
            if ((p1Fragment = this.getPackage("/P/src2/p1")) != null) {
                Util.setReadOnly((IResource)p1Fragment.getResource(), (boolean)false);
            }
            if ((p3Fragment = this.getPackage("/P/src2/p1/p2/p3")) != null) {
                Util.setReadOnly((IResource)p3Fragment.getResource(), (boolean)false);
            }
            if ((xFile = this.getFile("/P/src2/p1/p2/p3/X.js")) != null) {
                Util.setReadOnly((IResource)xFile, (boolean)false);
            }
            this.deleteFolder("/P/src/p1");
        }
    }

    public void testCopyWorkingCopy() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createFolder("/P/src/p1");
            this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
            IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
            copy = cuSource.getWorkingCopy(null);
            this.createFolder("/P/src/p2");
            IPackageFragment pkgDest = this.getPackage("/P/src/p2");
            this.copyPositive((IJavaScriptElement)copy, (IJavaScriptElement)pkgDest, null, null, false);
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }

    public void testCopyWorkingCopyDestination() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createFolder("/P/src/p1");
            this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n  void foo() {}\n}");
            IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
            this.createFolder("/P/src/p2");
            IPackageFragment pkgDest = this.getPackage("/P/src/p2");
            this.createFile("/P/src/p2/X.js", "\npackage p1;\npublic class X {\n}");
            copy = this.getCompilationUnit("/P/src/p2/X.js");
            copy.becomeWorkingCopy(null);
            this.copyPositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, null, true);
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }

    public void testCopyWorkingCopyForce() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createFolder("/P/src/p1");
            this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
            IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
            copy = cuSource.getWorkingCopy(null);
            this.createFolder("/P/src/p2");
            this.createFile("/P/src/p2/X.js", "package p2;\npublic class X {\n}");
            IPackageFragment pkgDest = this.getPackage("/P/src/p2");
            this.copyPositive((IJavaScriptElement)copy, (IJavaScriptElement)pkgDest, null, null, true);
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }

    public void testCopyWorkingCopyRename() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createFolder("/P/src/p1");
            this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
            IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
            copy = cuSource.getWorkingCopy(null);
            this.createFolder("/P/src/p2");
            IPackageFragment pkgDest = this.getPackage("/P/src/p2");
            this.copyPositive((IJavaScriptElement)copy, (IJavaScriptElement)pkgDest, null, "Y.js", false);
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }

    public void testCopyWorkingCopyRenameForce() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createFolder("/P/src/p1");
            this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
            IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
            copy = cuSource.getWorkingCopy(null);
            this.createFolder("/P/src/p2");
            this.createFile("/P/src/p2/Y.js", "package p2;\npublic class Y {\n}");
            IPackageFragment pkgDest = this.getPackage("/P/src/p2");
            this.copyPositive((IJavaScriptElement)copy, (IJavaScriptElement)pkgDest, null, "Y.js", true);
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }

    public void testCopyWorkingCopyWithCollision() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createFolder("/P/src/p1");
            this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
            IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
            copy = cuSource.getWorkingCopy(null);
            this.createFolder("/P/src/p2");
            this.createFile("/P/src/p2/X.js", "package p2;\npublic class X {\n}");
            IPackageFragment pkgDest = this.getPackage("/P/src/p2");
            this.copyNegative((IJavaScriptElement)copy, (IJavaScriptElement)pkgDest, null, null, false, 977);
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }

    public void testCopyWorkingCopyWithInvalidDestination() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createFolder("/P/src/p1");
            this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
            IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
            copy = cuSource.getWorkingCopy(null);
            this.copyNegative((IJavaScriptElement)copy, (IJavaScriptElement)cuSource, null, null, false, 978);
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }

    public void testMoveCUAndType() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.moveNegative(new IJavaScriptElement[]{cuSource, cuSource.getType("X")}, new IJavaScriptElement[]{cuSource.getParent(), cuSource}, null, new String[]{"Y.js", "Y"}, false, 967);
    }

    public void testMoveCUForce() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/X.js", "package p2;\npublic class X {\n}");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.movePositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, null, true);
    }

    public void testMoveCURename() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.movePositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, "Y.js", false);
    }

    public void testMoveCURenameForce() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/Y.js", "package p2;\npublic class Y {\n}");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.movePositive((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, "Y.js", true);
    }

    public void testMoveCUWithCollision() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/X.js", "package p2;\npublic class X {\n}");
        IPackageFragment pkgDest = this.getPackage("/P/src/p2");
        this.moveNegative((IJavaScriptElement)cuSource, (IJavaScriptElement)pkgDest, null, null, false, 977);
    }

    public void testMoveCUWithInvalidDestination() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        this.moveNegative((IJavaScriptElement)cuSource, (IJavaScriptElement)cuSource, null, null, false, 978);
    }

    public void testMoveCUWithNullContainer() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
        try {
            cuSource.move(null, null, null, false, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        CopyMoveResourcesTests.assertTrue((String)"Should not be able to move a cu to a null container", (boolean)false);
    }

    public void testMovePackageFragment() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
        IPackageFragment pkgSource = this.getPackage("/P/src/p1");
        IPackageFragmentRoot rootDest = this.getPackageFragmentRoot("P", "src2");
        this.movePositive((IJavaScriptElement)pkgSource, (IJavaScriptElement)rootDest, null, null, false);
    }

    public void testMoveReadOnlyPackageFragment() throws CoreException {
        if (!Util.isReadOnlySupported()) {
            return;
        }
        IPackageFragment pkgSource = null;
        IPackageFragment pkg2 = null;
        try {
            this.createFolder("/P/src/p1/p2/p3");
            this.createFile("/P/src/p1/p2/p3/X.js", "package p1.p2.p3;\npublic class X {\n}");
            Util.setReadOnly((IResource)this.getFile("/P/src/p1/p2/p3/X.js"), (boolean)true);
            pkgSource = this.getPackage("/P/src/p1");
            Util.setReadOnly((IResource)pkgSource.getResource(), (boolean)true);
            pkg2 = this.getPackage("/P/src/p1/p2/p3");
            Util.setReadOnly((IResource)pkg2.getResource(), (boolean)true);
            IPackageFragmentRoot rootDest = this.getPackageFragmentRoot("P", "src2");
            this.movePositive((IJavaScriptElement)pkg2, (IJavaScriptElement)rootDest, null, null, false);
            CopyMoveResourcesTests.assertTrue((String)"Not readOnly", (boolean)Util.isReadOnly((IResource)this.getPackage("/P/src2/p1").getResource()));
            CopyMoveResourcesTests.assertTrue((String)"Is readOnly", (!Util.isReadOnly((IResource)this.getPackage("/P/src2/p1/p2").getResource()) ? 1 : 0) != 0);
            CopyMoveResourcesTests.assertTrue((String)"Not readOnly", (boolean)Util.isReadOnly((IResource)this.getPackage("/P/src2/p1/p2/p3").getResource()));
            CopyMoveResourcesTests.assertTrue((String)"Is readOnly", (boolean)Util.isReadOnly((IResource)this.getFile("/P/src2/p1/p2/p3/X.js")));
        }
        finally {
            IFile xFile;
            IPackageFragment p3Fragment;
            IPackageFragment p1Fragment;
            IFile xSrcFile = this.getFile("/P/src/p1/p2/p3/X.js");
            if (xSrcFile != null) {
                Util.setReadOnly((IResource)xSrcFile, (boolean)false);
            }
            if (pkg2 != null) {
                Util.setReadOnly((IResource)pkg2.getResource(), (boolean)false);
            }
            if (pkgSource != null) {
                Util.setReadOnly((IResource)pkgSource.getResource(), (boolean)false);
            }
            if ((p1Fragment = this.getPackage("/P/src2/p1")) != null) {
                Util.setReadOnly((IResource)p1Fragment.getResource(), (boolean)false);
            }
            if ((p3Fragment = this.getPackage("/P/src2/p1/p2/p3")) != null) {
                Util.setReadOnly((IResource)p3Fragment.getResource(), (boolean)false);
            }
            if ((xFile = this.getFile("/P/src2/p1/p2/p3/X.js")) != null) {
                Util.setReadOnly((IResource)xFile, (boolean)false);
            }
            this.deleteFolder("/P/src/p1");
        }
    }

    public void testMoveWorkingCopy() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createFolder("/P/src/p1");
            this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
            IJavaScriptUnit cuSource = this.getCompilationUnit("/P/src/p1/X.js");
            copy = cuSource.getWorkingCopy(null);
            this.createFolder("/P/src/p2");
            IPackageFragment pkgDest = this.getPackage("/P/src/p2");
            this.moveNegative((IJavaScriptElement)copy, (IJavaScriptElement)pkgDest, null, null, false, 967);
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }

    public void testMoveWorkingCopy2() throws CoreException {
        IJavaScriptUnit copy = null;
        try {
            this.createFolder("/P/src/p1");
            this.createFile("/P/src/p1/X.js", "package p1;\npublic class X {\n}");
            copy = this.getCompilationUnit("/P/src/p1/X.js");
            copy.becomeWorkingCopy(null);
            this.createFolder("/P/src/p2");
            IPackageFragment pkgDest = this.getPackage("/P/src/p2");
            this.movePositive((IJavaScriptElement)copy, (IJavaScriptElement)pkgDest, null, null, false);
            CopyMoveResourcesTests.assertTrue((String)"Should not have unsaved changes", (!copy.getBuffer().hasUnsavedChanges() ? 1 : 0) != 0);
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }
}

