/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.modifying;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.modifying.ASTRewritingModifyingTest;

public class ASTRewritingModifyingOtherTest
extends ASTRewritingModifyingTest {
    private static final Class THIS = ASTRewritingModifyingOtherTest.class;

    public ASTRewritingModifyingOtherTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test suite() {
        return ASTRewritingModifyingOtherTest.allTests();
    }

    public void test0000() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0000", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("var test0000;\n");
        buf.append("function X {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        try {
            this.evaluateRewrite(cu, astRoot);
            ASTRewritingModifyingOtherTest.assertTrue((String)"rewrite did not fail even though recording not on", (boolean)false);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void test0001() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0001", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("var test0001;\n");
        buf.append("function X() {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("var test0001;\n");
        buf.append("function X() {\n");
        buf.append("}\n");
        ASTRewritingModifyingOtherTest.assertEqualString(preview, buf.toString());
    }

    public void test0003() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test0003", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Y() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("X.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createCU(cu, false);
        astRoot.recordModifications();
        AST a = astRoot.getAST();
        List functions = astRoot.statements();
        FunctionDeclaration functionDeclaration1 = a.newFunctionDeclaration();
        functionDeclaration1.setName(a.newSimpleName("A"));
        functions.add(1, functionDeclaration1);
        functions.remove(1);
        String preview = this.evaluateRewrite(cu, astRoot);
        buf = new StringBuffer();
        buf.append("function X() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Y() {\n");
        buf.append("\n");
        buf.append("}\n");
        buf.append("function Z() {\n");
        buf.append("\n");
        buf.append("}\n");
        ASTRewritingModifyingOtherTest.assertEqualString(preview, buf.toString());
    }
}

